/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.ejb.mbeans;

import agorum.commons.cron.Trace;
import agorum.commons.server.ServiceUtils;
import agorum.commons.statistic.Statistic;
import agorum.documentservice.client.common.DocumentServiceStatistic;
import agorum.roi.ejb.common.AXOCache;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.FolderPathUtil;
import agorum.roi.ejb.common.GenericMultiQueueBean;
import agorum.roi.ejb.common.GenericMultiQueueHelper;
import agorum.roi.ejb.common.LuceneProperties;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.ejb.common.TransactionProperties;
import agorum.roi.ejb.mbeans.ToTextIndexInfo;
import agorum.roi.lucene.ejb.beans.RoiIndexSyncBean;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.searchengine.DocumentServiceSearchEngineIndexSystemStatistic;
import agorum.roi.statistic.searchengine.IndexStatistic;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.List;

public class TextIndexService {
    private static final String STICKY_WARNING_NO_INDEXING_PROGRESS = "STICKY_WARNING_NO_INDEXING_PROGRESS";
    private static final String QUEUE_IDENT = "ExportIndexFSOnly";
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/";
    private static final IndexStatistic stat = IndexStatistic.getInstance();
    private static final DocumentServiceSearchEngineIndexSystemStatistic statisticHandlerIndex = new DocumentServiceSearchEngineIndexSystemStatistic();
    private static final Thread thread = new Thread(() -> {
        Trace.Auto trace = Trace.auto((String)"Text index service");
        Throwable throwable = null;
        try {
            try {
                while (true) {
                    try {
                        while (true) {
                            trace.waiting("Sleeping");
                            TextIndexService.sleep(10000L);
                            trace.working("Working");
                            TextIndexService.work(trace);
                        }
                    }
                    catch (Exception e) {
                        trace.failed();
                        stat.error(e);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Throwable throwable3) {
            if (trace != null) {
                if (throwable != null) {
                    try {
                        trace.close();
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                } else {
                    trace.close();
                }
            }
            throw throwable3;
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleep(long timeout) throws InterruptedException {
        Thread thread = TextIndexService.thread;
        synchronized (thread) {
            TextIndexService.thread.wait(timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void wake() {
        Thread thread = TextIndexService.thread;
        synchronized (thread) {
            TextIndexService.thread.notifyAll();
        }
    }

    private static void work(Trace.Auto trace) {
        try {
            boolean hasMore;
            trace.starting();
            SessionController sc = SessionControllerAdmin.getService(TextIndexService.class);
            do {
                sc.reconnectIfNeeded();
                LuceneProperties lp = new LuceneProperties(sc);
                if (!lp.indexEnabled() || SessionController.getImportMode()) {
                    stat.setServiceStatus(Statistic.ServiceStatus.DISABLED);
                    return;
                }
                stat.setServiceStatus(Statistic.ServiceStatus.RUNNING);
                trace.working("Checking index export settings");
                try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(statisticHandlerIndex);){
                    indexHandler.loadIndexExportSettings(sc);
                    indexHandler.initPostIndex();
                }
                sc.cleanupIndexHash();
                trace.working("Counting tables");
                var5_6 = null;
                try (Connection conn = new ConnectionUtils(sc).getConnection();){
                    ToTextIndexInfo ttii = ToTextIndexInfo.getInstance();
                    ttii.setLastIndexLoopTime(new Date());
                    ttii.setTextIndexQueue(TextIndexService.getCountFromTextIndex(conn, "totextindex"));
                    ttii.setTextIndexQueue1(TextIndexService.getCountFromTextIndex(conn, "totextindex1"));
                    ttii.setTextIndexQueue2(TextIndexService.getCountFromTextIndex(conn, "totextindex2"));
                    ttii.setActIndexQueue(0L);
                    stat.measure("Index queue size: Creates", ttii.getTextIndexQueue());
                    stat.measure("Index queue size: Updates", ttii.getTextIndexQueue1());
                    stat.measure("Index queue size: Path Updates", ttii.getTextIndexQueue2());
                }
                catch (Throwable ttii) {
                    var5_6 = ttii;
                    throw ttii;
                }
                hasMore = false;
                var5_6 = null;
                try (Transaction trans = new Transaction(TransactionProperties.getBuildIndexTransactionTimeout());
                     IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(statisticHandlerIndex);){
                    Transaction.put("AccessCounterReadDisabled", true);
                    FolderPathUtil.invalidate(sc.getSessionId());
                    AXOCache.invalidate(sc.getSessionId());
                    boolean indexFSOnly = false;
                    if (!indexHandler.isExternalEngine()) {
                        indexFSOnly = lp.getExportIndexFSOnly();
                        GenericMultiQueueHelper mqh = new GenericMultiQueueHelper();
                        List<GenericMultiQueueBean> mqbs = mqh.getQueueEntries(0L, QUEUE_IDENT);
                        boolean wasInFSMode = !mqbs.isEmpty();
                        trace.working("Exporting index for indexing");
                        if (indexFSOnly) {
                            stat.debug("Start index export FS Only (for indexing)");
                            sc.exportFsIndex(null, RoiIndexSyncBean.useSecondIndexForIndexing);
                            stat.debug("End index export FS Only (for indexing)");
                            if (!wasInFSMode) {
                                mqh.createQueueEntry(0L, QUEUE_IDENT);
                            }
                        } else if (wasInFSMode) {
                            for (GenericMultiQueueBean mqb : mqbs) {
                                mqh.deleteQueueEntry(mqb.id, mqb.sortId, mqb.ident);
                            }
                        } else {
                            if (stat.logDebug()) {
                                stat.debug("Start index export (for indexing)");
                            }
                            sc.exportIndex(null, RoiIndexSyncBean.useSecondIndexForIndexing);
                            if (stat.logDebug()) {
                                stat.debug("End index export (for indexing)");
                            }
                        }
                    }
                    trace.working("Performing indexing");
                    hasMore = sc.buildIndex(lp.getMaxDocumentsByTransaction(), null);
                    if (!indexHandler.isExternalEngine()) {
                        trace.working("Importing indexed index");
                        if (!indexFSOnly) {
                            stat.debug("Start index import");
                            sc.importIndex(null, RoiIndexSyncBean.useSecondIndexForIndexing);
                            stat.debug("End index import");
                        }
                        if (RoiIndexSyncBean.indexExported) {
                            TextIndexService.stopSearch(sc);
                        }
                        trace.working("Switching to new index");
                        boolean bl = RoiIndexSyncBean.useSecondIndexForIndexing = !RoiIndexSyncBean.useSecondIndexForIndexing;
                        if (RoiIndexSyncBean.indexExported) {
                            trace.working("Starting search engine");
                            TextIndexService.startSearch();
                            try (IndexHandlerInterface indexHandler1 = IndexHelper.getIndexHandler(statisticHandlerIndex);){
                                indexHandler1.flushPostIndex();
                            }
                        }
                        trace.working("Exporting index");
                        if (indexFSOnly) {
                            stat.debug("Start index export FS only (for searching)");
                            sc.exportFsIndex(null, RoiIndexSyncBean.useSecondIndexForIndexing);
                            stat.debug("End index export FS only (for searching)");
                        } else {
                            stat.debug("Start index export (for searching)");
                            sc.exportIndex(null, RoiIndexSyncBean.useSecondIndexForIndexing);
                            stat.debug("End index export (for searching)");
                        }
                        if (!RoiIndexSyncBean.indexExported) {
                            trace.working("Stopping search engine");
                            TextIndexService.stopSearch(sc);
                        }
                    }
                    trans.commit();
                    if (!indexHandler.isExternalEngine() && !RoiIndexSyncBean.indexExported) {
                        trace.working("Starting search engine");
                        TextIndexService.startSearch();
                        indexHandler.flushPostIndex();
                    }
                }
                catch (Throwable throwable) {
                    var5_6 = throwable;
                    throw throwable;
                }
            } while (hasMore);
            stat.setServiceStatus(Statistic.ServiceStatus.STOPPED);
            stat.clearStickyLogEntry(STICKY_WARNING_NO_INDEXING_PROGRESS);
        }
        catch (Throwable e) {
            stat.error().detail((Object)"An error has occurred in TextIndexService that prevented the index queue from being processed.").exception(e).sticky(STICKY_WARNING_NO_INDEXING_PROGRESS).send("Index queue not progressing");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getCountFromTextIndex(Connection conn, String tableName) {
        try (PreparedStatement ps = conn.prepareStatement("select max(sortid) - min(sortid) + 1 from " + tableName);
             ResultSet rs = ps.executeQuery();){
            if (rs == null) return 0L;
            if (!rs.next()) return 0L;
            long l = rs.getLong(1);
            return l;
        }
        catch (Exception e) {
            stat.warning(e);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void stopSearch(SessionController sc) throws Exception {
        long maxWaitTime = 60000L;
        long waitTime = 100L;
        try {
            maxWaitTime = Long.parseLong(MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/MaxWaitTime", "60000"));
            waitTime = Long.parseLong(MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/WaitTime", "100"));
        }
        catch (Exception e) {
            stat.error(e);
        }
        Object object = RoiIndexSyncBean.syncer;
        synchronized (object) {
            if (RoiIndexSyncBean.getSearchCounter() <= 0) {
                RoiIndexSyncBean.setStopSearch(true);
            }
        }
        while (maxWaitTime > 0L) {
            object = RoiIndexSyncBean.syncer;
            synchronized (object) {
                if (RoiIndexSyncBean.getSearchCounter() <= 0) {
                    sc.closeGlobalIndexSearch();
                    return;
                }
            }
            stat.debug("Index-Commit Wait : " + maxWaitTime + " , waitTime : " + waitTime);
            Thread.sleep(waitTime);
            maxWaitTime -= waitTime;
        }
        sc.closeGlobalIndexSearch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startSearch() {
        Object object = RoiIndexSyncBean.syncer;
        synchronized (object) {
            RoiIndexSyncBean.setStopSearch(false);
        }
    }

    static {
        DocumentServiceStatistic.getInstance();
        stat.setServiceStatus(Statistic.ServiceStatus.NOT_STARTED_YET);
        ServiceUtils.whenAutoUpdateFinished(thread::start);
    }
}

