/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.events;

import agorum.commons.statistic.CoreStatistic;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.events.EventHandler;
import java.util.HashMap;
import java.util.Map;

public class Events {
    private static final String ME = Events.class.getName();
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/roi/control/events/";

    public static void fire(SessionController sc, String event, GlobalObjectClientBean object) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("object", object);
        Events.fire(sc, event, parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fire(SessionController sc, String event, Map<String, Object> parameters) {
        String base;
        if (Transaction.get(ME) != null) {
            return;
        }
        SessionController sca = SessionControllerAdmin.getService(Events.class);
        String[] handlers = MetaDbSuperCache.listSimplePropertyBundles(sca, base = METADB_BASE + event);
        if (handlers == null) {
            return;
        }
        for (String handlerName : handlers) {
            String path = base + "/" + handlerName;
            String clsName = MetaDbSuperCache.getSimplePropertyValue(sca, path + "/Class");
            if (clsName == null) continue;
            try {
                EventHandler handler = (EventHandler)Class.forName(clsName).getDeclaredConstructor(String.class).newInstance(path);
                try (Transaction t = new Transaction();){
                    Transaction.put(ME);
                    handler.handle(sc, event, parameters);
                    t.commit();
                }
                finally {
                    Transaction.remove(ME);
                }
            }
            catch (Exception e) {
                CoreStatistic.getInstance().error((Throwable)e);
            }
        }
    }
}

