/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.test;

import agorum.roi.interfaces.webservices.client.beans.common.BaseRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseResponseBean;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetItemsAttributesRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.ItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLRequestBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLResponseBean;
import agorum.roi.interfaces.webservices.client.beans.system.AbortTransactionRequestBean;
import agorum.roi.interfaces.webservices.client.beans.system.BeginTransactionRequestBean;
import agorum.roi.interfaces.webservices.client.beans.system.EndTransactionRequestBean;
import agorum.roi.interfaces.webservices.client.beans.system.TransactionResponseBean;
import agorum.roi.interfaces.webservices.client.test.TestWebServiceBase;
import agorum.webcomponents.webservices.beans.GenericRequestBean;
import agorum.webcomponents.webservices.common.WebServiceUtils;

public class TestWebServiceTransaction
extends TestWebServiceBase {
    public TestWebServiceTransaction(String[] args) {
        super(args);
    }

    public void runTest() {
        WebServiceUtils wsu = new WebServiceUtils();
        LoginResponseBean loginResponseBean = null;
        try {
            loginResponseBean = this.login();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        String transId = this.beginTransaction(loginResponseBean.getWsSessionId());
        for (int i = 205; i < 206; ++i) {
            this.createTestFolder(loginResponseBean.getWsSessionId(), transId, "/agorum/roi/Files", "MyDummyWithTransaction_" + i);
            System.err.println("  --> " + this.getId(loginResponseBean.getWsSessionId(), transId, "/agorum/roi/Files/MyDummyWithTransaction_" + i));
        }
        this.abortTransaction(loginResponseBean.getWsSessionId(), transId);
        System.err.println("Test has finished");
    }

    private void createTestFolder(String wsSessionId, String transId, String path, String name) {
        ParseXMLRequestBean reqBean = new ParseXMLRequestBean();
        reqBean.setTransactionId(transId);
        String innerXML = "<ObjectList>\n";
        innerXML = innerXML + "<FolderObject>\n";
        innerXML = innerXML + "<Name>" + name + "</Name>\n";
        innerXML = innerXML + "<AddToFolder>" + path + "</AddToFolder>\n";
        innerXML = innerXML + "</FolderObject>\n";
        innerXML = innerXML + "</ObjectList>\n";
        reqBean.setInnerXML(innerXML);
        WebServiceUtils wsu = new WebServiceUtils();
        ParseXMLResponseBean responseBean = (ParseXMLResponseBean)wsu.callWebService(wsSessionId, this.webServiceUrl, (GenericRequestBean)reqBean, "NgFSWebService", "parseXML", ParseXMLResponseBean.class);
        if (responseBean.getErrorKey() != null) {
            System.err.println(responseBean.getErrorKey() + ", " + responseBean.getLogError());
        }
    }

    private String getId(String wsSessionId, String transId, String path) {
        GetItemsAttributesRequestBean reqBean = new GetItemsAttributesRequestBean();
        reqBean.setTransactionId(transId);
        reqBean.setRequestAttributes(new String[]{"ID"});
        ObjectLookupBean olb = new ObjectLookupBean();
        olb.setFullPath(path);
        reqBean.setObjects(new ObjectLookupBean[]{olb});
        WebServiceUtils wsu = new WebServiceUtils();
        ItemsResponseBean responseBean = (ItemsResponseBean)wsu.callWebService(wsSessionId, this.webServiceUrl, (GenericRequestBean)reqBean, "NgFSWebService", "getItemsAttributes", ItemsResponseBean.class);
        if (responseBean.getErrorKey() != null) {
            System.err.println(responseBean.getErrorKey() + ", " + responseBean.getLogError());
            return null;
        }
        return responseBean.getItems()[0].getAttributes()[0];
    }

    private String beginTransaction(String wsSessionId) {
        BeginTransactionRequestBean reqBean = new BeginTransactionRequestBean();
        reqBean.setTransactionTimeout(10000L);
        Class[] classes = new Class[]{BeginTransactionRequestBean.class, TransactionResponseBean.class, BaseRequestBean.class, BaseResponseBean.class};
        WebServiceUtils wsu = new WebServiceUtils();
        TransactionResponseBean responseBean = (TransactionResponseBean)wsu.callWebService(wsSessionId, this.webServiceUrl, (GenericRequestBean)reqBean, "NgFSWebService", "beginTransaction", classes);
        if (responseBean.getErrorKey() != null) {
            System.err.println(responseBean.getErrorKey() + ", " + responseBean.getLogError());
            return null;
        }
        return responseBean.getTransactionId();
    }

    private void abortTransaction(String wsSessionId, String transId) {
        AbortTransactionRequestBean reqBean = new AbortTransactionRequestBean();
        reqBean.setTransactionId(transId);
        Class[] classes = new Class[]{AbortTransactionRequestBean.class, TransactionResponseBean.class, BaseRequestBean.class, BaseResponseBean.class};
        WebServiceUtils wsu = new WebServiceUtils();
        TransactionResponseBean responseBean = (TransactionResponseBean)wsu.callWebService(wsSessionId, this.webServiceUrl, (GenericRequestBean)reqBean, "NgFSWebService", "abortTransaction", classes);
        if (responseBean.getErrorKey() != null) {
            System.err.println(responseBean.getErrorKey() + ", " + responseBean.getLogError());
        }
    }

    private void endTransaction(String wsSessionId, String transId) {
        EndTransactionRequestBean reqBean = new EndTransactionRequestBean();
        reqBean.setTransactionId(transId);
        Class[] classes = new Class[]{EndTransactionRequestBean.class, TransactionResponseBean.class, BaseRequestBean.class, BaseResponseBean.class};
        WebServiceUtils wsu = new WebServiceUtils();
        TransactionResponseBean responseBean = (TransactionResponseBean)wsu.callWebService(wsSessionId, this.webServiceUrl, (GenericRequestBean)reqBean, "NgFSWebService", "endTransaction", classes);
        if (responseBean.getErrorKey() != null) {
            System.err.println(responseBean.getErrorKey() + ", " + responseBean.getLogError());
        }
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: TestWebServiceTransaction <UserName> <PassWord> <WebServiceUrl>");
        } else {
            TestWebServiceTransaction test = new TestWebServiceTransaction(args);
            test.runTest();
        }
    }
}

