/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.client.utils.test;

import agorum.commons.string.StringUtils;
import agorum.roi.interfaces.webservices.client.beans.administration.AccessControlEntryBean;
import agorum.roi.interfaces.webservices.client.beans.administration.AdministrationResponseBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAclEntriesResponseBean;
import agorum.roi.interfaces.webservices.client.beans.common.ItemBean;
import agorum.roi.interfaces.webservices.client.beans.common.ObjectLookupBean;
import agorum.roi.interfaces.webservices.client.beans.filing.FilingResponseBean;
import agorum.roi.interfaces.webservices.client.beans.items.ItemsResponseBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginResponseBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLResponseBean;
import agorum.roi.interfaces.webservices.client.beans.search.SearchResponseBean;
import agorum.roi.interfaces.webservices.client.beans.system.TransactionResponseBean;
import agorum.roi.interfaces.webservices.client.utils.administration.WsAddEntriesToAcl;
import agorum.roi.interfaces.webservices.client.utils.administration.WsAddMembersToGroup;
import agorum.roi.interfaces.webservices.client.utils.administration.WsAddToGroup;
import agorum.roi.interfaces.webservices.client.utils.administration.WsCreateACL;
import agorum.roi.interfaces.webservices.client.utils.administration.WsCreateGroup;
import agorum.roi.interfaces.webservices.client.utils.administration.WsCreateNewUser;
import agorum.roi.interfaces.webservices.client.utils.administration.WsDeleteUser;
import agorum.roi.interfaces.webservices.client.utils.administration.WsGetAclEntries;
import agorum.roi.interfaces.webservices.client.utils.administration.WsGetGroupMembers;
import agorum.roi.interfaces.webservices.client.utils.administration.WsModifyUser;
import agorum.roi.interfaces.webservices.client.utils.administration.WsRemoveFromGroup;
import agorum.roi.interfaces.webservices.client.utils.administration.WsRemoveMembersFromAcl;
import agorum.roi.interfaces.webservices.client.utils.administration.WsRemoveMembersFromGroup;
import agorum.roi.interfaces.webservices.client.utils.common.WsProperties;
import agorum.roi.interfaces.webservices.client.utils.filing.WsAddItemToFolder;
import agorum.roi.interfaces.webservices.client.utils.filing.WsCopyObject;
import agorum.roi.interfaces.webservices.client.utils.filing.WsCreateFolder;
import agorum.roi.interfaces.webservices.client.utils.filing.WsCreateObject;
import agorum.roi.interfaces.webservices.client.utils.filing.WsDeleteObject;
import agorum.roi.interfaces.webservices.client.utils.filing.WsDownloadFile;
import agorum.roi.interfaces.webservices.client.utils.filing.WsGetClassNameFromId;
import agorum.roi.interfaces.webservices.client.utils.filing.WsGetIdFromFullPath;
import agorum.roi.interfaces.webservices.client.utils.filing.WsIsLocked;
import agorum.roi.interfaces.webservices.client.utils.filing.WsMoveObject;
import agorum.roi.interfaces.webservices.client.utils.filing.WsRemoveItemFromFolder;
import agorum.roi.interfaces.webservices.client.utils.filing.WsUpdateObject;
import agorum.roi.interfaces.webservices.client.utils.filing.WsUploadFile;
import agorum.roi.interfaces.webservices.client.utils.items.WsGetItemsFromFolder;
import agorum.roi.interfaces.webservices.client.utils.items.WsGetItemsFromRelation;
import agorum.roi.interfaces.webservices.client.utils.login.WsLogout;
import agorum.roi.interfaces.webservices.client.utils.search.WsSearch;
import agorum.roi.interfaces.webservices.client.utils.system.WsAbortTransaction;
import agorum.roi.interfaces.webservices.client.utils.system.WsBeginTransaction;
import agorum.roi.interfaces.webservices.client.utils.system.WsEndTransaction;
import agorum.roi.interfaces.webservices.client.utils.test.TestBaseClass;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.StringTokenizer;

public class TestAllWsUtils
extends TestBaseClass {
    private String TESTUSERNAME = "ws.hugo.dies.ist.ein.testuser";
    private String TESTFOLDERNAME = "WS-TestUser.dies ist ein test";
    private String TESTFOLDERDATEIEN = "WS-TestFolder.dies ist ein test";
    private String GROUP_1_TESTNAME = "GROUP_WS-Test_ALL_USER.dies.ist.ein.test";
    private String GROUP_2_TESTNAME = "GROUP_WS-Test_USER.dies.ist.ein.test";
    private String GROUP_3_TESTNAME = "GROUP_WS-Test_USER_XX.dies.ist.ein.test";
    private String ACL_1_TESTNAME = "ACL_WS-Test_ALL_USER_READ.dies.ist.ein.test";

    public TestAllWsUtils(String[] args) {
        this.setUserName(args[0]);
        this.setPassWord(args[1]);
        WsProperties prop = new WsProperties();
        this.setUrl(prop.getWebServiceUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void runTest(LoginResponseBean loginResponseBean) throws Exception {
        block47: {
            WsAbortTransaction wsAbortTransaction;
            StringUtils su = new StringUtils();
            String transactionId = null;
            try {
                ParseXMLResponseBean parseXMLResponseBeanL;
                ObjectLookupBean deleteObjectL;
                WsDeleteObject wsdoL;
                WsBeginTransaction wsBeginTransaction = new WsBeginTransaction(loginResponseBean, this.getUrl());
                wsBeginTransaction.setTransactionTimeout(30);
                TransactionResponseBean beginResponse = wsBeginTransaction.doWs();
                this.checkResponseError(beginResponse);
                transactionId = beginResponse.getTransactionId();
                WsGetIdFromFullPath wsgidffpL = new WsGetIdFromFullPath(loginResponseBean, this.getUrl(), transactionId);
                wsgidffpL.setFullpath("/agorum/roi/Files/" + this.TESTFOLDERDATEIEN);
                Long myIdL = wsgidffpL.doWs();
                if (wsgidffpL.getItemsResponseBean().getErrorKey() == null || !wsgidffpL.getItemsResponseBean().getErrorKey().equals("OBJECT_NOT_FOUND")) {
                    this.checkResponseError(wsgidffpL.getItemsResponseBean());
                    if (myIdL != null) {
                        WsDeleteObject wsdoL2 = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                        ObjectLookupBean deleteObjectL2 = new ObjectLookupBean();
                        deleteObjectL2.setObjectId(myIdL);
                        deleteObjectL2.setClassName("FolderObject");
                        wsdoL2.setDeleteObject(deleteObjectL2);
                        wsdoL2.setDeleteIfExists(true);
                        wsdoL2.setDeleteAllReferences(true);
                        ParseXMLResponseBean parseXMLResponseBeanL2 = wsdoL2.doWs();
                        this.checkResponseError(parseXMLResponseBeanL2);
                        System.err.println("delete Folder LogError : " + parseXMLResponseBeanL2.getLogError() + "\nErrorKey : " + parseXMLResponseBeanL2.getErrorKey());
                    }
                }
                WsGetIdFromFullPath wsgidffpL1 = new WsGetIdFromFullPath(loginResponseBean, this.getUrl(), transactionId);
                wsgidffpL1.setFullpath("/agorum/roi/Administration/User/" + this.TESTFOLDERNAME);
                Long myIdL1 = wsgidffpL1.doWs();
                if (wsgidffpL1.getItemsResponseBean().getErrorKey() == null || !wsgidffpL1.getItemsResponseBean().getErrorKey().equals("OBJECT_NOT_FOUND")) {
                    this.checkResponseError(wsgidffpL1.getItemsResponseBean());
                    if (myIdL1 != null) {
                        WsGetItemsFromFolder wsgiff = new WsGetItemsFromFolder(loginResponseBean, this.getUrl(), transactionId);
                        ObjectLookupBean fL = new ObjectLookupBean();
                        fL.setObjectId(myIdL1);
                        wsgiff.setFolder(fL);
                        wsgiff.setSortAttribute("ID");
                        wsgiff.setSortClassName("DirectoryUserObject");
                        wsgiff.setSortOrder("ascending");
                        wsgiff.setAttributeNames(new String[]{"ID"});
                        ItemsResponseBean itemsResponseBean = wsgiff.doWs();
                        this.checkResponseError(itemsResponseBean);
                        ItemBean[] items = itemsResponseBean.getItems();
                        if (items != null) {
                            int len = items.length;
                            for (int i = 0; i < len; ++i) {
                                Long userId = new Long(su.strReplace(items[i].getAttributes()[0], "\"", ""));
                                WsDeleteUser wsduL = new WsDeleteUser(loginResponseBean, this.getUrl(), transactionId);
                                wsduL.setUser(this.TESTUSERNAME);
                                wsduL.setOwningUser("roi");
                                wsduL.setDeleteHomeFolder(true);
                                AdministrationResponseBean administrationResponseBeanL = wsduL.doWs();
                                this.checkResponseError(administrationResponseBeanL);
                                System.err.println("L\u00f6schen Error : " + administrationResponseBeanL.getLogError());
                            }
                        }
                        wsdoL = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                        deleteObjectL = new ObjectLookupBean();
                        deleteObjectL.setObjectId(myIdL1);
                        deleteObjectL.setClassName("FolderObject");
                        wsdoL.setDeleteObject(deleteObjectL);
                        wsdoL.setDeleteIfExists(true);
                        wsdoL.setDeleteAllReferences(true);
                        parseXMLResponseBeanL = wsdoL.doWs();
                        this.checkResponseError(parseXMLResponseBeanL);
                        System.err.println("delete Folder LogError : " + parseXMLResponseBeanL.getLogError() + "\nErrorKey : " + parseXMLResponseBeanL.getErrorKey());
                    }
                }
                WsGetIdFromFullPath wsgidffpL2 = new WsGetIdFromFullPath(loginResponseBean, this.getUrl(), transactionId);
                wsgidffpL2.setFullpath("/agorum/roi/Administration/Group/" + this.TESTFOLDERNAME);
                Long myIdL2 = wsgidffpL2.doWs();
                if (wsgidffpL2.getItemsResponseBean().getErrorKey() == null || !wsgidffpL2.getItemsResponseBean().getErrorKey().equals("OBJECT_NOT_FOUND")) {
                    this.checkResponseError(wsgidffpL2.getItemsResponseBean());
                    if (myIdL2 != null) {
                        WsDeleteObject wsdoL3 = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                        ObjectLookupBean deleteObjectL3 = new ObjectLookupBean();
                        deleteObjectL3.setObjectId(myIdL2);
                        deleteObjectL3.setClassName("FolderObject");
                        wsdoL3.setDeleteObject(deleteObjectL3);
                        wsdoL3.setDeleteIfExists(true);
                        wsdoL3.setDeleteAllReferences(true);
                        ParseXMLResponseBean parseXMLResponseBeanL3 = wsdoL3.doWs();
                        this.checkResponseError(parseXMLResponseBeanL3);
                        System.err.println("delete Folder LogError : " + parseXMLResponseBeanL3.getLogError() + "\nErrorKey : " + parseXMLResponseBeanL3.getErrorKey());
                    }
                }
                WsGetIdFromFullPath wsgidffpL3 = new WsGetIdFromFullPath(loginResponseBean, this.getUrl(), transactionId);
                wsgidffpL3.setFullpath("/agorum/roi/Administration/Role/" + this.TESTFOLDERNAME);
                Long myIdL3 = wsgidffpL3.doWs();
                if (wsgidffpL3.getItemsResponseBean().getErrorKey() == null || !wsgidffpL3.getItemsResponseBean().getErrorKey().equals("OBJECT_NOT_FOUND")) {
                    this.checkResponseError(wsgidffpL3.getItemsResponseBean());
                    if (myIdL3 != null) {
                        wsdoL = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                        deleteObjectL = new ObjectLookupBean();
                        deleteObjectL.setObjectId(myIdL3);
                        deleteObjectL.setClassName("FolderObject");
                        wsdoL.setDeleteObject(deleteObjectL);
                        wsdoL.setDeleteIfExists(true);
                        wsdoL.setDeleteAllReferences(true);
                        parseXMLResponseBeanL = wsdoL.doWs();
                        this.checkResponseError(parseXMLResponseBeanL);
                        System.err.println("delete Folder LogError : " + parseXMLResponseBeanL.getLogError() + "\nErrorKey : " + parseXMLResponseBeanL.getErrorKey());
                    }
                }
                WsCreateFolder wscf = new WsCreateFolder(loginResponseBean, this.getUrl(), transactionId);
                wscf.setName(this.TESTFOLDERNAME);
                wscf.setDescription("Test");
                ObjectLookupBean destinationFolder = new ObjectLookupBean();
                destinationFolder.setFullPath("/agorum/roi/Administration/User");
                wscf.setDestinationFolder(destinationFolder);
                ParseXMLResponseBean parseXMLResponseBean = wscf.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] folderUserId = parseXMLResponseBean.getReturnValues();
                Long fuId = null;
                if (folderUserId != null) {
                    fuId = new Long(su.strReplace(folderUserId[0], "\"", ""));
                }
                System.err.println("Folder has been created with Id :" + fuId);
                wscf = new WsCreateFolder(loginResponseBean, this.getUrl(), transactionId);
                wscf.setName(this.TESTFOLDERNAME);
                wscf.setDescription("Test");
                destinationFolder = new ObjectLookupBean();
                destinationFolder.setFullPath("/agorum/roi/Administration/Role");
                wscf.setDestinationFolder(destinationFolder);
                parseXMLResponseBean = wscf.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] folderRoleId = parseXMLResponseBean.getReturnValues();
                Long frId = null;
                if (folderRoleId != null) {
                    frId = new Long(su.strReplace(folderRoleId[0], "\"", ""));
                }
                System.err.println("Folder for ACL has been created with Id :" + frId);
                wscf = new WsCreateFolder(loginResponseBean, this.getUrl(), transactionId);
                wscf.setName(this.TESTFOLDERNAME);
                wscf.setDescription("Test");
                destinationFolder = new ObjectLookupBean();
                destinationFolder.setFullPath("/agorum/roi/Administration/Group");
                wscf.setDestinationFolder(destinationFolder);
                parseXMLResponseBean = wscf.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] folderGroupId = parseXMLResponseBean.getReturnValues();
                Long fgId = null;
                if (folderGroupId != null) {
                    fgId = new Long(su.strReplace(folderGroupId[0], "\"", ""));
                }
                System.err.println("Folder created with Id :" + fgId);
                WsCreateNewUser wscnu = new WsCreateNewUser(loginResponseBean, this.getUrl(), transactionId);
                wscnu.setUserName(this.TESTUSERNAME);
                wscnu.setPassWord(this.TESTUSERNAME);
                wscnu.setAdminEnabled(false);
                destinationFolder = new ObjectLookupBean();
                destinationFolder.setFullPath("/agorum/roi/Administration/User/" + this.TESTFOLDERNAME);
                wscnu.setDestinationFolder(destinationFolder);
                wscnu.setDirectoryUserDescription("Beschreibung");
                wscnu.setEmailAddresses(this.TESTUSERNAME);
                wscnu.setEventAssistancePaths(new String[]{"/agorum/roi/files"});
                wscnu.setFamilyName("hugo");
                wscnu.setGivenName("ws");
                wscnu.setLanguage("de");
                parseXMLResponseBean = wscnu.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] userId = parseXMLResponseBean.getReturnValues();
                Long uId = null;
                if (userId != null) {
                    uId = new Long(su.strReplace(userId[0], "\"", ""));
                }
                System.err.println("User created with Id :" + uId);
                WsModifyUser wsmu = new WsModifyUser(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean myUser = new ObjectLookupBean();
                myUser.setName(this.TESTUSERNAME);
                myUser.setClassName("DirectoryUserObject");
                wsmu.setUser(myUser);
                wsmu.setPassWord("newPassword");
                AdministrationResponseBean modifyUserResponse = wsmu.doWs();
                if (modifyUserResponse.getErrorKey() != null && modifyUserResponse.getErrorKey().equals("ADMINISTRATION_USER_NOT_FOUND")) {
                    throw new Exception(modifyUserResponse.getErrorKey());
                }
                this.checkResponseError(modifyUserResponse);
                System.err.println("Password of Users changed. LogError : " + modifyUserResponse.getLogError() + "\nErrorKey : " + modifyUserResponse.getErrorKey());
                WsCreateGroup wscg = new WsCreateGroup(loginResponseBean, this.getUrl(), transactionId);
                wscg.setName(this.GROUP_1_TESTNAME);
                wscg.setDescription("Test Group for WebServices");
                destinationFolder = new ObjectLookupBean();
                destinationFolder.setClassName("FolderObject");
                destinationFolder.setObjectId(fgId);
                wscg.setDestinationFolder(destinationFolder);
                parseXMLResponseBean = wscg.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] groupGIdArr = parseXMLResponseBean.getReturnValues();
                Long groupGId = null;
                if (groupGIdArr != null) {
                    groupGId = new Long(su.strReplace(groupGIdArr[0], "\"", ""));
                }
                System.err.println(this.GROUP_1_TESTNAME + " created with Id :" + groupGId);
                wscg = new WsCreateGroup(loginResponseBean, this.getUrl(), transactionId);
                wscg.setName(this.GROUP_2_TESTNAME);
                wscg.setDescription("Test Group for WebServices");
                destinationFolder = new ObjectLookupBean();
                destinationFolder.setClassName("FolderObject");
                destinationFolder.setObjectId(fgId);
                wscg.setDestinationFolder(destinationFolder);
                parseXMLResponseBean = wscg.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] groupGIdArr2 = parseXMLResponseBean.getReturnValues();
                Long groupGId2 = null;
                if (groupGIdArr2 != null) {
                    groupGId2 = new Long(su.strReplace(groupGIdArr2[0], "\"", ""));
                }
                System.err.println(this.GROUP_2_TESTNAME + " created with Id :" + groupGId2);
                wscg = new WsCreateGroup(loginResponseBean, this.getUrl(), transactionId);
                wscg.setName(this.GROUP_3_TESTNAME);
                wscg.setDescription("Test Group for WebServices");
                destinationFolder = new ObjectLookupBean();
                destinationFolder.setClassName("FolderObject");
                destinationFolder.setObjectId(fgId);
                wscg.setDestinationFolder(destinationFolder);
                parseXMLResponseBean = wscg.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] groupGIdArr3 = parseXMLResponseBean.getReturnValues();
                Long groupGId3 = null;
                if (groupGIdArr3 != null) {
                    groupGId3 = new Long(su.strReplace(groupGIdArr3[0], "\"", ""));
                }
                System.err.println(this.GROUP_3_TESTNAME + " created with Id :" + groupGId3);
                WsAddMembersToGroup wsamtg = new WsAddMembersToGroup(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId2);
                wsamtg.setGroup(groupObject);
                ObjectLookupBean[] members = new ObjectLookupBean[]{new ObjectLookupBean()};
                members[0].setName(this.TESTUSERNAME);
                members[0].setClassName("DirectoryUserObject");
                wsamtg.setMembers(members);
                parseXMLResponseBean = wsamtg.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println("Members added to group 2. LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                wsamtg = new WsAddMembersToGroup(loginResponseBean, this.getUrl(), transactionId);
                groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId);
                wsamtg.setGroup(groupObject);
                members = new ObjectLookupBean[2];
                members[0] = new ObjectLookupBean();
                members[0].setName(this.GROUP_2_TESTNAME);
                members[0].setClassName("DirectoryGroupObject");
                members[1] = new ObjectLookupBean();
                members[1].setName(this.TESTUSERNAME);
                members[1].setClassName("DirectoryUserObject");
                wsamtg.setMembers(members);
                parseXMLResponseBean = wsamtg.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println("Members added to group1. LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                WsGetGroupMembers wsggm = new WsGetGroupMembers(loginResponseBean, this.getUrl(), transactionId);
                groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId);
                wsggm.setGroup(groupObject);
                ItemsResponseBean allMembers = wsggm.doWs();
                this.checkResponseError(allMembers);
                System.err.println("GetGroupMembers LogError : " + allMembers.getLogError() + "\nErrorKey : " + allMembers.getErrorKey());
                ItemBean[] itemsMembers = allMembers.getItems();
                if (itemsMembers != null) {
                    int len = itemsMembers.length;
                    for (int i = 0; i < len; ++i) {
                        System.err.println("------- Member " + i + " ----------------");
                        System.err.println("ID        : " + itemsMembers[i].getAttributes()[0]);
                        System.err.println("CLASSNAME : " + itemsMembers[i].getAttributes()[1]);
                        System.err.println("NAME      : " + itemsMembers[i].getAttributes()[2]);
                    }
                }
                WsAddToGroup wsatg = new WsAddToGroup(loginResponseBean, this.getUrl(), transactionId);
                groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId3);
                wsatg.setGroup(groupObject);
                members = new ObjectLookupBean[2];
                members[0] = new ObjectLookupBean();
                members[0].setName(this.GROUP_2_TESTNAME);
                members[0].setClassName("DirectoryGroupObject");
                members[1] = new ObjectLookupBean();
                members[1].setName(this.TESTUSERNAME);
                members[1].setClassName("DirectoryUserObject");
                wsatg.setMembers(members);
                AdministrationResponseBean administrationResponseBean3 = wsatg.doWs();
                this.checkResponseError(administrationResponseBean3);
                System.err.println("Members added to group3. LogError : " + administrationResponseBean3.getLogError() + "\nErrorKey : " + administrationResponseBean3.getErrorKey());
                WsGetGroupMembers wsggm3 = new WsGetGroupMembers(loginResponseBean, this.getUrl(), transactionId);
                groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId3);
                wsggm3.setGroup(groupObject);
                ItemsResponseBean allMembers3 = wsggm3.doWs();
                this.checkResponseError(allMembers3);
                System.err.println("GetGroupMembers LogError : " + allMembers3.getLogError() + "\nErrorKey : " + allMembers3.getErrorKey());
                ItemBean[] itemsMembers3 = allMembers3.getItems();
                if (itemsMembers3 != null) {
                    int len = itemsMembers3.length;
                    for (int i = 0; i < len; ++i) {
                        System.err.println("------- Member " + i + " ----------------");
                        System.err.println("ID        : " + itemsMembers3[i].getAttributes()[0]);
                        System.err.println("CLASSNAME : " + itemsMembers3[i].getAttributes()[1]);
                        System.err.println("NAME      : " + itemsMembers3[i].getAttributes()[2]);
                    }
                }
                WsRemoveFromGroup wsrfg = new WsRemoveFromGroup(loginResponseBean, this.getUrl(), transactionId);
                groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId3);
                wsrfg.setGroup(groupObject);
                members = new ObjectLookupBean[]{new ObjectLookupBean()};
                members[0].setName(this.TESTUSERNAME);
                members[0].setClassName("DirectoryUserObject");
                wsrfg.setMembers(members);
                administrationResponseBean3 = wsrfg.doWs();
                this.checkResponseError(administrationResponseBean3);
                System.err.println("Members of group3 removed. LogError : " + administrationResponseBean3.getLogError() + "\nErrorKey : " + administrationResponseBean3.getErrorKey());
                wsggm3 = new WsGetGroupMembers(loginResponseBean, this.getUrl(), transactionId);
                groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId3);
                wsggm3.setGroup(groupObject);
                allMembers3 = wsggm3.doWs();
                this.checkResponseError(allMembers3);
                System.err.println("GetGroupMembers LogError : " + allMembers3.getLogError() + "\nErrorKey : " + allMembers3.getErrorKey());
                itemsMembers3 = allMembers3.getItems();
                if (itemsMembers3 != null) {
                    int len = itemsMembers3.length;
                    for (int i = 0; i < len; ++i) {
                        System.err.println("------- Members after RemoveFromGroup " + i + " ----------------");
                        System.err.println("ID        : " + itemsMembers3[i].getAttributes()[0]);
                        System.err.println("CLASSNAME : " + itemsMembers3[i].getAttributes()[1]);
                        System.err.println("NAME      : " + itemsMembers3[i].getAttributes()[2]);
                    }
                }
                WsRemoveMembersFromGroup wsrmfg = new WsRemoveMembersFromGroup(loginResponseBean, this.getUrl(), transactionId);
                groupObject = new ObjectLookupBean();
                groupObject.setObjectId(groupGId);
                wsrmfg.setGroup(groupObject);
                members = new ObjectLookupBean[]{new ObjectLookupBean()};
                members[0].setName(this.TESTUSERNAME);
                members[0].setClassName("DirectoryUserObject");
                wsrmfg.setMembers(members);
                parseXMLResponseBean = wsrmfg.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println("Members of group1 removed. LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                WsCreateACL wsca = new WsCreateACL(loginResponseBean, this.getUrl(), transactionId);
                wsca.addAttribute("Name", this.ACL_1_TESTNAME);
                wsca.addAttribute("Description", "Test ACL for WebServices");
                destinationFolder = new ObjectLookupBean();
                destinationFolder.setClassName("FolderObject");
                destinationFolder.setObjectId(frId);
                wsca.setDestinationFolder(destinationFolder);
                parseXMLResponseBean = wsca.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] aclRIdArr = parseXMLResponseBean.getReturnValues();
                Long aclRId = null;
                if (aclRIdArr != null) {
                    aclRId = new Long(su.strReplace(aclRIdArr[0], "\"", ""));
                }
                System.err.println(this.ACL_1_TESTNAME + " created with Id :" + aclRId);
                WsAddEntriesToAcl wsaeta = new WsAddEntriesToAcl(loginResponseBean, this.getUrl(), transactionId);
                AccessControlEntryBean[] accessControlEntryBean = new AccessControlEntryBean[2];
                accessControlEntryBean[0] = new AccessControlEntryBean();
                ObjectLookupBean g2 = new ObjectLookupBean();
                g2.setObjectId(groupGId2);
                accessControlEntryBean[0].setMember(g2);
                accessControlEntryBean[0].setPermissionBundle("AG_PB_ALL");
                accessControlEntryBean[0].setMode("grant");
                accessControlEntryBean[1] = new AccessControlEntryBean();
                ObjectLookupBean g1 = new ObjectLookupBean();
                g1.setObjectId(groupGId);
                accessControlEntryBean[1].setMember(g1);
                accessControlEntryBean[1].setPermissionBundle("AG_PB_READ");
                accessControlEntryBean[1].setMode("grant");
                ObjectLookupBean acl1 = new ObjectLookupBean();
                acl1.setObjectId(aclRId);
                wsaeta.setAccessControlEntryBeans(accessControlEntryBean);
                wsaeta.setAcl(acl1);
                AdministrationResponseBean administrationResponseBeanAcl = wsaeta.doWs();
                this.checkResponseError(administrationResponseBeanAcl);
                System.err.println("AddEntrysToAcl Error : " + administrationResponseBeanAcl.getLogError());
                wsaeta = new WsAddEntriesToAcl(loginResponseBean, this.getUrl(), transactionId);
                accessControlEntryBean = new AccessControlEntryBean[2];
                accessControlEntryBean[0] = new AccessControlEntryBean();
                g2 = new ObjectLookupBean();
                g2.setObjectId(groupGId2);
                accessControlEntryBean[0].setMember(g2);
                accessControlEntryBean[0].setPermissionBundle("AG_PB_PROTECTED");
                accessControlEntryBean[0].setMode("grant");
                accessControlEntryBean[1] = new AccessControlEntryBean();
                g1 = new ObjectLookupBean();
                g1.setObjectId(groupGId);
                accessControlEntryBean[1].setMember(g1);
                accessControlEntryBean[1].setPermissionBundle("AG_PB_WRITE");
                accessControlEntryBean[1].setMode("grant");
                acl1 = new ObjectLookupBean();
                acl1.setObjectId(aclRId);
                wsaeta.setAccessControlEntryBeans(accessControlEntryBean);
                wsaeta.setAcl(acl1);
                administrationResponseBeanAcl = wsaeta.doWs();
                this.checkResponseError(administrationResponseBeanAcl);
                System.err.println("AddEntrysToAcl Error : " + administrationResponseBeanAcl.getLogError());
                WsGetAclEntries wsGetAclEntries = new WsGetAclEntries(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean myAcl = new ObjectLookupBean();
                myAcl.setObjectId(aclRId);
                wsGetAclEntries.setAcl(myAcl);
                GetAclEntriesResponseBean aclEntriesResp = wsGetAclEntries.doWs();
                this.checkResponseError(aclEntriesResp);
                AccessControlEntryBean[] allEntries = aclEntriesResp.getAccessControlEntries();
                if (allEntries != null) {
                    int len = allEntries.length;
                    for (int i = 0; i < len; ++i) {
                        System.err.println("------- ACL Entry " + i + " ----------------");
                        System.err.println("GRANTEE     : " + allEntries[i].getMember().getName());
                        System.err.println("OBJECTTYPE  : " + allEntries[i].getMember().getClassName());
                        System.err.println("GRANTED     : " + allEntries[i].getMode());
                        System.err.println("PERM_BUNDLE : " + allEntries[i].getPermissionBundle());
                    }
                }
                WsRemoveMembersFromAcl wsrmfa = new WsRemoveMembersFromAcl(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean[] membersRemove = new ObjectLookupBean[1];
                g2 = new ObjectLookupBean();
                g2.setObjectId(groupGId2);
                membersRemove[0] = g2;
                acl1 = new ObjectLookupBean();
                acl1.setObjectId(aclRId);
                wsrmfa.setMembers(membersRemove);
                wsrmfa.setAcl(acl1);
                administrationResponseBeanAcl = wsrmfa.doWs();
                this.checkResponseError(administrationResponseBeanAcl);
                System.err.println("RemoveMembersFromAcl Error : " + administrationResponseBeanAcl.getLogError());
                Long startTestFolder = this.createTestFolders(loginResponseBean, this.getUrl(), this.TESTFOLDERDATEIEN + "/test/lib/classes", "/agorum/roi/Files", aclRId, transactionId);
                this.createTestFolders(loginResponseBean, this.getUrl(), "hugo/lib/classes", "/agorum/roi/Files/" + this.TESTFOLDERDATEIEN, aclRId, transactionId);
                this.createTestFolders(loginResponseBean, this.getUrl(), "boss/lib/classes/client/beans", "/agorum/roi/Files/" + this.TESTFOLDERDATEIEN, aclRId, transactionId);
                this.createTestFolders(loginResponseBean, this.getUrl(), "BigFolder/lib/classes/client/beans/lib/classes/client/beans/lib/classes/client/beans/lib/classes/client/beans/lib/classes/client/beans", "/agorum/roi/Files/" + this.TESTFOLDERDATEIEN, aclRId, transactionId);
                WsGetIdFromFullPath wsgidffp = new WsGetIdFromFullPath(loginResponseBean, this.getUrl(), transactionId);
                wsgidffp.setFullpath("/agorum/roi/Files/" + this.TESTFOLDERDATEIEN + "/BigFolder/lib/classes/client");
                Long myId = wsgidffp.doWs();
                this.checkResponseError(wsgidffp.getItemsResponseBean());
                System.err.println("ID from Doc-Path : " + myId);
                WsProperties prop = new WsProperties();
                WsUploadFile wsuf = new WsUploadFile(loginResponseBean, prop.getUploadUrl(), transactionId);
                File f = new File("c:\\projekte\\cvs\\agorum\\roi\\roitest\\data\\WsTest.doc");
                FileInputStream fis = new FileInputStream(f);
                wsuf.setFileInputStream(fis);
                wsuf.setFileLength((int)f.length());
                wsuf.setFileName("WsTest.doc");
                wsuf.setFolderId(myId);
                Long fileId = wsuf.doWs();
                fis.close();
                System.err.println("ID from WsTest.doc : " + fileId);
                WsCreateObject wsco = new WsCreateObject(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean folderObject = new ObjectLookupBean();
                folderObject.setObjectId(myId);
                folderObject.setClassName("FolderObject");
                wsco.setDestinationFolder(folderObject);
                ObjectLookupBean aclObject = new ObjectLookupBean();
                aclObject.setObjectId(aclRId);
                aclObject.setClassName("CustomAclObject");
                wsco.addAttribute("Acl", aclObject);
                wsco.addAttribute("Name", "Hugo.doc");
                wsco.setClassName("FileObject");
                parseXMLResponseBean = wsco.doWs();
                this.checkResponseError(parseXMLResponseBean);
                String[] fileArr = parseXMLResponseBean.getReturnValues();
                if (fileArr != null) {
                    fileId = new Long(su.strReplace(fileArr[0], "\"", ""));
                }
                System.err.println("ID from Hugo.doc : " + fileId);
                wsuf = new WsUploadFile(loginResponseBean, prop.getUploadUrl(), transactionId);
                f = new File("c:\\projekte\\cvs\\agorum\\roi\\roitest\\data\\WsTest.doc");
                fis = new FileInputStream(f);
                wsuf.setFileInputStream(fis);
                wsuf.setFileLength((int)f.length());
                wsuf.setFileId(fileId);
                fileId = wsuf.doWs();
                fis.close();
                System.err.println("ID from WsTest.doc : " + fileId);
                WsDownloadFile wsdf = new WsDownloadFile(loginResponseBean, prop.getDownloadUrl(), transactionId);
                wsdf.setFileId(fileId);
                InputStream inStream = wsdf.doWs();
                if (inStream != null) {
                    int read;
                    File testDir = new File("c:\\temp\\webservice_tests");
                    testDir.mkdirs();
                    FileOutputStream fos = new FileOutputStream("c:\\temp\\webservice_tests\\hugo.doc");
                    byte[] buffer = new byte[1024];
                    while ((read = inStream.read(buffer)) >= 0) {
                        fos.write(buffer, 0, read);
                    }
                    fos.close();
                    inStream.close();
                    System.err.println("File has been sucessfully downloaded");
                } else {
                    System.err.println("Error downloading file with id: " + fileId);
                }
                wsdf = new WsDownloadFile(loginResponseBean, prop.getDownloadUrl(), transactionId);
                wsdf.setFileId(fileId);
                wsdf.setTargetFormat("pdf");
                inStream = wsdf.doWs();
                if (inStream != null) {
                    int read;
                    FileOutputStream fos = new FileOutputStream("c:\\temp\\webservice_tests\\hugo.pdf");
                    byte[] buffer = new byte[1024];
                    while ((read = inStream.read(buffer)) >= 0) {
                        fos.write(buffer, 0, read);
                    }
                    fos.close();
                    inStream.close();
                    System.err.println("File has been sucessfully downloaded");
                } else {
                    System.err.println("Error downloading file as pdf with id: " + fileId);
                }
                WsGetClassNameFromId wsgcfi = new WsGetClassNameFromId(loginResponseBean, this.getUrl(), transactionId);
                wsgcfi.setId(fileId);
                String myClassName = wsgcfi.doWs();
                this.checkResponseError(wsgcfi.getItemsResponseBean());
                System.err.println("classname : " + myClassName);
                WsIsLocked wsil = new WsIsLocked(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean fileObject = new ObjectLookupBean();
                fileObject.setObjectId(fileId);
                wsil.setObject(fileObject);
                System.err.println("isLocked : " + wsil.doWs());
                WsUpdateObject wsuo = new WsUpdateObject(loginResponseBean, this.getUrl(), transactionId);
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(fileId);
                fileObject.setClassName("FileObject");
                wsuo.setObject(fileObject);
                wsuo.addAttribute("LOCKSTATE", "1");
                parseXMLResponseBean = wsuo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                wsil = new WsIsLocked(loginResponseBean, this.getUrl(), transactionId);
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(fileId);
                wsil.setObject(fileObject);
                System.err.println("isLocked : " + wsil.doWs());
                WsGetItemsFromRelation wsgifr = new WsGetItemsFromRelation(loginResponseBean, this.getUrl(), transactionId);
                wsgifr.setAttributeNames(new String[]{"ID", "ANYPATH"});
                wsgifr.setItemsPerRequest(100);
                wsgifr.setListDirection("leftWard");
                wsgifr.setRelationClass("FolderPathRelationObject");
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(fileId);
                wsgifr.setObject(fileObject);
                wsgifr.setStartItem(0);
                ItemsResponseBean parents = wsgifr.doWs();
                this.checkResponseError(parents);
                ItemBean[] itemsParents = parents.getItems();
                Long fromFolderID = null;
                if (itemsParents != null) {
                    int len = itemsParents.length;
                    for (int i = 0; i < len; ++i) {
                        System.err.println("------- parent " + i + " ----------------");
                        System.err.println("ID      : " + itemsParents[i].getAttributes()[0]);
                        System.err.println("ANYPATH : " + itemsParents[i].getAttributes()[1]);
                        fromFolderID = new Long(su.strReplace(itemsParents[i].getAttributes()[0], "\"", ""));
                    }
                }
                WsMoveObject wsmo = new WsMoveObject(loginResponseBean, this.getUrl(), transactionId);
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(fileId);
                wsmo.setObject(fileObject);
                ObjectLookupBean fromFolder = new ObjectLookupBean();
                fromFolder.setObjectId(fromFolderID);
                wsmo.setFromFolder(fromFolder);
                WsGetIdFromFullPath wsTo = new WsGetIdFromFullPath(loginResponseBean, this.getUrl(), transactionId);
                wsTo.setFullpath("/agorum/roi/Files/" + this.TESTFOLDERDATEIEN);
                Long toFolderID = wsTo.doWs();
                this.checkResponseError(wsTo.getItemsResponseBean());
                ObjectLookupBean toFolder = new ObjectLookupBean();
                toFolder.setObjectId(toFolderID);
                wsmo.setToFolder(toFolder);
                FilingResponseBean moveResponse = wsmo.doWs();
                this.checkResponseError(moveResponse);
                System.err.println("MoveObject LogError : " + moveResponse.getLogError() + "\nErrorKey : " + moveResponse.getErrorKey());
                WsCopyObject wscopy = new WsCopyObject(loginResponseBean, this.getUrl(), transactionId);
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(fileId);
                wscopy.setObject(fileObject);
                toFolder = new ObjectLookupBean();
                toFolder.setObjectId(fromFolderID);
                wscopy.setToFolder(fromFolder);
                ItemsResponseBean responseCopy = wscopy.doWs();
                this.checkResponseError(responseCopy);
                System.err.println("CopyObject LogError : " + moveResponse.getLogError() + "\nErrorKey : " + moveResponse.getErrorKey());
                Long copyId = new Long(su.strReplace(responseCopy.getItems()[0].getAttributes()[0], "\"", ""));
                WsUpdateObject changeName = new WsUpdateObject(loginResponseBean, this.getUrl(), transactionId);
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(copyId);
                fileObject.setClassName("FileObject");
                changeName.setObject(fileObject);
                changeName.addAttribute("Name", "MeinCopyFile.doc");
                ParseXMLResponseBean changeResponse = changeName.doWs();
                this.checkResponseError(changeResponse);
                System.err.println("ChangeName LogError : " + moveResponse.getLogError() + "\nErrorKey : " + moveResponse.getErrorKey());
                WsAddItemToFolder wsaitf = new WsAddItemToFolder(loginResponseBean, this.getUrl(), transactionId);
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(copyId);
                wsaitf.setObject(fileObject);
                toFolder = new ObjectLookupBean();
                toFolder.setObjectId(toFolderID);
                wsaitf.setToFolder(toFolder);
                FilingResponseBean addItemResponse = wsaitf.doWs();
                this.checkResponseError(addItemResponse);
                System.err.println("AddItemToFolder LogError : " + addItemResponse.getLogError() + "\nErrorKey : " + addItemResponse.getErrorKey());
                WsRemoveItemFromFolder wsremoveItem = new WsRemoveItemFromFolder(loginResponseBean, this.getUrl(), transactionId);
                fileObject = new ObjectLookupBean();
                fileObject.setObjectId(copyId);
                wsremoveItem.setObject(fileObject);
                fromFolder = new ObjectLookupBean();
                fromFolder.setObjectId(fromFolderID);
                wsremoveItem.setFromFolder(fromFolder);
                FilingResponseBean removeItemResponse = wsremoveItem.doWs();
                this.checkResponseError(removeItemResponse);
                System.err.println("RemoveItemFromFolder LogError : " + removeItemResponse.getLogError() + "\nErrorKey : " + removeItemResponse.getErrorKey());
                WsSearch wss = new WsSearch(loginResponseBean, this.getUrl(), transactionId);
                wss.setQuery("d4wdemo* ancestors:directoryuserobject");
                wss.setItemsPerRequest(100);
                wss.setStartItem(0);
                wss.setStartPath("/");
                wss.setAttributes(new String[]{"ID", "NAME", "LASTMODIFYDATE", "ANYPATH"});
                SearchResponseBean searchResponseBean = wss.doWs();
                this.checkResponseError(searchResponseBean);
                System.err.println("Number of Items: " + searchResponseBean.getResultCount());
                ItemBean[] items = searchResponseBean.getItems();
                if (items != null) {
                    int len = items.length;
                    for (int i = 0; i < len; ++i) {
                        String[] attributeValues = items[i].getAttributes();
                        System.err.println("------  item : " + i + " ---------------");
                        System.err.println("ID: " + attributeValues[0]);
                        System.err.println("Name: " + attributeValues[1]);
                        System.err.println("LastModifyDate: " + attributeValues[2]);
                        System.err.println("Path: " + attributeValues[3]);
                    }
                }
                WsDeleteObject wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                ObjectLookupBean deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(startTestFolder);
                deleteObject.setClassName("FolderObject");
                wsdo.setDeleteObject(deleteObject);
                wsdo.setDeleteIfExists(true);
                wsdo.setDeleteAllReferences(true);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println("Group-Admin-Folder delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                WsDeleteUser wsdu = new WsDeleteUser(loginResponseBean, this.getUrl(), transactionId);
                wsdu.setUser(this.TESTUSERNAME);
                wsdu.setOwningUser("roi");
                wsdu.setDeleteHomeFolder(true);
                AdministrationResponseBean administrationResponseBean = wsdu.doWs();
                this.checkResponseError(administrationResponseBean);
                System.err.println("Delete Error : " + administrationResponseBean.getLogError());
                wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(groupGId);
                deleteObject.setClassName("DirectoryGroupObject");
                wsdo.setDeleteObject(deleteObject);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println(this.GROUP_1_TESTNAME + " delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(groupGId2);
                deleteObject.setClassName("DirectoryGroupObject");
                wsdo.setDeleteObject(deleteObject);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println(this.GROUP_2_TESTNAME + " delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(groupGId3);
                deleteObject.setClassName("DirectoryGroupObject");
                wsdo.setDeleteObject(deleteObject);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println(this.GROUP_3_TESTNAME + " delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(aclRId);
                deleteObject.setClassName("CustomAclObject");
                wsdo.setDeleteObject(deleteObject);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println(this.ACL_1_TESTNAME + " delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(fuId);
                deleteObject.setClassName("FolderObject");
                wsdo.setDeleteObject(deleteObject);
                wsdo.setDeleteIfExists(true);
                wsdo.setDeleteAllReferences(true);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println("User-Admin-Folder delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(frId);
                deleteObject.setClassName("FolderObject");
                wsdo.setDeleteObject(deleteObject);
                wsdo.setDeleteIfExists(true);
                wsdo.setDeleteAllReferences(true);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println("Role-Admin-Folder delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                wsdo = new WsDeleteObject(loginResponseBean, this.getUrl(), transactionId);
                deleteObject = new ObjectLookupBean();
                deleteObject.setObjectId(fgId);
                deleteObject.setClassName("FolderObject");
                wsdo.setDeleteObject(deleteObject);
                wsdo.setDeleteIfExists(true);
                wsdo.setDeleteAllReferences(true);
                parseXMLResponseBean = wsdo.doWs();
                this.checkResponseError(parseXMLResponseBean);
                System.err.println("Group-Admin-Folder delete LogError : " + parseXMLResponseBean.getLogError() + "\nErrorKey : " + parseXMLResponseBean.getErrorKey());
                WsLogout wsLogout = new WsLogout(loginResponseBean, this.getUrl());
                wsLogout.doWs();
                if (transactionId != null) {
                    WsEndTransaction wsEndTransaction = new WsEndTransaction(loginResponseBean, this.getUrl(), transactionId);
                    TransactionResponseBean responseEnd = wsEndTransaction.doWs();
                    this.checkResponseError(responseEnd);
                    transactionId = null;
                }
                if (transactionId == null) break block47;
                System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                wsAbortTransaction = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
            }
            catch (Exception e) {
                System.err.println("Aborted: Message : " + e.getMessage());
                if (transactionId == null) break block47;
                System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                WsAbortTransaction wsAbortTransaction2 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                TransactionResponseBean responseEnd = wsAbortTransaction2.doWs();
                transactionId = null;
            }
            catch (Throwable ta) {
                ta.printStackTrace(System.err);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                finally {
                    if (transactionId != null) {
                        System.err.println("\n\n ------- Transaction ABORT ----------\n\n");
                        WsAbortTransaction wsAbortTransaction3 = new WsAbortTransaction(loginResponseBean, this.getUrl(), transactionId);
                        TransactionResponseBean responseEnd = wsAbortTransaction3.doWs();
                        transactionId = null;
                    }
                }
            }
            TransactionResponseBean responseEnd = wsAbortTransaction.doWs();
            transactionId = null;
        }
    }

    private Long createTestFolders(LoginResponseBean loginResponseBean, String url, String path, String basePath, Long aclId, String transactionId) throws Exception {
        Long startFolder = null;
        StringTokenizer st = new StringTokenizer(path, "/");
        int count = 0;
        String name = null;
        while (st.hasMoreTokens()) {
            WsCreateFolder wscf = new WsCreateFolder(loginResponseBean, url, transactionId);
            name = st.nextToken();
            wscf.addAttribute("Name", name);
            wscf.addAttribute("Description", "Testfolder " + name);
            ObjectLookupBean destinationFolder = new ObjectLookupBean();
            destinationFolder.setFullPath(basePath);
            wscf.setDestinationFolder(destinationFolder);
            ParseXMLResponseBean parseXMLResponseBean = wscf.doWs();
            this.checkResponseError(parseXMLResponseBean);
            String[] folderId = parseXMLResponseBean.getReturnValues();
            Long id = null;
            if (folderId != null) {
                StringUtils su = new StringUtils();
                id = new Long(su.strReplace(folderId[0], "\"", ""));
            }
            if (count == 0) {
                startFolder = id;
            }
            ++count;
            basePath = basePath + "/" + name;
        }
        return startFolder;
    }

    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: TestAllWsUtils <UserName> <PassWord> ");
        } else {
            try {
                TestAllWsUtils test = new TestAllWsUtils(args);
                LoginResponseBean loginResponseBean = test.runLogin(test.getUserName(), test.getPassWord(), test.getUrl());
                if (loginResponseBean.getConnected()) {
                    test.runTest(loginResponseBean);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            System.err.println("test finished");
        }
    }
}

