/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server;

import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.exception.RoiException;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLRequestBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLResponseBean;
import agorum.roi.interfaces.webservices.client.common.WebServiceErrorKeys;
import agorum.roi.interfaces.webservices.server.BaseItemService;
import agorum.roi.parser.common.CreateRoiObjectsFromParseObject;
import agorum.roi.parser.common.ParserObject;
import agorum.roi.parser.common.RoiXMLParser;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;
import java.util.Vector;

public class ParseXMLService
extends BaseItemService {
    public ParseXMLService(WebServiceSessionBean wsSessionBean) {
        super(wsSessionBean);
    }

    public ParseXMLResponseBean parse(ParseXMLRequestBean requestBean) {
        ParseXMLResponseBean responseBean = new ParseXMLResponseBean();
        try {
            SessionController sessionController = (SessionController)this.wsSessionBean.getAttribute("SessionController");
            RoiTransactionHandler rth = new RoiTransactionHandler();
            try {
                ParserObject po = null;
                RoiXMLParser roiXMLParser = null;
                rth.begin();
                roiXMLParser = new RoiXMLParser(sessionController);
                String xml = requestBean.getInnerXML();
                xml = "<?xml version = \"1.0\" encoding=\"ISO-8859-15\"?>\n" + xml;
                roiXMLParser.setXmlString(xml);
                po = roiXMLParser.parse();
                CreateRoiObjectsFromParseObject createRoiObjectsFromParseObject = new CreateRoiObjectsFromParseObject(sessionController, sessionController.getRootFolder());
                Vector vAttributes = createRoiObjectsFromParseObject.create(po);
                String[] sAttributes = null;
                if (vAttributes != null) {
                    int len = vAttributes.size();
                    sAttributes = new String[len];
                    for (int i = 0; i < len; ++i) {
                        sAttributes[i] = ((AttributeValue)vAttributes.elementAt(i)).toString(sessionController);
                    }
                }
                responseBean.setReturnValues(sAttributes);
                rth.end();
                rth = null;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (rth != null) {
                    try {
                        rth.abort();
                    }
                    catch (Exception exception) {}
                    rth = null;
                }
            }
        }
        catch (RoiException re) {
            responseBean.setErrorKey(WebServiceErrorKeys.NGFS_ERROR);
            responseBean.setLogError("an ngfs error has occured: " + re.getErrorKey() + ", " + re.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            responseBean.setErrorKey(WebServiceErrorKeys.UNKNOWN_ERROR);
            responseBean.setLogError("an unknown error has occured: " + e.getLocalizedMessage());
        }
        return responseBean;
    }
}

