/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.interfaces.webservices.server.common;

import agorum.commons.cron.Trace;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.interfaces.webservices.client.beans.administration.AddToAclRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.AddToGroupRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.DeleteUserRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAclEntriesRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAssociatedAclsOfDirectoryGroupRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAssociatedAclsOfDirectoryUserRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetAssociatedGroupsOfDirectoryObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.GetGroupMembersRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.ModifyUserRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.RemoveFromAclRequestBean;
import agorum.roi.interfaces.webservices.client.beans.administration.RemoveFromGroupRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseItemsRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseRequestBean;
import agorum.roi.interfaces.webservices.client.beans.common.BaseResponseBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceDeleteItemsRequestBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceIsUserControlObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.eventassistance.EventAssistanceUserControlObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.AddItemToFolderRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.CopyObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.DownloadFileRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.MoveObjectRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.RemoveItemFromFolderRequestBean;
import agorum.roi.interfaces.webservices.client.beans.filing.UploadFileRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetItemsAttributesRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetItemsFromFolderRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetItemsFromRelationRequestBean;
import agorum.roi.interfaces.webservices.client.beans.items.GetObjectByAttributeRequestBean;
import agorum.roi.interfaces.webservices.client.beans.login.LoginRequestBean;
import agorum.roi.interfaces.webservices.client.beans.login.LogoutRequestBean;
import agorum.roi.interfaces.webservices.client.beans.parsexml.ParseXMLRequestBean;
import agorum.roi.interfaces.webservices.client.beans.search.SearchRequestBean;
import agorum.roi.interfaces.webservices.client.beans.system.BeginTransactionRequestBean;
import agorum.roi.interfaces.webservices.server.AdministrationService;
import agorum.roi.interfaces.webservices.server.EventAssistanceService;
import agorum.roi.interfaces.webservices.server.FilingService;
import agorum.roi.interfaces.webservices.server.GetItemsService;
import agorum.roi.interfaces.webservices.server.LoginService;
import agorum.roi.interfaces.webservices.server.ParseXMLService;
import agorum.roi.interfaces.webservices.server.SearchService;
import agorum.roi.interfaces.webservices.server.common.WebServiceCallerThread;
import agorum.webcomponents.webservices.beans.WebServiceSessionBean;

public class WebServiceTransactionHandler
extends Thread {
    private long transactionTimeout = 0L;
    private boolean finishTransaction = false;
    private RoiTransactionHandler roiTransactionHandler = null;
    private boolean hasTimedout = true;
    private boolean transactionIsRunning = false;
    private boolean hasProcessed = false;
    private BaseRequestBean inputRequestBean = null;
    private String serviceFunction = null;
    private BaseResponseBean outputResponseBean = null;
    private WebServiceCallerThread caller = null;
    public static long threadCounter = 0L;
    private String transactionId = null;
    private boolean eventWasSet = false;

    public WebServiceTransactionHandler(long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public static WebServiceTransactionHandler beginTransaction(BeginTransactionRequestBean transBean, String transactionId) {
        WebServiceTransactionHandler wth = new WebServiceTransactionHandler(transBean.getTransactionTimeout());
        wth.setTransactionId(transactionId);
        wth.start();
        return wth;
    }

    public static BaseResponseBean runService(String serviceFunction, BaseRequestBean requestBean, WebServiceTransactionHandler transHandler) throws Exception {
        WebServiceCallerThread ct = new WebServiceCallerThread(transHandler, requestBean, serviceFunction);
        ct.start();
        ct.runner();
        return ct.getResponseBean();
    }

    public boolean isTransactionValid() {
        return this.transactionIsRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (Trace.Auto trace = Trace.auto((String)"WebService transaction handler");){
            ++threadCounter;
            try {
                trace.starting();
                this.roiTransactionHandler = new RoiTransactionHandler();
                this.roiTransactionHandler.begin();
                this.transactionIsRunning = true;
                while (!this.finishTransaction) {
                    trace.waiting("Waiting for event");
                    this.hasTimedout = true;
                    boolean isTimedout = this.waitForEvent();
                    if (isTimedout) {
                        this.roiTransactionHandler.abort();
                        this.finishTransaction = true;
                        break;
                    }
                    if (this.hasTimedout) continue;
                    trace.working("Calling service");
                    if (this.finishTransaction) continue;
                    try {
                        this.outputResponseBean = this.callService(this.inputRequestBean, this.serviceFunction);
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.err);
                    }
                    this.hasProcessed = true;
                    if (this.caller != null) {
                        this.caller.notifyMe();
                    }
                    this.caller = null;
                }
                trace.ended();
            }
            catch (Exception e) {
                trace.failed();
                e.printStackTrace(System.err);
            }
            finally {
                if (this.caller != null) {
                    try {
                        this.caller.notifyMe();
                    }
                    catch (Exception exception) {}
                }
            }
            this.transactionIsRunning = false;
            System.err.println("Transaction Thread has finished: " + --threadCounter + ", " + this.hashCode());
            return;
        }
    }

    public boolean hasProcessed() {
        return this.hasProcessed;
    }

    public synchronized boolean waitForEvent() throws Exception {
        long time = System.currentTimeMillis();
        this.eventWasSet = false;
        while (!this.eventWasSet) {
            this.wait(this.transactionTimeout);
            if (System.currentTimeMillis() - time <= this.transactionTimeout - 100L) continue;
            return true;
        }
        return false;
    }

    public synchronized void notifyMe() throws Exception {
        this.eventWasSet = true;
        this.notify();
    }

    public synchronized void performService(String service, BaseRequestBean requestBean, WebServiceCallerThread callerThread) throws Exception {
        this.hasProcessed = false;
        this.caller = callerThread;
        this.outputResponseBean = null;
        if (!this.transactionIsRunning) {
            throw new Exception("Transaction is not running");
        }
        this.serviceFunction = service;
        this.inputRequestBean = requestBean;
        this.hasTimedout = false;
        this.notifyMe();
    }

    public BaseResponseBean getOutputResponseBean() {
        return this.outputResponseBean;
    }

    public void setTransactionId(String transId) {
        this.transactionId = transId;
    }

    public BaseResponseBean callService(BaseRequestBean reqBean, String function) throws Exception {
        WebServiceSessionBean wsSessionBean = reqBean.getWsSessionBean();
        BaseResponseBean respBean = null;
        if (function.equals("endTransaction")) {
            this.roiTransactionHandler.end();
            this.roiTransactionHandler = null;
            this.finishTransaction = true;
        } else if (function.equals("abortTransaction")) {
            this.roiTransactionHandler.abort();
            this.roiTransactionHandler = null;
            this.finishTransaction = true;
        } else if (function.equals("login")) {
            LoginService loginService = new LoginService(wsSessionBean);
            respBean = loginService.login((LoginRequestBean)reqBean);
        } else if (function.equals("logout")) {
            LoginService loginService = new LoginService(wsSessionBean);
            respBean = loginService.logout((LogoutRequestBean)reqBean);
        } else if (function.equals("search")) {
            SearchService searchService = new SearchService(wsSessionBean);
            respBean = searchService.search((SearchRequestBean)reqBean);
        } else if (function.equals("addToGroup")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.addToGroup((AddToGroupRequestBean)reqBean);
        } else if (function.equals("removeFromGroup")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.removeFromGroup((RemoveFromGroupRequestBean)reqBean);
        } else if (function.equals("getGroupMembers")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.getGroupMembers((GetGroupMembersRequestBean)reqBean);
        } else if (function.equals("addToAcl")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.addToAcl((AddToAclRequestBean)reqBean);
        } else if (function.equals("removeFromAcl")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.removeFromAcl((RemoveFromAclRequestBean)reqBean);
        } else if (function.equals("getAclEntries")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.getAclEntries((GetAclEntriesRequestBean)reqBean);
        } else if (function.equals("modifyUser")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.modifyUser((ModifyUserRequestBean)reqBean);
        } else if (function.equals("deleteUser")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.deleteUser((DeleteUserRequestBean)reqBean);
        } else if (function.equals("getFreeDBSize")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.getFreeDBSize(reqBean);
        } else if (function.equals("getAssociatedAclsOfDirectoryGroup")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.getAssociatedAclsOfDirectoryGroup((GetAssociatedAclsOfDirectoryGroupRequestBean)reqBean);
        } else if (function.equals("getAssociatedAclsOfDirectoryUser")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.getAssociatedAclsOfDirectoryUser((GetAssociatedAclsOfDirectoryUserRequestBean)reqBean);
        } else if (function.equals("getAssociatedGroupsOfDirectoryObject")) {
            AdministrationService adminService = new AdministrationService(wsSessionBean);
            respBean = adminService.getAssociatedGroupsOfDirectoryObject((GetAssociatedGroupsOfDirectoryObjectRequestBean)reqBean);
        } else if (function.equals("moveObject")) {
            FilingService filingService = new FilingService(wsSessionBean);
            respBean = filingService.moveObject((MoveObjectRequestBean)reqBean);
        } else if (function.equals("copyObject")) {
            FilingService filingService = new FilingService(wsSessionBean);
            respBean = filingService.copyObject((CopyObjectRequestBean)reqBean);
        } else if (function.equals("addItemToFolder")) {
            FilingService filingService = new FilingService(wsSessionBean);
            respBean = filingService.addItemToFolder((AddItemToFolderRequestBean)reqBean);
        } else if (function.equals("removeItemFromFolder")) {
            FilingService filingService = new FilingService(wsSessionBean);
            respBean = filingService.removeItemFromFolder((RemoveItemFromFolderRequestBean)reqBean);
        } else if (function.equals("uploadFile")) {
            FilingService filingService = new FilingService(wsSessionBean);
            respBean = filingService.uploadFile((UploadFileRequestBean)reqBean);
        } else if (function.equals("downloadFile")) {
            FilingService filingService = new FilingService(wsSessionBean);
            respBean = filingService.downloadFile((DownloadFileRequestBean)reqBean);
        } else if (function.equals("getItemsFromFolder")) {
            GetItemsService itemsService = new GetItemsService(wsSessionBean);
            respBean = itemsService.getItemsFromFolder((GetItemsFromFolderRequestBean)reqBean);
        } else if (function.equals("getItemsFromRelation")) {
            GetItemsService itemsService = new GetItemsService(wsSessionBean);
            respBean = itemsService.getItemsFromRelation((GetItemsFromRelationRequestBean)reqBean);
        } else if (function.equals("getItemsAttributes")) {
            GetItemsService itemsService = new GetItemsService(wsSessionBean);
            respBean = itemsService.getItemsAttributes((GetItemsAttributesRequestBean)reqBean);
        } else if (function.equals("getObjectByAttribute")) {
            GetItemsService itemsService = new GetItemsService(wsSessionBean);
            respBean = itemsService.getObjectByAttribute((GetObjectByAttributeRequestBean)reqBean);
        } else if (function.equals("parseXML")) {
            ParseXMLService parseService = new ParseXMLService(wsSessionBean);
            respBean = parseService.parse((ParseXMLRequestBean)reqBean);
        } else if (function.equals("eventAssistanceGetItems")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceGetItems((BaseItemsRequestBean)reqBean);
        } else if (function.equals("eventAssistanceHasNewItems")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceHasNewItems(reqBean);
        } else if (function.equals("eventAssistanceDeleteItems")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceDeleteItems((EventAssistanceDeleteItemsRequestBean)reqBean);
        } else if (function.equals("eventAssistanceDeleteAllItems")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceDeleteAllItems(reqBean);
        } else if (function.equals("eventAssistanceCreateUserControlObjects")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceCreateUserControlObjects((EventAssistanceUserControlObjectRequestBean)reqBean);
        } else if (function.equals("eventAssistanceGetUserControlObjects")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceGetUserControlObjects((EventAssistanceUserControlObjectRequestBean)reqBean);
        } else if (function.equals("eventAssistanceRemoveUserControlObjects")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceRemoveUserControlObjects((EventAssistanceUserControlObjectRequestBean)reqBean);
        } else if (function.equals("eventAssistanceIsUserControlObject")) {
            EventAssistanceService eventAssistanceService = new EventAssistanceService(wsSessionBean);
            respBean = eventAssistanceService.eventAssistanceIsUserControlObject((EventAssistanceIsUserControlObjectRequestBean)reqBean);
        } else {
            System.err.println("Function: " + function + " is not defined!!");
        }
        return respBean;
    }
}

