/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.lucene.ejb.beans;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.utils.WaitThread;
import agorum.roi.common.ReplaceQueryPlaceholder;
import agorum.roi.common.beans.IndexObjectHolder;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.IndexSearchInfoBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.TextIndexQueue;
import agorum.roi.exception.RoiException;
import agorum.roi.lucene.common.Personalize;
import agorum.roi.lucene.ejb.beans.RoiIndexSyncBean;
import agorum.roi.lucene.ejb.common.LuceneResultBean;
import agorum.roi.searchengine.AdvancedSearchQuery;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.searchengine.DocumentServiceSearchEngineIndexSystemStatistic;
import agorum.roi.statistic.searchengine.IndexStatistic;
import agorum.roi.statistic.searchengine.SearchStatistic;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class RoiIndexEJB
implements SessionBean {
    private static final long serialVersionUID = 1L;
    private static final SearchStatistic stat = SearchStatistic.getInstance();
    private static final IndexStatistic indexStat = IndexStatistic.getInstance();
    DocumentServiceSearchEngineIndexSystemStatistic statisticHandlerIndex = new DocumentServiceSearchEngineIndexSystemStatistic();
    DocumentServiceSearchEngineIndexSystemStatistic statisticHandlerSearch = new DocumentServiceSearchEngineIndexSystemStatistic();
    protected SessionContext context;
    public static boolean optimize;
    private static Long privateAclId;

    public void ejbCreate() {
    }

    public void ejbPassivate() {
    }

    public void ejbActivate() {
    }

    public void ejbRemove() {
    }

    public void setSessionContext(SessionContext sc) {
        this.context = sc;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean buildIndex(SessionController sessionController, int amount, String indexName) throws RemoteException, Exception {
        if (optimize) {
            optimize = false;
            indexStat.info("optimizing index");
            long time = System.currentTimeMillis();
            this.optimize(sessionController, indexName);
            indexStat.info("index optimization finished in: " + (System.currentTimeMillis() - time));
        }
        indexStat.debug("begin building index...");
        if (amount < 0) {
            return false;
        }
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerIndex);){
            ArrayList<IndexObjectHolder> toIndex;
            boolean hasMore;
            indexHandler.openForIndexing(indexName);
            if (!indexHandler.supportsIndexReaderDelete()) {
                indexHandler.prepareWrite(sessionController, true);
            }
            try (Connection conn = new ConnectionUtils().getConnection();){
                List<IndexObjectHolder> items = TextIndexQueue.collect(conn, amount);
                hasMore = items.size() >= amount;
                HashMap<Long, IndexObjectHolder> map = new HashMap<Long, IndexObjectHolder>();
                for (IndexObjectHolder ioh : items) {
                    map.put(ioh.getId(), ioh);
                }
                toIndex = new ArrayList<IndexObjectHolder>(map.values());
                for (IndexObjectHolder ioh : toIndex) {
                    TextIndexQueue.clearDuplicates(conn, ioh);
                }
            }
            if (indexHandler.supportsIndexReaderDelete()) {
                indexHandler.prepareWrite(sessionController, true);
            }
            indexStat.debug("Indexing " + toIndex.size() + " objects.");
            var9_10 = null;
            try (IndexHelper.Modifier m = IndexHelper.authoritative();
                 IndexHelper.JavaScriptHandler h = IndexHelper.javaScriptHandler(sessionController);){
                indexHandler.buildIndexFromList(sessionController, toIndex);
            }
            catch (Throwable throwable) {
                var9_10 = throwable;
                throw throwable;
            }
            indexStat.debug("Indexing done, hasMore? " + hasMore);
            boolean bl = hasMore;
            return bl;
        }
        catch (Exception e) {
            indexStat.error(e, "Error in buildIndex");
            throw ExceptionUtils.get(e);
        }
    }

    public void exportIndex(SessionController sessionController, String indexName, boolean secondIndex) throws RemoteException, Exception {
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerIndex);){
            indexHandler.exportIndex(sessionController, indexName, secondIndex);
        }
    }

    public void exportFsIndex(SessionController sessionController, boolean secondIndex) throws RemoteException, Exception {
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerIndex);){
            indexHandler.exportFsIndex(sessionController, secondIndex);
        }
    }

    public void closeGlobalIndexSearch(SessionController sessionController) throws RemoteException, Exception {
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerIndex);){
            indexHandler.closeGlobalIndexSearch();
        }
    }

    public void importIndex(SessionController sessionController, String indexName, boolean secondIndex) throws RemoteException, Exception {
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerIndex);){
            indexHandler.importIndex(sessionController, indexName, secondIndex);
        }
    }

    public boolean optimize(SessionController sessionController, String indexName) throws RemoteException, Exception {
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerIndex);){
            boolean bl = indexHandler.optimize(sessionController, indexName);
            return bl;
        }
    }

    public void cleanup(SessionController sessionController) throws RemoteException, Exception {
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerIndex);){
            indexHandler.cleanUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getTerms(SessionController sessionController, String field, String query, int maxAmount) throws Exception {
        Throwable throwable = null;
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerSearch);){
            boolean slot = this.waitForSearchSlot(indexHandler, sessionController, query);
            try {
                indexHandler.openForSearch();
                List<String> list = indexHandler.getTerms(sessionController, field, query, maxAmount);
                if (slot) {
                    this.releaseSearchSlot();
                }
                return list;
            }
            catch (Throwable throwable2) {
                try {
                    if (slot) {
                        this.releaseSearchSlot();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> search(SessionController sessionController, String query, int limit, boolean hidden) throws Exception {
        ArrayList<String> results = new ArrayList<String>();
        Throwable throwable = null;
        try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerSearch);){
            boolean slot = this.waitForSearchSlot(indexHandler, sessionController, query);
            try {
                indexHandler.openForSearch();
                query = this.preprocess(sessionController, query, hidden);
                long time = System.currentTimeMillis();
                for (LuceneResultBean lrb : indexHandler.search(sessionController, query, limit)) {
                    results.add(lrb.getKey());
                }
                stat.count("Search Count", 1L);
                stat.measure("Search Raw Time", "ms", System.currentTimeMillis() - time);
                stat.measure("Search Hits Per Query", "Hits", results.size());
                ArrayList<String> arrayList = results;
                if (slot) {
                    this.releaseSearchSlot();
                }
                return arrayList;
            }
            catch (Throwable throwable2) {
                try {
                    if (slot) {
                        this.releaseSearchSlot();
                    }
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector indexSearch(SessionController sessionController, String queryString, int maxSearchResult, boolean withInfo) throws RemoteException, Exception {
        Vector<Object> vResult = new Vector<Object>();
        if (queryString.equals("()") || queryString.equals("(())")) {
            return vResult;
        }
        try {
            if (maxSearchResult <= 0) {
                maxSearchResult = Integer.MAX_VALUE;
            }
            long timeAll = System.currentTimeMillis();
            try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerSearch);){
                long time1 = System.currentTimeMillis();
                boolean slot = this.waitForSearchSlot(indexHandler, sessionController, queryString);
                try {
                    if (stat.logDebug()) {
                        stat.debug("Search: time waitForSearchSlot: " + (System.currentTimeMillis() - time1));
                    }
                    stat.measure("Search Wait Time", "ms", System.currentTimeMillis() - time1);
                    long time2 = System.currentTimeMillis();
                    indexHandler.openForSearch();
                    if (stat.logDebug()) {
                        stat.debug("Search: time openSearch: " + (System.currentTimeMillis() - time2));
                    }
                    stat.measure("Search Open Time", "ms", System.currentTimeMillis() - time2);
                    stat.count("Search Count", 1L);
                    if (stat.logDebug()) {
                        stat.debug("raw query: " + queryString);
                    }
                    queryString = this.preprocess(sessionController, queryString, false);
                    if (stat.logDebug()) {
                        stat.debug("complete query: " + queryString);
                    }
                    long time3 = System.currentTimeMillis();
                    List<LuceneResultBean> result = indexHandler.search(sessionController, queryString, maxSearchResult);
                    if (stat.logDebug()) {
                        stat.debug("Search: raw search time: " + (System.currentTimeMillis() - time3));
                    }
                    stat.measure("Search Raw Time", "ms", System.currentTimeMillis() - time3);
                    long hitCount = indexHandler.getHitCount();
                    stat.measure("Search Hits Per Query", "Hits", hitCount);
                    if (stat.logDebug()) {
                        stat.debug("hit count from search engine: " + hitCount);
                    }
                    if (withInfo) {
                        IndexSearchInfoBean isib = new IndexSearchInfoBean();
                        isib.setSearchCount(hitCount);
                        vResult.insertElementAt(isib, 0);
                    }
                    for (LuceneResultBean lrb : result) {
                        vResult.add(lrb.getKey());
                    }
                }
                finally {
                    if (slot) {
                        this.releaseSearchSlot();
                    }
                }
            }
            if (stat.logDebug()) {
                stat.debug("complete search time: " + (System.currentTimeMillis() - timeAll));
            }
            stat.measure("Search Total Time", "ms", System.currentTimeMillis() - timeAll);
        }
        catch (Exception e) {
            stat.error(e, "Error in search");
            ExceptionUtils.handleException(e);
        }
        return vResult;
    }

    private String preprocess(SessionController sessionController, String query, boolean hidden) throws Exception {
        query = Personalize.query(sessionController, query);
        try (IndexHandlerInterface ih = IndexHelper.getIndexHandler(this.statisticHandlerSearch);){
            query = ih.changeQueryString(sessionController, query);
        }
        var5_5 = null;
        try (Connection conn = new ConnectionUtils().getConnection();){
            query = this.addAccessToQuery(sessionController, query, conn);
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        if (!hidden) {
            query = "(" + query + ") NOT hidden:true";
        }
        return query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseSearchSlot() {
        Object object = RoiIndexSyncBean.syncer;
        synchronized (object) {
            RoiIndexSyncBean.removeSearchCounter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForSearchSlot(IndexHandlerInterface ih, SessionController sessionController, String query) throws RoiException {
        Object value2;
        if (ih.supportsAdvancedSearch()) {
            return false;
        }
        long maxWaitTime = 30000L;
        long waitTime = 100L;
        int maxSearchCounter = -1;
        try {
            MetaDb mdb = sessionController.getMetaDbInstance();
            try {
                value2 = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/search/MaxWaitTime")[0];
                maxWaitTime = new Long((String)value2);
            }
            catch (Throwable value2) {
                // empty catch block
            }
            try {
                value2 = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/search/WaitTime")[0];
                waitTime = new Long((String)value2);
            }
            catch (Throwable value3) {
                // empty catch block
            }
            try {
                value2 = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/search/MaxParalellSearch")[0];
                maxSearchCounter = new Integer((String)value2);
            }
            catch (Throwable value4) {}
        }
        catch (Throwable mdb) {
            // empty catch block
        }
        boolean search = false;
        while (!search && maxWaitTime > 0L) {
            value2 = RoiIndexSyncBean.syncer;
            synchronized (value2) {
                if (stat.logDebug()) {
                    stat.debug("search stopped? " + RoiIndexSyncBean.getStopSearch());
                }
                if (!RoiIndexSyncBean.getStopSearch()) {
                    if (maxSearchCounter == -1) {
                        maxSearchCounter = RoiIndexSyncBean.getMaxSearchCounter();
                    }
                    if (RoiIndexSyncBean.getSearchCounter() < maxSearchCounter || maxSearchCounter == 0) {
                        RoiIndexSyncBean.addSearchCounter();
                        search = true;
                    }
                }
            }
            if (search) continue;
            if (stat.logDebug()) {
                stat.debug("Search Wait : " + maxWaitTime);
            }
            WaitThread wt = new WaitThread(waitTime);
            wt.doWait();
            maxWaitTime -= waitTime;
        }
        if (search) {
            return true;
        }
        ExceptionUtils.handleException("MaxWaitTime expired (Query: '" + query + "').", "agorum.roi.remote.exception.SearchMaxWaitTimeExpired", 500);
        return false;
    }

    private String addAccessToQuery(SessionController sc, String queryString, Connection conn) throws Exception {
        StringBuilder sb = new StringBuilder("(");
        sb.append(queryString);
        sb.append(") (deletor:0 OR deletor:");
        sb.append(sc.getLoginUserId());
        sb.append(") ");
        if (!sc.isMainAdmin()) {
            if (privateAclId == null) {
                privateAclId = (long)sc.getAclByName("Private").getId();
            }
            sb.append("(owner:");
            sb.append(sc.getLoginUserId());
            sb.append(" OR acl:(");
            String or = "";
            for (Long acl : this.getUserAcls(sc, null, conn)) {
                if (acl.equals(privateAclId)) continue;
                sb.append(or);
                sb.append(acl);
                or = " OR ";
            }
            if (sc.isAdminEnabled()) {
                sb.append(") OR (allfields:uuid NOT acl_adminsaffected:true))");
            } else {
                sb.append("))");
            }
        }
        return ReplaceQueryPlaceholder.replaceAllPlaceHolders(sb.toString(), sc);
    }

    public List<Long> getUserAclIds(SessionController sessionController, String userId) throws RemoteException, Exception {
        long uId = sessionController.getRoleId();
        if (userId != null) {
            uId = sessionController.findGlobalObjectByPathOrId(userId).getId();
        }
        try (Connection conn = new ConnectionUtils().getConnection();){
            List<Long> list = this.getUserAcls(sessionController, uId, conn);
            return list;
        }
    }

    /*
     * Exception decompiling
     */
    private List<Long> getUserAcls(SessionController sessionController, Long userId, Connection conn) throws RemoteException, Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public AdvancedSearchQuery prepareAdvancedSearch(SessionController sessionController, String query) throws Exception {
        IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(this.statisticHandlerSearch);
        query = indexHandler.changeQueryString(sessionController, query);
        try (Connection conn = new ConnectionUtils().getConnection();){
            query = this.addAccessToQuery(sessionController, query, conn);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return new AdvancedSearchQuery(sessionController, indexHandler, query);
    }
}

