/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache;

import agorum.agceptit.metadb.client.statistic.MetaDbStatistic;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyGroupObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.cache.beans.BundleBean;
import agorum.roi.metadb.cache.beans.EntryBean;
import agorum.roi.metadb.cache.beans.NodeBean;
import agorum.roi.metadb.cache.tree.Entry;
import agorum.roi.metadb.cache.tree.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class NoCache {
    private static final SystemStatistic stat = MetaDbStatistic.getInstance();

    private NoCache() {
    }

    public static NodeBean get(SessionController sessionController, String path) throws Exception {
        stat.count("MetaDb no cache property requests", 1L);
        return NoCache.get(NoCache.lookup(sessionController, path));
    }

    public static List<NodeBean> list(SessionController sessionController, String path, Node.Type type) throws Exception {
        stat.count("MetaDb no cache property requests", 1L);
        return NoCache.list(NoCache.lookup(sessionController, path), type);
    }

    private static NodeBean get(GlobalObjectClientBean obj) throws Exception {
        if (obj instanceof MetaDbPropertyEntryObjectClientBean) {
            EntryBean bean = new EntryBean();
            bean.setId(obj.getId());
            bean.setName(obj.getName());
            bean.setValue(Entry.getValue(obj));
            return bean;
        }
        if (obj instanceof MetaDbPropertyBundleObjectClientBean) {
            BundleBean bean = new BundleBean();
            bean.setId(obj.getId());
            bean.setName(obj.getName());
            return bean;
        }
        return null;
    }

    private static List<NodeBean> list(GlobalObjectClientBean obj, Node.Type type) throws Exception {
        if (obj instanceof MetaDbPropertyEntryObjectClientBean) {
            throw new UnsupportedOperationException();
        }
        if (obj instanceof MetaDbPropertyBundleObjectClientBean) {
            ArrayList<NodeBean> result = new ArrayList<NodeBean>();
            NoCache.gatherChildren((FolderObjectClientBean)obj, type, result);
            return result;
        }
        if (obj instanceof MetaDbPropertyGroupObjectClientBean) {
            ArrayList<NodeBean> result = new ArrayList<NodeBean>();
            NoCache.gatherChildren((FolderObjectClientBean)obj, type, result);
            return result;
        }
        return null;
    }

    private static void gatherChildren(FolderObjectClientBean folder, Node.Type type, List<NodeBean> result) throws Exception {
        GlobalObjectClientBean[] objs = folder.getItems();
        if (objs == null) {
            return;
        }
        for (GlobalObjectClientBean obj : objs) {
            if (obj instanceof MetaDbPropertyGroupObjectClientBean) {
                NoCache.gatherChildren((FolderObjectClientBean)obj, type, result);
                continue;
            }
            if (!NoCache.matchType(type, obj)) continue;
            result.add(NoCache.get(obj));
        }
    }

    private static boolean matchType(Node.Type type, GlobalObjectClientBean obj) {
        if (type == null) {
            return true;
        }
        switch (type) {
            case BUNDLE: {
                return obj instanceof MetaDbPropertyBundleObjectClientBean;
            }
            case ENTRY: {
                return obj instanceof MetaDbPropertyEntryObjectClientBean;
            }
        }
        return false;
    }

    private static GlobalObjectClientBean lookup(SessionController sc, String path) throws Exception {
        return NoCache.lookup(sc, (FolderObjectClientBean)sc.findGlobalObjectByPath("/agorum/ngos/MetaDb"), Arrays.asList(path.split("/")));
    }

    private static GlobalObjectClientBean lookup(SessionController sc, GlobalObjectClientBean object, List<String> path) throws Exception {
        if (path.isEmpty()) {
            return object;
        }
        String name = path.get(0);
        List<String> tail = path.subList(1, path.size());
        if (name.isEmpty()) {
            return NoCache.lookup(sc, object, tail);
        }
        if (object instanceof FolderObjectClientBean) {
            FolderObjectClientBean folder = (FolderObjectClientBean)object;
            GlobalObjectClientBean result = NoCache.lookup(sc, folder.getItem(name), tail);
            if (result != null) {
                return result;
            }
            for (GlobalObjectClientBean item : folder.items()) {
                if (!(item instanceof MetaDbPropertyGroupObjectClientBean) || (result = NoCache.lookup(sc, item, path)) == null) continue;
                return result;
            }
        }
        return null;
    }
}

