/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache.transaction;

import agorum.commons.logging.Log;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyGroupObjectClientBean;
import agorum.roi.ejb.common.FolderPathUtil;
import agorum.roi.metadb.cache.Context;
import agorum.roi.metadb.cache.MetaDbCache;
import java.util.ArrayList;
import java.util.List;

public abstract class Modification {
    protected Context context;

    public Modification(Context context) {
        this.context = context;
    }

    public abstract boolean gone() throws Exception;

    public abstract void commit() throws Exception;

    public abstract List<String> invalidatesGet() throws Exception;

    public abstract List<String> invalidatesList() throws Exception;

    protected List<String> getAllPaths(GlobalObjectClientBean obj) throws Exception {
        ArrayList<String> paths = new ArrayList<String>();
        this.gatherAllPaths(obj, paths);
        return paths;
    }

    protected void gatherAllPaths(GlobalObjectClientBean obj, List<String> paths) throws Exception {
        for (List<GlobalObjectClientBean> segments : FolderPathUtil.get(obj, MetaDbCache.getInstance().getRootId(), MetaDbCache.getInstance().getRootId()).values()) {
            this.gatherAllPaths(segments.subList(1, segments.size()), paths, new ArrayList<String>());
        }
    }

    private void gatherAllPaths(List<GlobalObjectClientBean> segments, List<String> paths, List<String> path) throws Exception {
        if (segments.isEmpty()) {
            paths.add(String.join((CharSequence)"/", path));
            return;
        }
        GlobalObjectClientBean head = segments.get(0);
        List<GlobalObjectClientBean> tail = segments.subList(1, segments.size());
        if (head instanceof MetaDbPropertyGroupObjectClientBean) {
            this.gatherAllPaths(tail, paths, new ArrayList<String>(path));
        }
        path.add(head.getName().toLowerCase());
        this.gatherAllPaths(tail, paths, path);
    }

    protected boolean gone(GlobalObjectClientBean obj) {
        try {
            return obj.getSessionController().getGlobalObjectById(obj.getId()) == null;
        }
        catch (Exception e) {
            Log.debug((Throwable)e);
            return true;
        }
    }
}

