/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache.transaction;

import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.metadb.cache.Context;
import agorum.roi.metadb.cache.transaction.Modification;
import agorum.roi.metadb.cache.tree.Node;
import java.util.ArrayList;
import java.util.List;

public class RemoveItem
extends Modification {
    private final GlobalObjectClientBean folder;
    private final String name;

    public RemoveItem(Context context, GlobalObjectClientBean folder, String name) {
        super(context);
        this.folder = folder;
        this.name = name;
    }

    @Override
    public boolean gone() {
        return this.gone(this.folder);
    }

    @Override
    public void commit() throws Exception {
        Node node = (Node)this.context.get(this.folder.getId());
        if (node == null) {
            return;
        }
        node.removeChild(this.name);
    }

    @Override
    public List<String> invalidatesGet() throws Exception {
        List<String> paths = this.getAllPaths(this.folder);
        ArrayList<String> result = new ArrayList<String>(paths.size());
        for (String path : paths) {
            result.add(path.isEmpty() ? this.name : path + "/" + this.name);
        }
        return result;
    }

    @Override
    public List<String> invalidatesList() throws Exception {
        return this.getAllPaths(this.folder);
    }
}

