/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache.transaction;

import agorum.commons.logging.Log;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.cache.transaction.Modification;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Transaction {
    private final List<Modification> modifications = new ArrayList<Modification>();
    private final List<String> invalidatedGet = new ArrayList<String>();
    private final List<String> invalidatedList = new ArrayList<String>();
    private int invalidationIndex;
    private static final ThreadLocal<Transaction> threadTransactions = new ThreadLocal<Transaction>(){

        @Override
        public Transaction initialValue() {
            return new Transaction();
        }
    };

    private Transaction() {
    }

    public static Transaction getInstance() {
        return threadTransactions.get();
    }

    public void commit() throws Exception {
        this.keepAlive();
        for (Modification update : this.modifications) {
            try {
                if (update.gone()) continue;
                update.commit();
            }
            catch (Exception e) {
                Log.warning((Throwable)e);
            }
        }
    }

    public void clear() {
        threadTransactions.remove();
    }

    public void add(Modification update) {
        this.modifications.add(update);
    }

    public boolean invalidGet(String path) throws Exception {
        return this.invalid(path, this.invalidatedGet);
    }

    public boolean invalidList(String path) throws Exception {
        return this.invalid(path, this.invalidatedList);
    }

    private void keepAlive() {
        try {
            SessionControllerAdmin.getSessionControllerAdmin("MetaDbCache");
        }
        catch (Exception e) {
            Log.warning((Throwable)e);
            throw new RuntimeException("Could not connect admin session", e);
        }
    }

    private boolean invalid(String path, List<String> invalidated) throws Exception {
        if (this.modifications.size() <= 0) {
            return false;
        }
        this.gatherInvalidated();
        path = path.toLowerCase().replaceAll("^/+|/+$", "").replaceAll("//+", "/");
        for (String prefix : invalidated) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private void gatherInvalidated() throws Exception {
        int len = this.modifications.size();
        if (this.invalidationIndex >= len) {
            return;
        }
        this.keepAlive();
        for (int i = this.invalidationIndex; i < len; ++i) {
            Modification modification = this.modifications.get(i);
            if (modification.gone()) continue;
            for (String toAdd : modification.invalidatesGet()) {
                this.addInvalidated(this.invalidatedGet, toAdd);
            }
            for (String toAdd : modification.invalidatesList()) {
                this.addInvalidated(this.invalidatedList, toAdd);
            }
        }
        this.invalidationIndex = len;
    }

    private void addInvalidated(List<String> invalidated, String toAdd) {
        toAdd = toAdd.toLowerCase();
        Iterator<String> iter = invalidated.iterator();
        while (iter.hasNext()) {
            String existing = iter.next();
            if (toAdd.startsWith(existing)) {
                return;
            }
            if (!existing.startsWith(toAdd)) continue;
            iter.remove();
        }
        invalidated.add(toAdd);
    }
}

