/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache.tree;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyEntryObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyGroupObjectClientBean;
import agorum.roi.metadb.cache.Context;
import agorum.roi.metadb.cache.beans.BundleBean;
import agorum.roi.metadb.cache.beans.NodeBean;
import agorum.roi.metadb.cache.tree.Entry;
import agorum.roi.metadb.cache.tree.Group;
import agorum.roi.metadb.cache.tree.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Bundle
extends Node {
    private final Map<String, Node> children = new HashMap<String, Node>();
    private final Set<Group> groups = new HashSet<Group>();

    public Bundle(Context context, GlobalObjectClientBean obj) throws Exception {
        super(context, obj);
        if (!(obj instanceof FolderObjectClientBean)) {
            throw new IllegalArgumentException("Bundle expected");
        }
        FolderObjectClientBean folder = (FolderObjectClientBean)obj;
        GlobalObjectClientBean[] items = folder.getItems();
        if (items == null) {
            return;
        }
        for (GlobalObjectClientBean item : items) {
            this.addChild(item);
        }
    }

    @Override
    protected BundleBean getBean() {
        BundleBean bean = new BundleBean();
        bean.setId(this.getId());
        bean.setName(this.getName());
        return bean;
    }

    @Override
    public NodeBean get(StringTokenizer tokenizer) {
        if (tokenizer.hasMoreTokens()) {
            Node child = this.findChild(tokenizer.nextToken());
            if (child == null) {
                return null;
            }
            return child.get(tokenizer);
        }
        return this.getBean();
    }

    @Override
    public List<NodeBean> list(StringTokenizer tokenizer, Node.Type type) {
        if (tokenizer.hasMoreTokens()) {
            Node child = this.findChild(tokenizer.nextToken());
            if (child == null) {
                return null;
            }
            return child.list(tokenizer, type);
        }
        ArrayList<NodeBean> result = new ArrayList<NodeBean>();
        this.gatherChildren(result, type);
        return result;
    }

    @Override
    protected void delete() {
        super.delete();
        HashSet<String> names = new HashSet<String>();
        for (String name : this.children.keySet()) {
            names.add(name);
        }
        for (String name : names) {
            this.remove(name);
        }
    }

    @Override
    public void addChild(GlobalObjectClientBean item) throws Exception {
        Long id = item.getId();
        String name = item.getName().toLowerCase();
        Node child = (Node)this.context.get(id);
        if (child == null) {
            if (item instanceof MetaDbPropertyEntryObjectClientBean) {
                child = new Entry(this.context, item);
            } else if (item instanceof MetaDbPropertyBundleObjectClientBean) {
                child = new Bundle(this.context, item);
            } else if (item instanceof MetaDbPropertyGroupObjectClientBean) {
                child = new Group(this.context, item);
            } else {
                return;
            }
        }
        this.add(name, child);
    }

    @Override
    public void removeChild(String name) throws Exception {
        this.remove(name.toLowerCase());
    }

    protected void renameChild(Node node, String oldName, String newName) {
        oldName = oldName.toLowerCase();
        newName = newName.toLowerCase();
        Node otherNode = this.children.remove(oldName);
        if (otherNode != node) {
            this.children.put(oldName, otherNode);
        }
        this.children.put(newName, node);
    }

    protected Node findChild(String name) {
        Node child = this.children.get(name);
        if (child != null) {
            return child;
        }
        for (Group group : this.groups) {
            child = group.findChild(name);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    protected void gatherChildren(List<NodeBean> result, Node.Type type) {
        for (Node child : this.children.values()) {
            if (child instanceof Group) {
                ((Group)child).gatherChildren(result, type);
                continue;
            }
            if (!this.matchType(type, child)) continue;
            result.add(child.getBean());
        }
    }

    private void add(String name, Node child) {
        this.children.put(name, child);
        if (child instanceof Group) {
            this.groups.add((Group)child);
        }
        child.addedTo(this);
    }

    private void remove(String name) {
        Node child = this.children.remove(name);
        if (child instanceof Group) {
            this.groups.remove((Group)child);
        } else if (child != null) {
            child.removedFrom(this);
        }
    }

    private boolean matchType(Node.Type type, Node child) {
        if (type == null) {
            return true;
        }
        switch (type) {
            case BUNDLE: {
                return child instanceof Bundle;
            }
            case ENTRY: {
                return child instanceof Entry;
            }
        }
        return false;
    }
}

