/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.cache.tree;

import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.metadb.cache.Context;
import agorum.roi.metadb.cache.beans.NodeBean;
import agorum.roi.metadb.cache.tree.Bundle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class Node {
    protected final Context context;
    private final Long id;
    private String name;
    private final Set<Bundle> parents = new HashSet<Bundle>();

    protected Node(Context context, GlobalObjectClientBean obj) throws Exception {
        this.context = context;
        this.id = obj.getId();
        this.name = obj.getName();
        context.put(this.id, this);
    }

    protected Long getId() {
        return this.id;
    }

    protected String getName() {
        return this.name;
    }

    protected abstract NodeBean getBean();

    public abstract NodeBean get(StringTokenizer var1);

    public abstract List<NodeBean> list(StringTokenizer var1, Type var2);

    protected void delete() {
        this.context.remove(this.id);
    }

    public void update(GlobalObjectClientBean obj) throws Exception {
        String newName = obj.getName();
        if (!newName.equals(this.name)) {
            for (Bundle parent : this.parents) {
                parent.renameChild(this, this.name, newName);
            }
            this.name = newName;
        }
    }

    public abstract void addChild(GlobalObjectClientBean var1) throws Exception;

    public abstract void removeChild(String var1) throws Exception;

    protected void addedTo(Bundle parent) {
        this.parents.add(parent);
    }

    protected void removedFrom(Bundle parent) {
        this.parents.remove(parent);
    }

    public static enum Type {
        BUNDLE,
        ENTRY;

    }
}

