/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.string.SerializableMap;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.util.MetaDbUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class MetaDbAccessor {
    private SessionController sessionController;

    public static Set<String> asSet(String[] keyArray) {
        return new HashSet<String>(Arrays.asList(keyArray));
    }

    public MetaDbAccessor(String ident) {
        this.sessionController = SessionControllerAdmin.getSessionControllerAdmin(ident);
    }

    public SerializableMap getValues(String basePath, Set<String> keys) {
        SerializableMap map = new SerializableMap();
        try (MetaDbUtil mdbu = new MetaDbUtil(this.sessionController, basePath, true);){
            for (String key : keys) {
                map.put((Object)key, (Object)mdbu.getString(key, null));
            }
        }
        return map;
    }

    public SerializableMap getValues(String basePath) {
        try (MetaDbUtil mdbu = new MetaDbUtil(this.sessionController, basePath, true);){
            SerializableMap serializableMap = this.getValues(basePath, new HashSet<String>(mdbu.listEntries("")));
            return serializableMap;
        }
    }

    public boolean setValues(String basePath, SerializableMap values) {
        boolean success = true;
        try (MetaDbUtil mdbu = new MetaDbUtil(this.sessionController, basePath);){
            for (String key : values.keySet()) {
                mdbu.setString(key, values.getString(key));
            }
            mdbu.commit();
        }
        catch (Exception e) {
            success = false;
        }
        return success;
    }

    public MetaDbUtil getReadUtil(String basePath) {
        return new MetaDbUtil(this.sessionController, basePath, true);
    }

    public MetaDbUtil getWriteUtil(String basePath) {
        return new MetaDbUtil(this.sessionController, basePath, false);
    }

    public String[] listBundles(String basePath) {
        return MetaDbSuperCache.listSimplePropertyBundles(this.sessionController, basePath);
    }

    public String[] listEntries(String basePath) {
        return MetaDbSuperCache.listSimplePropertyEntries(this.sessionController, basePath);
    }

    public boolean bundleExists(String basePath) {
        MetaDb metaDbInstance = this.sessionController.getMetaDbInstance();
        String[] arr = metaDbInstance.listSimplePropertyBundle(basePath);
        if (arr == null) {
            arr = metaDbInstance.listSimplePropertyEntry(basePath);
        }
        return arr != null;
    }

    public String getEntry(String basePath, String key) {
        return MetaDbSuperCache.getSimplePropertyValue(this.sessionController, basePath + "/" + key);
    }

    public String getEntry(String basePath, String key, String _default) {
        String result = MetaDbSuperCache.getSimplePropertyValue(this.sessionController, basePath + "/" + key);
        if (result == null) {
            result = _default;
        }
        return result;
    }
}

