/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.test;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.metadb.beans.MetaDbPropertyBean;
import agorum.roi.metadb.beans.MetaDbPropertyBundleBean;
import agorum.roi.metadb.beans.MetaDbPropertyEntryBean;
import agorum.roi.metadb.common.MetaDbEntryUtils;
import agorum.roi.metadb.common.MetaDbUtils;

public class TestMetaDbPerformance {
    private SessionController sessionController = null;

    public TestMetaDbPerformance(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void test() throws Exception {
        long t1 = System.currentTimeMillis();
        MetaDbUtils mdbu = new MetaDbUtils(this.sessionController);
        this.printMetaDbStructur(mdbu);
        System.err.println("Time : " + (System.currentTimeMillis() - t1));
    }

    public void test2() throws Throwable {
        long t1 = System.currentTimeMillis();
        MetaDb mdb = this.sessionController.getMetaDbInstance();
        mdb.listSimplePropertyBundle("MAIN_ACL_MANAGEMENT");
        String[] stringArray = mdb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/dynawebservices/providers/HtmlB2BServices/beans/HtmlB2BAvailabilityEntryRequestBean/class");
        System.err.println("Time : " + (System.currentTimeMillis() - t1));
    }

    public void warmup() throws Exception {
        long t1 = System.currentTimeMillis();
        MetaDbUtils mdbu = new MetaDbUtils(this.sessionController);
        this.warmupMetaDbStructur(mdbu);
        System.err.println("Time : " + (System.currentTimeMillis() - t1));
    }

    private void warmupMetaDbStructur(MetaDbUtils mdbu) throws Exception {
        FolderObjectClientBean startFolder = mdbu.getMetaDbBasePath();
        String startPath = "/agorum/ngos/MetaDb";
        GlobalObjectClientBean[] items = startFolder.getItems();
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                String name;
                if (items[i] == null || !(items[i] instanceof MetaDbPropertyBundleObjectClientBean)) continue;
                String path = name = items[i].getName();
                this.warmupMetaDbStructurIntern(mdbu, path, mdbu.getItems(path, (FolderObjectClientBean)items[i]));
            }
        }
    }

    private void warmupMetaDbStructurIntern(MetaDbUtils mdbu, String path, MetaDbPropertyBean[] items) throws Exception {
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                if (items[i] instanceof MetaDbPropertyBundleBean) {
                    String myPath = path + "/" + items[i].getName();
                    FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(items[i].getId());
                    this.warmupMetaDbStructurIntern(mdbu, myPath, mdbu.getItems(myPath, folder));
                    continue;
                }
                if (!(items[i] instanceof MetaDbPropertyEntryBean)) continue;
            }
        }
    }

    private void printMetaDbStructur(MetaDbUtils mdbu) throws Exception {
        FolderObjectClientBean startFolder = mdbu.getMetaDbBasePath();
        String startPath = "/agorum/ngos/MetaDb";
        GlobalObjectClientBean[] items = startFolder.getItems();
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                String name;
                if (items[i] == null || !(items[i] instanceof MetaDbPropertyBundleObjectClientBean)) continue;
                String path = name = items[i].getName();
                System.err.println(name);
                this.printMetaDbStructurIntern(mdbu, "  ", path, mdbu.getItems(path, (FolderObjectClientBean)items[i]));
            }
        }
    }

    private void printMetaDbStructurIntern(MetaDbUtils mdbu, String offset, String path, MetaDbPropertyBean[] items) throws Exception {
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                if (items[i] instanceof MetaDbPropertyBundleBean) {
                    System.err.println(offset + items[i].getName());
                    String myPath = path + "/" + items[i].getName();
                    FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(items[i].getId());
                    this.printMetaDbStructurIntern(mdbu, offset + "  ", myPath, mdbu.getItems(myPath, folder));
                    continue;
                }
                if (!(items[i] instanceof MetaDbPropertyEntryBean)) continue;
                MetaDbPropertyEntryBean bean = (MetaDbPropertyEntryBean)items[i];
                long dataType = bean.getEntryDataType();
                String[] sa = mdbu.replaceStringValue(bean, dataType);
                String s = "";
                if (sa != null) {
                    int lenA = sa.length;
                    String token = "";
                    for (int k = 0; k < lenA; ++k) {
                        s = s + sa[k] + token;
                        token = "||";
                    }
                }
                MetaDbEntryUtils metaDbEntryUtils = new MetaDbEntryUtils(this.sessionController);
                String sv = metaDbEntryUtils.getValueToString(bean.getEntryDataType(), bean.getValueObject(bean.getEntryDataType()));
                System.err.println(offset + items[i].getName() + "=" + sv + " (" + s + ")");
            }
        }
    }

    public static void main(String[] args) {
        System.err.println("Hallo");
        try {
            RoiProperties rp = new RoiProperties();
            CredentialObject credential = new CredentialObject();
            credential.setUserName(rp.getRoiSystemUser());
            credential.setPassWord(rp.getRoiSystemPassword());
            credential.setModulInfo("TestMetaDbUtils");
            SessionController sessionController = SessionController.connect(credential);
            TestMetaDbPerformance testMetaDbPerformance = new TestMetaDbPerformance(sessionController);
            testMetaDbPerformance.test2();
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Ende Programm");
    }
}

