/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.metadb.util.cache;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.agceptit.metadb.client.common.MetaDbException;
import agorum.commons.logging.Log;
import agorum.commons.utils.CaseInsensitiveHashMap;
import agorum.commons.utils.LockHandle;
import agorum.commons.utils.LockMaster;
import agorum.roi.ejb.client.beans.MetaDbPropertyBundleObjectClientBean;
import agorum.roi.ejb.common.CryptKeyController;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.metadb.common.MetaDbUtils;
import agorum.roi.metadb.util.cache.Bundle;
import agorum.roi.metadb.util.cache.Entry;
import agorum.roi.metadb.util.cache.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MetaDbCache {
    private final SessionController sessionController;
    private final String prefix;
    private final boolean readOnly;
    private final String key;
    private final MetaDb metaDb;
    private final MetaDbUtils metaDbUtils;
    private final Bundle root;
    private final Map<String, Node> cache = new CaseInsensitiveHashMap();
    private final PathLock lock;
    private boolean hasChanges;
    private static ThreadLocal<Map<String, MetaDbCache>> threadCaches = new ThreadLocal<Map<String, MetaDbCache>>(){

        @Override
        protected Map<String, MetaDbCache> initialValue() {
            return new HashMap<String, MetaDbCache>();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MetaDbCache(SessionController sessionController, String prefix, boolean readOnly, String key) {
        this.sessionController = sessionController;
        this.prefix = prefix;
        this.readOnly = readOnly;
        this.key = key;
        try {
            this.metaDb = sessionController.getMetaDbInstance();
        }
        catch (Exception e) {
            throw new MetaDbException("Could not initialize MetaDb", (Throwable)e);
        }
        this.metaDbUtils = new MetaDbUtils(sessionController);
        this.lock = new PathLock(prefix, readOnly);
        boolean initialized = false;
        try (Transaction t = new Transaction();){
            this.createBundle(this.normalize(""));
            this.root = this.initializeCache(this.normalize(""));
            t.commit();
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.lock.close();
            }
        }
    }

    public static MetaDbCache getInstance(SessionController sessionController, String prefix, boolean readOnly) {
        prefix = MetaDbCache.cleanup(prefix);
        RoiTransactionHandler rth = RoiTransactionHandler.getThreadTransaction();
        if (rth != null) {
            MetaDbCache cache;
            String key = prefix.toLowerCase();
            Map<String, MetaDbCache> caches = threadCaches.get();
            if (!readOnly) {
                MetaDbCache.checkIncompatible(caches, key);
            }
            if ((cache = caches.get(key)) == null) {
                MetaDbCache newCache = cache = new MetaDbCache(sessionController, prefix, readOnly, key);
                caches.put(key, newCache);
                RoiTransactionHandler.Handler removeHandler = () -> newCache.remove();
                rth.afterCommit("MetaDbCache_" + key, removeHandler);
                rth.afterRollback("MetaDbCache_" + key, removeHandler);
            }
            return cache;
        }
        return new MetaDbCache(sessionController, prefix, readOnly, null);
    }

    private static void checkIncompatible(Map<String, MetaDbCache> caches, String key) {
        HashSet<MetaDbCache> toRemove = new HashSet<MetaDbCache>();
        for (Map.Entry<String, MetaDbCache> entry : caches.entrySet()) {
            String otherKey = entry.getKey();
            if (key.equals(otherKey)) {
                MetaDbCache other = entry.getValue();
                if (!other.readOnly) continue;
                Log.info((String)("Cannot upgrade from read-only to read-write in the same transaction - use a read-write MetaDbUtil: " + key), (Throwable)new Throwable());
                toRemove.add(other);
                continue;
            }
            if (!otherKey.startsWith(key) && !key.startsWith(otherKey)) continue;
            Log.info((String)("Incompatible MetaDb paths used in same transaction - the shorter one should be chosen and used in both cases: " + otherKey + ", " + key), (Throwable)new Throwable());
            toRemove.add(entry.getValue());
        }
        for (MetaDbCache incompatible : toRemove) {
            incompatible.remove();
        }
    }

    private void createBundle(String path) {
        String[] names = path.split("\\/");
        Object[] classNames = new String[names.length];
        Arrays.fill(classNames, MetaDbPropertyBundleObjectClientBean.CLASS_NAME);
        try {
            this.metaDbUtils.createMetaDbPath(names, (String[])classNames);
        }
        catch (Exception e) {
            throw new MetaDbException("Could not create MetaDb path " + path, (Throwable)e);
        }
    }

    private Bundle initializeCache(String path) {
        Bundle bundle = (Bundle)this.cache.get(path);
        if (bundle != null) {
            return bundle;
        }
        return new Bundle(path, null, this.sessionController, this.metaDb, this.metaDbUtils, this.cache, true);
    }

    private void change() {
        this.hasChanges = true;
    }

    private void remove() {
        if (threadCaches.get().remove(this.key) != null) {
            this.lock.close();
        }
    }

    public void close() {
        if (this.key == null) {
            this.lock.close();
        } else if (this.hasChanges) {
            this.remove();
        }
    }

    public void commit() {
        this.root.commit();
        this.hasChanges = false;
    }

    private Bundle getBundle(String path) {
        Node node = this.cache.get(path = this.normalize(path));
        if (node instanceof Bundle) {
            return (Bundle)node;
        }
        if (node == null || node.isDeleted()) {
            return this.root.createBundle(path);
        }
        throw new IllegalArgumentException("A non-bundle node already exists at this path: " + path);
    }

    public boolean isEntry(String path) {
        return this.getNode(path) instanceof Entry;
    }

    public boolean isBundle(String path) {
        return this.getNode(path) instanceof Bundle;
    }

    private Node getNode(String path) {
        path = this.normalize(path);
        return this.cache.get(path);
    }

    private Entry getEntry(String path) {
        Node node = this.cache.get(path = this.normalize(path));
        if (node instanceof Entry) {
            return (Entry)node;
        }
        if (node == null || node.isDeleted()) {
            return this.root.createEntry(path);
        }
        throw new IllegalArgumentException("A non-entry node already exists at this path: " + path);
    }

    public List<String> list(String path, boolean bundles) {
        return this.getBundle(path).list(bundles);
    }

    public void delete(String path) {
        Node node = this.getNode(path);
        if (node != null) {
            node.delete();
        }
    }

    public String get(String path) {
        String[] result = this.getArray(path);
        if (result == null || result.length <= 0) {
            return null;
        }
        return result[0];
    }

    public String[] getArray(String path) {
        Node node = this.getNode(path);
        if (node == null) {
            return null;
        }
        return node.get();
    }

    public void set(String path, String value) {
        this.change();
        if (value == null) {
            this.set(path, new String[0]);
        } else {
            this.set(path, new String[]{value});
        }
    }

    public void set(String path, String[] value) {
        this.change();
        this.getEntry(path).set(value);
    }

    public void encrypt(String path) {
        this.change();
        this.getEntry(path).setEncrypted(true);
    }

    public String decryptString(String str) {
        return new CryptKeyController().tryDecrypt(str, "metadb", this.sessionController);
    }

    private String normalize(String path) {
        return MetaDbCache.cleanup(this.prefix + "/" + path);
    }

    private static String cleanup(String path) {
        path = path.replace("//", "/");
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    private static class PathLock
    implements AutoCloseable {
        private static LockMaster<String> locks = new LockMaster();
        private final List<LockHandle> locked = new ArrayList<LockHandle>();
        private final List<String> readPaths;
        private final String writePath;

        public PathLock(String path, boolean readOnly) {
            String[] segments = path.split("\\/");
            this.readPaths = new ArrayList<String>(segments.length + 1);
            this.readPaths.add("/");
            StringBuilder pathBuilder = new StringBuilder();
            for (String segment : segments) {
                if (segment == null || (segment = segment.trim()).length() <= 0) continue;
                pathBuilder.append("/");
                pathBuilder.append(segment);
                this.readPaths.add(pathBuilder.toString());
            }
            this.writePath = readOnly ? null : this.readPaths.remove(this.readPaths.size() - 1);
            try {
                for (String readPath : this.readPaths) {
                    this.locked.add(locks.lock((Object)readPath, false));
                }
                if (this.writePath != null) {
                    this.locked.add(locks.lock((Object)this.writePath, true));
                }
            }
            catch (InterruptedException e) {
                this.close();
                throw new RuntimeException(e);
            }
        }

        @Override
        public void close() {
            ListIterator<LockHandle> iter = this.locked.listIterator(this.locked.size());
            while (iter.hasPrevious()) {
                iter.previous().close();
            }
        }
    }
}

