/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.ical;

import agorum.commons.string.StringUtils;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.GregorianCalendar;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.NumberList;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.Recur;
import net.fortuna.ical4j.model.WeekDay;
import net.fortuna.ical4j.model.WeekDayList;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.RRule;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.util.CompatibilityHints;

public class ICalParser {
    public static final String DAILY = "DAILY";
    public static final String WEEKLY = "WEEKLY";
    public static final String MONTHLY = "MONTHLY";
    public static final String YEARLY = "YEARLY";
    private Calendar iCalendar = null;
    private InputStream inputStream = null;
    private String charSetName = "UTF-8";

    public ICalParser(InputStream contentStream, String charSetName) {
        this.inputStream = contentStream;
        if (charSetName != null && charSetName.length() > 0) {
            this.charSetName = charSetName;
        }
        this.parseICal();
    }

    private void parseICal() {
        CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.unfolding.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.outlook", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.validation.relaxed", (boolean)true);
        CompatibilityHints.setHintEnabled((String)"ical4j.compatibility.notes", (boolean)true);
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        try {
            StringUtils stringUtils = new StringUtils();
            String parseString = stringUtils.streamToString(this.inputStream, this.charSetName);
            this.iCalendar = calendarBuilder.build((Reader)new StringReader(parseString.trim()));
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
    }

    public Calendar getCalendar() {
        return this.iCalendar;
    }

    public VEvent getVEvent() {
        return this.iCalendar != null ? (VEvent)this.iCalendar.getComponent("VEVENT") : null;
    }

    public java.util.Date getStartDate() {
        DtStart dtStart = null;
        VEvent vEvent = this.getVEvent();
        if (vEvent != null) {
            dtStart = vEvent.getStartDate();
        }
        return dtStart != null ? dtStart.getDate() : null;
    }

    public java.util.Date getEndDate() {
        DtEnd dtEnd = null;
        VEvent vEvent = this.getVEvent();
        if (vEvent != null) {
            dtEnd = vEvent.getEndDate();
        }
        return dtEnd != null ? dtEnd.getDate() : null;
    }

    public String getDescription() {
        Description description = null;
        VEvent vEvent = this.getVEvent();
        if (vEvent != null) {
            description = vEvent.getDescription();
        }
        return description != null ? description.getValue() : null;
    }

    public String getXAltDesc() {
        Property xAltDescProperty;
        VEvent vEvent = this.getVEvent();
        String xAltDesc = null;
        if (vEvent != null && (xAltDescProperty = vEvent.getProperty("X-ALT-DESC")) != null) {
            xAltDesc = xAltDescProperty.getValue();
        }
        return xAltDesc;
    }

    public String getSummary() {
        Summary summary = null;
        VEvent vEvent = this.getVEvent();
        if (vEvent != null) {
            summary = vEvent.getSummary();
        }
        return summary != null ? summary.getValue() : null;
    }

    public VAlarm getVAlarm() {
        ComponentList componentList;
        VAlarm alarm = null;
        VEvent vEvent = this.getVEvent();
        if (vEvent != null && (componentList = vEvent.getAlarms()).size() > 0) {
            alarm = (VAlarm)componentList.get(0);
        }
        return alarm;
    }

    public String getReminderValue() {
        Trigger trigger;
        VAlarm vAlarm = this.getVAlarm();
        if (vAlarm != null && (trigger = vAlarm.getTrigger()) != null) {
            Dur dur = trigger.getDuration();
            return dur != null ? new Integer(dur.getDays() * 24 * 3600 + dur.getHours() * 3600 + dur.getMinutes() * 60).toString() : null;
        }
        return "0";
    }

    public RRule getRRule() {
        RRule rRule = null;
        VEvent vEvent = this.getVEvent();
        if (vEvent != null) {
            rRule = (RRule)vEvent.getProperty("RRULE");
        }
        return rRule;
    }

    public RRule getFirstRRule() {
        RRule rRule = null;
        rRule = (RRule)this.iCalendar.getProperty("RRULE");
        return rRule;
    }

    public String getRecurFrequency() {
        Recur recur;
        RRule rRule = this.getRRule();
        if (rRule != null && (recur = rRule.getRecur()) != null) {
            return recur.getFrequency();
        }
        return null;
    }

    public int getRecurInterval() {
        Recur recur;
        RRule rRule = this.getRRule();
        if (rRule != null && (recur = rRule.getRecur()) != null) {
            return recur.getInterval();
        }
        return -1;
    }

    public String getRecurWeekDay() {
        WeekDayList weekDayList;
        Recur recur;
        RRule rRule = this.getRRule();
        if (rRule != null && (recur = rRule.getRecur()) != null && (weekDayList = recur.getDayList()) != null && weekDayList.size() > 0) {
            return ((WeekDay)weekDayList.get(0)).getDay();
        }
        return null;
    }

    public int getRecurWeekDayOffset() {
        Recur recur;
        RRule rRule = this.getRRule();
        if (rRule != null && (recur = rRule.getRecur()) != null) {
            NumberList setPosList = recur.getSetPosList();
            if (setPosList != null && setPosList.size() > 0) {
                return new Integer(setPosList.get(0).toString());
            }
            WeekDayList weekDayList = recur.getDayList();
            if (weekDayList != null && weekDayList.size() > 0) {
                return ((WeekDay)weekDayList.get(0)).getOffset();
            }
        }
        return -1;
    }

    public java.util.Date getRecurEndDate() {
        RRule rRule = this.getRRule();
        if (rRule != null) {
            Recur recur = rRule.getRecur();
            int count = recur.getCount();
            if (count > 0) {
                String frequency = this.getRecurFrequency();
                Date lastDate = null;
                if (frequency != null) {
                    int interval = recur.getInterval() > 0 ? recur.getInterval() : 1;
                    java.util.Date startDate = this.getStartDate();
                    GregorianCalendar newCal = new GregorianCalendar();
                    newCal.setTime(startDate);
                    if (frequency.equalsIgnoreCase(DAILY)) {
                        newCal.set(5, newCal.get(5) + interval * (count - 2));
                    } else if (frequency.equalsIgnoreCase(WEEKLY)) {
                        newCal.set(3, newCal.get(3) + interval * (count - 2));
                    } else if (frequency.equalsIgnoreCase(MONTHLY)) {
                        newCal.set(2, newCal.get(2) + interval * (count - 2));
                    } else if (frequency.equalsIgnoreCase(YEARLY)) {
                        newCal.set(1, newCal.get(1) + interval * (count - 2));
                    }
                    lastDate = recur.getNextDate(new Date(startDate), new Date(newCal.getTime()));
                    return lastDate;
                }
            }
            if (recur != null) {
                return recur.getUntil();
            }
        }
        return null;
    }

    public String getClassification() {
        Clazz clazz;
        VEvent vEvent = this.getVEvent();
        String value = null;
        if (vEvent != null && (clazz = vEvent.getClassification()) != null) {
            value = clazz.getValue();
        }
        return value;
    }

    public boolean hasRRule() {
        return this.getRRule() != null;
    }

    public String toString() {
        if (this.iCalendar != null) {
            return this.iCalendar.toString();
        }
        return super.toString();
    }
}

