/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.mail.rtf;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;

public class CharsetHelper {
    private static final String[] CHARSET_PREFIXES = new String[]{"", "cp", "iso-", "ibm", "x-windows-", "ms"};
    public static final Charset WINDOWS_CHARSET = Charset.forName("CP1252");

    public static Charset findCharset(String rtfCodePage) {
        return rtfCodePage.equals("65001") || rtfCodePage.equalsIgnoreCase("cp65001") ? StandardCharsets.UTF_8 : CharsetHelper.detectCharset(rtfCodePage);
    }

    private static Charset detectCharset(String rtfCodePage) {
        for (String prefix : CHARSET_PREFIXES) {
            try {
                return Charset.forName(prefix + rtfCodePage);
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {
            }
        }
        throw new UnsupportedCharsetException(rtfCodePage);
    }

    public static Charset rtfCharset(int rtfCharsetNumber) {
        switch (rtfCharsetNumber) {
            case 0: {
                return Charset.forName("Windows-1252");
            }
            case 1: 
            case 2: 
            case 77: {
                return null;
            }
            case 128: {
                return Charset.forName("Windows-932");
            }
            case 129: {
                return Charset.forName("Windows-949");
            }
            case 130: {
                return Charset.forName("ms1361");
            }
            case 134: {
                return Charset.forName("Windows-936");
            }
            case 136: {
                return Charset.forName("Windows-950");
            }
            case 161: {
                return Charset.forName("Windows-1253");
            }
            case 162: {
                return Charset.forName("cp857");
            }
            case 163: {
                return Charset.forName("Windows-1254");
            }
            case 177: 
            case 181: {
                return Charset.forName("Windows-1255");
            }
            case 178: 
            case 179: 
            case 180: 
            case 186: {
                return Charset.forName("Windows-1256");
            }
            case 204: 
            case 222: {
                return Charset.forName("Windows-1251");
            }
            case 238: {
                return Charset.forName("Windows-1257");
            }
            case 254: {
                return Charset.forName("CP437");
            }
            case 255: {
                return Charset.defaultCharset();
            }
        }
        return null;
    }
}

