/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.parser.mail.rtf;

import agorum.roi.parser.mail.rtf.CharsetHelper;
import com.sun.istack.internal.NotNull;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Rtf2Html {
    private static final Pattern CONTROL_WORD = Pattern.compile("\\\\(([^a-zA-Z])|(([a-zA-Z]+)(-?[\\d]*) ?))");
    private static final Pattern ENCODED_CHARACTER = Pattern.compile("\\\\'([0-9a-fA-F]{2})");

    private Rtf2Html() {
    }

    @NotNull
    private static String hexToString(@NotNull String hex, @NotNull Charset charset) {
        return new String(Rtf2Html.hexStringToByteArray(hex), charset);
    }

    @NotNull
    private static byte[] hexStringToByteArray(@NotNull String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    @NotNull
    public static String rtf2html(@NotNull String rtf) {
        HashMap<Integer, FontTableEntry> fontTable = new HashMap<Integer, FontTableEntry>();
        Charset charset = CharsetHelper.WINDOWS_CHARSET;
        LinkedList<Group> groupStack = new LinkedList<Group>();
        groupStack.add(new Group());
        Matcher controlWordMatcher = CONTROL_WORD.matcher(rtf);
        Matcher encodedCharMatcher = ENCODED_CHARACTER.matcher(rtf);
        StringBuilder result = new StringBuilder();
        int length = rtf.length();
        int charIndex = 0;
        block27: while (charIndex < length) {
            char c = rtf.charAt(charIndex);
            Group currentGroup = (Group)groupStack.getFirst();
            if (c == '\r' || c == '\n') {
                ++charIndex;
                continue;
            }
            if (c == '{') {
                groupStack.addFirst(currentGroup.copy());
                ++charIndex;
                continue;
            }
            if (c == '}') {
                groupStack.removeFirst();
                if (groupStack.size() == 1) break;
                ++charIndex;
                continue;
            }
            if (c == '\\') {
                encodedCharMatcher.region(charIndex, length);
                if (encodedCharMatcher.lookingAt()) {
                    FontTableEntry entry;
                    StringBuilder encodedSequence = new StringBuilder();
                    while (encodedCharMatcher.lookingAt()) {
                        encodedSequence.append(encodedCharMatcher.group(1));
                        encodedCharMatcher.region(charIndex += 4, length);
                    }
                    Charset effectiveCharset = charset;
                    if (currentGroup.fontTableIndex != null && (entry = (FontTableEntry)fontTable.get(currentGroup.fontTableIndex)) != null && entry.charset != null) {
                        effectiveCharset = entry.charset;
                    }
                    String decoded = Rtf2Html.hexToString(encodedSequence.toString(), effectiveCharset);
                    Rtf2Html.append(result, decoded, currentGroup);
                    continue;
                }
                controlWordMatcher.region(charIndex, length);
                if (!controlWordMatcher.lookingAt()) {
                    throw new IllegalStateException("RTF file has invalid structure. Failed to match character '" + c + "' at [" + charIndex + "/" + length + "] to a control symbol or word.");
                }
                Integer controlNumber = null;
                String controlWord = controlWordMatcher.group(2);
                if (controlWord == null) {
                    controlWord = controlWordMatcher.group(4);
                    String controlNumberString = controlWordMatcher.group(5);
                    if (!"".equals(controlNumberString)) {
                        controlNumber = Integer.valueOf(controlNumberString);
                    }
                }
                charIndex += controlWordMatcher.end() - controlWordMatcher.start();
                switch (controlWord) {
                    case "par": {
                        Rtf2Html.append(result, "\n", currentGroup);
                        break;
                    }
                    case "tab": {
                        Rtf2Html.append(result, "\t", currentGroup);
                        break;
                    }
                    case "htmlrtf": {
                        currentGroup.htmlRtf = controlNumber == null;
                        break;
                    }
                    case "ansicpg": {
                        charset = CharsetHelper.findCharset(Objects.requireNonNull(controlNumber).toString());
                        break;
                    }
                    case "fonttbl": 
                    case "colortbl": {
                        currentGroup.ignore = true;
                        break;
                    }
                    case "f": {
                        currentGroup.fontTableIndex = controlNumber;
                        break;
                    }
                    case "fcharset": {
                        if (controlNumber == null || currentGroup.fontTableIndex == null) break;
                        Charset possibleCharset = CharsetHelper.rtfCharset(controlNumber);
                        if (possibleCharset == null) continue block27;
                        FontTableEntry entry = (FontTableEntry)fontTable.get(currentGroup.fontTableIndex);
                        if (entry == null) {
                            entry = new FontTableEntry();
                            fontTable.put(currentGroup.fontTableIndex, entry);
                        }
                        entry.charset = possibleCharset;
                        break;
                    }
                    case "uc": {
                        currentGroup.unicodeCharLength = controlNumber == null ? 1 : controlNumber;
                        break;
                    }
                    case "u": {
                        if (controlNumber == null) break;
                        char unicodeSymbol = (char)controlNumber.intValue();
                        Rtf2Html.append(result, Character.toString(unicodeSymbol), currentGroup);
                        charIndex += currentGroup.unicodeCharLength;
                        break;
                    }
                    case "{": 
                    case "}": 
                    case "\\": {
                        Rtf2Html.append(result, controlWord, currentGroup);
                        break;
                    }
                }
                continue;
            }
            Rtf2Html.append(result, c + "", currentGroup);
            ++charIndex;
        }
        return result.toString();
    }

    private static void append(StringBuilder result, String symbol, Group group) {
        if (!group.ignore && !group.htmlRtf) {
            result.append(symbol);
        }
    }

    private static class FontTableEntry {
        Charset charset = null;

        private FontTableEntry() {
        }
    }

    private static class Group {
        boolean ignore = false;
        int unicodeCharLength = 1;
        boolean htmlRtf = false;
        Integer fontTableIndex = null;

        private Group() {
        }

        Group copy() {
            Group newGroup = new Group();
            newGroup.ignore = this.ignore;
            newGroup.unicodeCharLength = this.unicodeCharLength;
            newGroup.htmlRtf = this.htmlRtf;
            return newGroup;
        }
    }
}

