/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting;

import agorum.commons.logging.Log;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.scripting.NestedEngineContext;

public class DefaultEngineContext
extends NestedEngineContext
implements AutoCloseable {
    private static final String MY_LIBRARY_PATH = "/agorum/roi/Scripting/Libraries/default";
    private static SessionController sessionControllerAdmin;
    private static Object syncObject;
    private static long nextCheck;
    private static final long CHECK_INTERVAL = 30000L;

    private static void connectAdmin() throws Exception {
        RoiProperties rp = new RoiProperties();
        CredentialObject credential = new CredentialObject();
        credential.setUserName(rp.getRoiSystemUser());
        credential.setModulInfo("DefaultEngineContext");
        credential.setAuthInterface(new ServiceAuthInterface());
        sessionControllerAdmin = SessionController.connect(credential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SessionController getSessionController() throws Exception {
        if (nextCheck <= System.currentTimeMillis()) {
            Object object = syncObject;
            synchronized (object) {
                if (sessionControllerAdmin == null) {
                    DefaultEngineContext.connectAdmin();
                } else {
                    try {
                        sessionControllerAdmin.reconnectIfNeeded();
                    }
                    catch (Exception e) {
                        DefaultEngineContext.connectAdmin();
                    }
                }
                nextCheck = System.currentTimeMillis() + 30000L;
            }
        }
        return sessionControllerAdmin;
    }

    public DefaultEngineContext() throws Exception {
        this(true);
    }

    public DefaultEngineContext(boolean sandboxed) throws Exception {
        super(sandboxed, DefaultEngineContext.getSessionController());
    }

    protected DefaultEngineContext(NestedEngineContext superContext) {
        super(superContext);
    }

    @Override
    protected void initializeEngine() {
        super.initializeEngine();
        try {
            FolderObjectClientBean folder = (FolderObjectClientBean)sessionControllerAdmin.findGlobalObjectByPath(MY_LIBRARY_PATH);
            for (GlobalObjectClientBean item : folder.items()) {
                if (!(item instanceof ContentInterface)) continue;
                this.exec((ContentInterface)((Object)item));
            }
        }
        catch (Exception e) {
            Log.error((String)"Could not execute default library", (Throwable)e);
        }
    }

    @Override
    public void close() {
    }

    static {
        syncObject = new Object();
        nextCheck = -1L;
    }
}

