/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting;

import agorum.commons.cron.SystemTimer;
import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.scripting.Cache;
import agorum.roi.scripting.Engine;
import agorum.roi.scripting.sandbox.SandboxContext;
import agorum.roi.statistic.EngineFactoryStatistic;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public final class EngineFactory {
    static final Statistic stat = EngineFactoryStatistic.getInstance();
    private static final Cache<Library> libraryCache = new Cache();
    static final String LIBRARY_PATH = "/agorum/roi/Scripting/Libraries/";
    private static final String AUTO_LIBRARY_PATH = "/agorum/roi/Scripting/Libraries/auto";

    private EngineFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Engine getEngine(boolean sandboxed, Map<String, ?> builtins) {
        Context context = Context.enter();
        try {
            ScriptableObject scope = context.initStandardObjects();
            Engine engine = new Engine(scope, sandboxed);
            Scriptable __ac_builtin = context.newObject(scope);
            if (builtins != null) {
                for (Map.Entry<String, ?> entry : builtins.entrySet()) {
                    ScriptableObject.putProperty(__ac_builtin, entry.getKey(), entry.getValue());
                }
            }
            engine.put("__ac_builtin", __ac_builtin);
            for (Library library : libraryCache) {
                if (library.script == null) continue;
                try {
                    engine.exec(library.script, null, true);
                }
                catch (Exception e) {
                    stat.error().objectId(library.id).exception((Throwable)e).send("Could not execute library script");
                }
            }
            Engine engine2 = engine;
            return engine2;
        }
        finally {
            Context.exit();
        }
    }

    private static void updateLibraryCache() {
        libraryCache.preparePurge();
        Context context = Context.enter();
        try {
            SessionController sc = SessionControllerAdmin.getService(EngineFactory.class);
            FolderObjectClientBean libraryFolder = new RoiFileSystem(sc).createFullpath(AUTO_LIBRARY_PATH);
            EngineFactory.updateLibraryCache(context, libraryFolder);
        }
        catch (Exception e) {
            stat.error((Throwable)e, "Could not update library cache");
        }
        finally {
            Context.exit();
            libraryCache.purge();
        }
    }

    private static void updateLibraryCache(Context context, FolderObjectClientBean libraryFolder) throws Exception {
        GlobalObjectClientBean[] folders;
        GlobalObjectClientBean[] libraries = libraryFolder.getItemsNoFolder();
        if (libraries != null) {
            for (GlobalObjectClientBean libraryObject : libraries) {
                ContentInterface ci;
                Library library;
                if (!(libraryObject instanceof ContentInterface) || (library = libraryCache.get(ci = (ContentInterface)((Object)libraryObject))) != null) continue;
                try {
                    libraryCache.put(ci, () -> new Library(ci.getId(), context.compileReader(new InputStreamReader(ci.getContentStream(), StandardCharsets.UTF_8), ci.getName(), 1, null)));
                }
                catch (Exception e) {
                    stat.error().objectId(ci.getId()).exception((Throwable)e).send("Could not compile library script");
                }
            }
        }
        if ((folders = libraryFolder.getItemsOnlyFolder()) != null) {
            for (GlobalObjectClientBean folder : folders) {
                EngineFactory.updateLibraryCache(context, (FolderObjectClientBean)folder);
            }
        }
    }

    static {
        ContextFactory.initGlobal(new ContextFactory(){

            @Override
            protected Context makeContext() {
                return new SandboxContext(this);
            }

            @Override
            protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                if (cx instanceof SandboxContext) {
                    ((SandboxContext)cx).start();
                }
                return super.doTopCall(callable, cx, scope, thisObj, args);
            }

            @Override
            protected void observeInstructionCount(Context cx, int instructionCount) {
                if (cx instanceof SandboxContext) {
                    ((SandboxContext)cx).progress(instructionCount);
                }
            }

            @Override
            protected boolean hasFeature(Context cx, int featureIndex) {
                if (featureIndex == 10) {
                    return true;
                }
                return super.hasFeature(cx, featureIndex);
            }
        });
        SystemTimer.ofPeriod((long)60000L).call(EngineFactory::updateLibraryCache);
        EngineFactory.updateLibraryCache();
    }

    private static class Library {
        public Long id;
        public Script script;

        public Library(Long id, Script script) {
            this.id = id;
            this.script = script;
        }
    }

    public static final class EngineSession
    implements AutoCloseable {
        public EngineSession() {
            Context.enter();
        }

        @Override
        public void close() {
            Context.exit();
        }
    }
}

