/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting;

import agorum.roi.scripting.EngineFactory;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptStackElement;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;

public class ScriptError {
    private final String message;
    private final String details;
    private String firstMessage;
    private Throwable lastThrowable;

    public ScriptError(Throwable throwable) {
        this.firstMessage = throwable.getMessage();
        StringBuilder st = new StringBuilder();
        try (EngineFactory.EngineSession session = new EngineFactory.EngineSession();){
            this.stringify(st, throwable);
        }
        if (this.lastThrowable != null) {
            StringWriter sw = new StringWriter();
            this.lastThrowable.printStackTrace(new PrintWriter(sw));
            this.newLine(st);
            st.append("Origin: ");
            st.append(sw.toString());
        }
        this.message = this.firstMessage;
        this.details = st.toString();
    }

    public ScriptError(Scriptable error) {
        StringBuilder st = new StringBuilder();
        try (EngineFactory.EngineSession session = new EngineFactory.EngineSession();){
            this.stringify(st, error);
        }
        if (this.lastThrowable != null) {
            StringWriter sw = new StringWriter();
            this.lastThrowable.printStackTrace(new PrintWriter(sw));
            this.newLine(st);
            st.append("Origin: ");
            st.append(sw.toString());
        }
        this.message = this.firstMessage;
        this.details = st.toString();
    }

    public String getMessage() {
        return this.message;
    }

    public String getDetails() {
        return this.details;
    }

    private void stringify(StringBuilder st, Throwable throwable) {
        Throwable cause;
        this.lastThrowable = throwable;
        if (throwable instanceof JavaScriptException) {
            Serializable[] value = ((JavaScriptException)throwable).getValue();
            if (value instanceof NativeJavaObject && (value = ((NativeJavaObject)value).unwrap()) instanceof Throwable) {
                this.stringify(st, (Throwable)value);
                return;
            }
            if (value instanceof Scriptable) {
                this.stringify(st, (Scriptable)value);
                return;
            }
        }
        this.addMessage(st, throwable.getMessage());
        if (throwable instanceof RhinoException) {
            for (Serializable serializable : ((RhinoException)throwable).getScriptStack()) {
                this.newLine(st);
                ((ScriptStackElement)serializable).renderJavaStyle(st);
            }
        } else {
            this.lastThrowable = null;
            for (Serializable serializable : throwable.getStackTrace()) {
                this.newLine(st);
                st.append("\tat ");
                st.append(((StackTraceElement)serializable).toString());
            }
        }
        if ((cause = throwable.getCause()) != null && cause != throwable) {
            this.newLine(st);
            st.append("Caused by: ");
            this.stringify(st, cause);
        }
    }

    private void stringify(StringBuilder st, Scriptable error) {
        Object message = ScriptableObject.getProperty(error, "message");
        Object stack = ScriptableObject.getProperty(error, "stack");
        Object javaException = ScriptableObject.getProperty(error, "javaException");
        Object cause = ScriptableObject.getProperty(error, "cause");
        if (message == UniqueTag.NOT_FOUND && stack == UniqueTag.NOT_FOUND && javaException == UniqueTag.NOT_FOUND && cause == UniqueTag.NOT_FOUND) {
            this.addMessage(st, error);
            return;
        }
        this.addMessage(st, message);
        if (stack instanceof String) {
            this.newLine(st);
            st.append(stack);
        }
        if (javaException instanceof NativeJavaObject) {
            if ((javaException = ((NativeJavaObject)javaException).unwrap()) instanceof Throwable) {
                this.newLine(st);
                st.append("Caused by: ");
                this.stringify(st, (Throwable)javaException);
            }
        } else if (cause instanceof Scriptable) {
            this.newLine(st);
            st.append("Caused by: ");
            this.stringify(st, (Scriptable)cause);
        } else if (cause != null && cause != UniqueTag.NOT_FOUND) {
            this.newLine(st);
            st.append("Caused by: ");
            this.addMessage(st, cause);
        }
    }

    private void addMessage(StringBuilder st, Object message) {
        if (message == null || message == UniqueTag.NULL_VALUE) {
            st.append("null");
        } else if (message == UniqueTag.NOT_FOUND) {
            st.append("undefined");
        } else {
            st.append(message);
            if (this.firstMessage == null || this.firstMessage.isEmpty()) {
                this.firstMessage = message.toString();
            }
        }
    }

    private void newLine(StringBuilder st) {
        int len = st.length();
        if (len > 0 && st.charAt(len - 1) != '\n') {
            st.append("\n");
        }
    }
}

