/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting.link;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.ServiceAuthInterface;
import agorum.roi.ejb.common.SessionController;
import java.util.Locale;

public final class Configuration {
    private static SessionController sessionControllerAdmin = null;
    private static Object syncObject = new Object();
    private static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/roi/control/scripting/";

    private Configuration() {
    }

    private static void connectAdmin() throws Exception {
        RoiProperties rp = new RoiProperties();
        CredentialObject credential = new CredentialObject();
        credential.setUserName(rp.getRoiSystemUser());
        credential.setModulInfo("Configuration");
        credential.setAuthInterface(new ServiceAuthInterface());
        sessionControllerAdmin = SessionController.connect(credential);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void isConnected() throws Exception {
        Object object = syncObject;
        synchronized (object) {
            if (sessionControllerAdmin == null) {
                Configuration.connectAdmin();
            } else {
                try {
                    sessionControllerAdmin.reconnectIfNeeded();
                }
                catch (Exception e) {
                    Configuration.connectAdmin();
                }
            }
        }
    }

    public static Locale getDefaultLocale() {
        try {
            Configuration.isConnected();
            MetaDb metaDb = sessionControllerAdmin.getMetaDbInstance();
            return Locale.forLanguageTag(metaDb.getSimplePropertyValue("MAIN_MODULE_MANAGEMENT/roi/control/scripting/DefaultLocale")[0]);
        }
        catch (Exception e) {
            return Locale.GERMANY;
        }
    }
}

