/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.scripting.sandbox;

import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.scripting.EngineFactory;
import agorum.roi.scripting.sandbox.SandboxClassShutter;
import agorum.roi.scripting.sandbox.SandboxWrapFactory;
import agorum.roi.statistic.EngineFactoryStatistic;
import java.util.Deque;
import java.util.LinkedList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;

public class SandboxContext
extends Context {
    static final String METADB_BASE = "MAIN_MODULE_MANAGEMENT/roi/control/scripting/";
    private static final Statistic stat = EngineFactoryStatistic.getInstance();
    private boolean sandboxed;
    private final Deque<Boolean> sandboxStack = new LinkedList<Boolean>();
    private final Deque<Long> thresholdStack = new LinkedList<Long>();
    private long maxExecutionTime;
    private long thresholdTime;

    public SandboxContext(ContextFactory contextFactory) {
        super(contextFactory);
        this.setLanguageVersion(200);
        this.setWrapFactory(new SandboxWrapFactory());
    }

    public void enterSandbox(boolean sandboxed) {
        Context.ClassShutterSetter css;
        if (sandboxed && (css = this.getClassShutterSetter()) != null) {
            SessionController sc = SessionControllerAdmin.getService(EngineFactory.class);
            try {
                css.setClassShutter(new SandboxClassShutter(this, sc));
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Could not initialize class shutter");
                css.setClassShutter(className -> !sandboxed);
            }
            try {
                String[] aMaxExecutionTime = MetaDbSuperCache.getSimplePropertyValues(sc, "MAIN_MODULE_MANAGEMENT/roi/control/scripting/security/MaxExecutionTime");
                if (aMaxExecutionTime != null && aMaxExecutionTime.length > 0) {
                    this.maxExecutionTime = Long.parseLong(aMaxExecutionTime[0]);
                    this.setInstructionObserverThreshold(10000);
                }
            }
            catch (Exception e) {
                stat.error().exception((Throwable)e).send("Could not initialize instruction observer");
            }
        }
        this.sandboxStack.push(this.sandboxed);
        this.thresholdStack.push(this.thresholdTime);
        this.sandboxed = this.sandboxed || sandboxed;
        this.thresholdTime = System.currentTimeMillis() + this.maxExecutionTime;
    }

    public void leaveSandbox() {
        this.thresholdTime = this.thresholdStack.pop();
        this.sandboxed = this.sandboxStack.pop();
    }

    public boolean isSandboxed() {
        return this.sandboxed;
    }

    public void start() {
        this.thresholdTime = System.currentTimeMillis() + this.maxExecutionTime;
    }

    public void progress(int instructionCount) {
        if (this.sandboxed && System.currentTimeMillis() > this.thresholdTime) {
            throw new EvaluatorException("Maximum script execution time exceeded: " + this.maxExecutionTime + "ms");
        }
    }
}

