/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.beans;

import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.UserManager;
import agorum.roi.ejb.common.UserManagerBean;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacade;

public class DirectoryUserObjectSessionFacade
extends GlobalObjectSessionFacade {
    private boolean isAssociatedRoleNameSet;
    private String credentialManager;
    private String userName;
    private String[] aliases;
    private String passWord;
    private Boolean adminEnabled;
    private String description;
    private String[] emailAddresses;
    private String givenName;
    private String familyName;
    private String language;
    private String mandatorIdentifier;
    private String defaultRoleName;
    private String associatedRoleName;
    private String isRole;
    private long quotaAllocatedStorage = -1L;
    private String uuid;

    public DirectoryUserObjectSessionFacade(SessionController sessionController) throws Exception {
        super(sessionController);
        this.gosfc.setGlobalObjectClientBeanDefinition(new DirectoryUserObjectClientBeanDefinition(sessionController));
    }

    public void check(DirectoryUserObjectClientBean user) throws Exception {
        UserManagerBean userManagerBean = this.getUserManagerBean();
        UserManager userManager = new UserManager(this.sessionController);
        userManager.check(userManagerBean, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean create() throws Exception {
        DirectoryUserObjectClientBean poRet = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            UserManagerBean userManagerBean = this.getUserManagerBean();
            UserManager userManager = new UserManager(this.sessionController);
            poRet = userManager.create(userManagerBean);
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GlobalObjectClientBean update() throws Exception {
        DirectoryUserObjectClientBean poRet = (DirectoryUserObjectClientBean)this.gosfc.getGlobalObject();
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            UserManagerBean userManagerBean = this.getUserManagerBean();
            UserManager userManager = new UserManager(this.sessionController);
            poRet = userManager.update(userManagerBean, poRet);
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalObjectClientBean addItemNotification() throws Exception {
        DirectoryUserObjectClientBean poRet = (DirectoryUserObjectClientBean)this.gosfc.getGlobalObject();
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            UserManagerBean userManagerBean = this.getUserManagerBean();
            UserManager userManager = new UserManager(this.sessionController);
            poRet = userManager.addItemNotification(userManagerBean, poRet);
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return poRet;
    }

    private UserManagerBean getUserManagerBean() throws Exception {
        UserManagerBean userManagerBean = new UserManagerBean();
        userManagerBean.setUserName(this.userName);
        userManagerBean.setAdminEnabled(this.adminEnabled);
        userManagerBean.setDescription(this.description);
        userManagerBean.setEmailAddresses(this.emailAddresses);
        userManagerBean.setPassWord(this.passWord);
        userManagerBean.setGivenName(this.givenName);
        userManagerBean.setFamilyName(this.familyName);
        userManagerBean.setLanguage(this.language);
        userManagerBean.setQuotaAllocatedStorage(this.quotaAllocatedStorage);
        userManagerBean.setMandatorIdentifier(this.mandatorIdentifier);
        userManagerBean.setDefaultRoleName(this.defaultRoleName);
        userManagerBean.setUserUuid(this.uuid);
        if (this.isAssociatedRoleNameSet) {
            userManagerBean.setAssoiciatedRolesName(this.associatedRoleName);
        }
        if (this.aliases != null) {
            userManagerBean.setAliases(this.aliases);
        }
        userManagerBean.setIsRole(this.isRole);
        userManagerBean.setCredentialManager(this.credentialManager);
        String destinationFolder = null;
        if (this.gosfc.getDestinationFolder() != null) {
            destinationFolder = this.gosfc.getDestinationFolder().getAnyFolderPath();
        }
        userManagerBean.setDestinationFolder(destinationFolder);
        return userManagerBean;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public String getPassWord() {
        return this.passWord;
    }

    public void setPassWord(String passWord) {
        this.passWord = passWord;
    }

    public Boolean isAdminEnabled() {
        return this.adminEnabled;
    }

    public void setAdminEnabled(boolean adminEnabled) {
        this.adminEnabled = adminEnabled;
    }

    public void setAdminEnabled(Boolean adminEnabled) {
        this.adminEnabled = adminEnabled;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String[] getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(String[] emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getMandatorIdentifier() {
        return this.mandatorIdentifier;
    }

    public void setMandatorIdentifier(String mandatorIdentifier) {
        this.mandatorIdentifier = mandatorIdentifier;
    }

    public String getDefaultRoleName() {
        return this.defaultRoleName;
    }

    public void setDefaultRoleName(String defaultRoleName) {
        this.defaultRoleName = defaultRoleName;
    }

    public String getAssociatedRoleName() {
        return this.associatedRoleName;
    }

    public void setAssociatedRoleName(String associatedRoleName) {
        this.associatedRoleName = associatedRoleName;
        this.isAssociatedRoleNameSet = true;
    }

    public String getIsRole() {
        return this.isRole;
    }

    public void setIsRole(String isRole) {
        this.isRole = isRole;
    }

    public String getCredentialManager() {
        return this.credentialManager;
    }

    public void setCredentialManager(String credentialManager) {
        this.credentialManager = credentialManager;
    }

    public long getQuotaAllocatedStorage() {
        return this.quotaAllocatedStorage;
    }

    public void setQuotaAllocatedStorage(long quotaAllocatedStorage) {
        this.quotaAllocatedStorage = quotaAllocatedStorage;
    }
}

