/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.sessionfacade.beans;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.AttachmentsRelationObjectClientBean;
import agorum.roi.ejb.client.beans.AttachmentsRelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBeanDefinition;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.RoiTransactionHandler;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.GlobalObjectSessionFacadeContainer;
import agorum.roi.sessionfacade.common.SessionFacade;
import java.util.Enumeration;
import java.util.Vector;

public class GlobalObjectSessionFacade
extends SessionFacade {
    private boolean classnameFromDestinationFolder = false;
    private boolean nameWithId = false;
    private String name = null;
    public GlobalObjectSessionFacadeContainer gosfc = null;
    private String[] attachments = null;
    private String[] attachmentsNoAccess = null;
    public static final String RELACEIDSTRING_IN_NAME = "$$ID$$";

    public GlobalObjectSessionFacade(SessionController sessionController) throws Exception {
        super(sessionController);
        this.gosfc = new GlobalObjectSessionFacadeContainer(sessionController);
    }

    public void setGlobalObjectClientBeanDefinition(GlobalObjectClientBeanDefinition gocbd) {
        try {
            gocbd.setId(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.gosfc.setGlobalObjectClientBeanDefinition(gocbd);
    }

    public void setDefinitionFromDestinationFolder() throws Exception {
        try {
            GlobalObjectClientBeanDefinition pod = (GlobalObjectClientBeanDefinition)this.gosfc.getDestinationFolder().getDefinition(this.sessionController);
            this.setGlobalObjectClientBeanDefinition(pod);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setGlobalObject(String globalObjectId) throws Exception {
        this.setGlobalObject(new Long(globalObjectId));
    }

    public void setGlobalObject(Long globalObjectId) throws Exception {
        try {
            this.setGlobalObject(this.sessionController.getGlobalObjectById(globalObjectId));
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setGlobalObject(GlobalObjectClientBean gocb) throws Exception {
        try {
            this.gosfc.setGlobalObject(gocb);
            GlobalObjectClientBeanDefinition pDef = (GlobalObjectClientBeanDefinition)gocb.getNewDefinition(this.sessionController);
            pDef.setClassId(gocb.getClassId());
            this.gosfc.setGlobalObjectClientBeanDefinition(pDef);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setDestinationFolder(Long destinationFolderId) throws Exception {
        try {
            FolderObjectClientBean folder = (FolderObjectClientBean)this.sessionController.getGlobalObjectById(destinationFolderId);
            this.gosfc.setDestinationFolder(folder);
            this.setDefinitionFromFolder();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setDestinationFolder(FolderObjectClientBean destinationFolder) {
        this.gosfc.setDestinationFolder(destinationFolder);
        try {
            this.setDefinitionFromFolder();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void setAccessControlList(AccessControlListObjectClientBean acl) {
        this.gosfc.setAccessControlList(acl);
    }

    public void setScopeACLs(AccessControlListObjectClientBean[] acl) {
        this.gosfc.setScopeACLs(acl);
    }

    public void setNameWithId(boolean nameWithId) {
        this.nameWithId = nameWithId;
    }

    public void setClassnameFromDestinationFolder(boolean classnameFromDestinationFolder) {
        this.classnameFromDestinationFolder = classnameFromDestinationFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalObjectClientBean create() throws Exception {
        GlobalObjectClientBean gocb = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            this.setCreateName();
            GlobalObjectClientBeanDefinition def = this.getGlobalObjectClientBeanDefinition();
            def.setSystemOption("doNotCreateHistory", "");
            def.saveUpdatedExtendedAttributes();
            gocb = this.createGlobalObject();
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            rth = this.abortTransaction(rth);
        }
        return gocb;
    }

    protected void setDefinitionFromFolder() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GlobalObjectClientBean update() throws Exception {
        GlobalObjectClientBean gocb = null;
        RoiTransactionHandler rth = null;
        try {
            rth = this.getRoiTransactionHandler();
            this.beginTransaction(rth);
            this.setCreateName();
            GlobalObjectClientBeanDefinition def = this.getGlobalObjectClientBeanDefinition();
            def.saveUpdatedExtendedAttributes();
            gocb = this.updateGlobalObject();
            rth = this.completeTransaction(rth);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            this.abortTransaction(rth);
        }
        return gocb;
    }

    private void setName(String name) throws Exception {
        this.name = name;
        this.setAttributeInternal(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
    }

    private GlobalObjectClientBean createGlobalObject() throws Exception {
        GlobalObjectClientBean poRet = null;
        try {
            poRet = this.createGlobalObjectInternal();
            this.createOrUpdateAttachments(poRet, this.attachments, this.attachmentsNoAccess, new AttachmentsRelationObjectClientBeanDefinition(this.sessionController), AttachmentsRelationObjectClientBean.CLASS_NAME);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return poRet;
    }

    private GlobalObjectClientBean updateGlobalObject() throws Exception {
        GlobalObjectClientBean poRet = this.gosfc.getGlobalObject();
        try {
            GlobalObjectClientBeanDefinition def = this.getGlobalObjectClientBeanDefinition();
            this.setAclToDefinition(def, this.gosfc.getAccessControlList(), this.gosfc.getDestinationFolder());
            this.setScopeAclsToDefinition(def, this.gosfc.getScopeACLs(), this.gosfc.getDestinationFolder());
            poRet.update(def);
            this.createOrUpdateAttachments(poRet, this.attachments, this.attachmentsNoAccess, new AttachmentsRelationObjectClientBeanDefinition(this.sessionController), AttachmentsRelationObjectClientBean.CLASS_NAME);
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return poRet;
    }

    private void setCreateName() throws Exception {
        GlobalObjectClientBeanDefinition def;
        if (this.nameWithId && (def = this.getGlobalObjectClientBeanDefinition()).getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE) != null) {
            String name = def.getAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE).getString();
            if (def.getId() == null) {
                def.setId(this.sessionController.getSequenceId());
            }
            Long id = def.getId();
            name = this.su.strReplace(name, RELACEIDSTRING_IN_NAME, "" + id);
            def.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, AttributeValue.newAttributeValueObject(name));
        }
    }

    protected ClassObjectClientBean getClassObject() throws Exception, Exception {
        ClassObjectClientBean coRet = null;
        FolderObjectClientBean dest = this.gosfc.getDestinationFolder();
        coRet = this.classnameFromDestinationFolder && dest != null ? this.sessionController.getClassObject(dest.getClassName()) : this.sessionController.getClassObject(this.gosfc.getClassname());
        return coRet;
    }

    public GlobalObjectClientBean getGlobalObject() {
        return this.gosfc.getGlobalObject();
    }

    public GlobalObjectClientBeanDefinition getGlobalObjectClientBeanDefinition() throws Exception {
        GlobalObjectClientBeanDefinition gocbd = this.gosfc.getGlobalObjectDefinition();
        if (gocbd == null) {
            ExceptionUtils.handleException("We need a definition for this class", "agorum.roi.remote.exception.WeNeedADefinition", 53);
        }
        Enumeration enumSO = this.getAllSystemOption().keys();
        while (enumSO.hasMoreElements()) {
            String key = (String)enumSO.nextElement();
            Object o = this.getAllSystemOption().get(key);
            gocbd.setSystemOption(key, o);
        }
        return gocbd;
    }

    private GlobalObjectClientBean createGlobalObjectInternal() throws Exception {
        GlobalObjectClientBeanDefinition gocbd = this.getGlobalObjectClientBeanDefinition();
        this.setAclToDefinition(gocbd, this.gosfc.getAccessControlList(), this.gosfc.getDestinationFolder());
        this.setScopeAclsToDefinition(gocbd, this.gosfc.getScopeACLs(), this.gosfc.getDestinationFolder());
        if (this.gosfc.getDestinationFolder() != null) {
            this.setAddToFolderOption(gocbd, this.gosfc.getDestinationFolder());
        }
        GlobalObjectClientBean gocb = this.sessionController.createGlobalObject(gocbd);
        this.gosfc.setGlobalObject(gocb);
        return gocb;
    }

    private void setAddToFolderOption(GlobalObjectClientBeanDefinition pod, FolderObjectClientBean destinationFolder) throws Exception {
        if (destinationFolder != null) {
            pod.setAddToFolderOption(destinationFolder);
        }
    }

    private void setAclToDefinition(GlobalObjectClientBeanDefinition pod, AccessControlListObjectClientBean acl, FolderObjectClientBean destinationFolder) throws Exception {
        if (pod != null) {
            if (acl != null) {
                this.setAttributeInternal(pod, GlobalObjectClientBean.ACL_ATTRIBUTE, acl, false);
            } else if (destinationFolder != null) {
                this.setAttributeInternal(pod, GlobalObjectClientBean.ACL_ATTRIBUTE, destinationFolder.getAcl(), false);
                pod.setScopeAcls(destinationFolder.getScopeAclsById());
            }
        }
    }

    private void setScopeAclsToDefinition(GlobalObjectClientBeanDefinition pod, AccessControlListObjectClientBean[] acl, FolderObjectClientBean destinationFolder) throws Exception {
        if (pod != null) {
            AccessControlListObjectClientBean[] acls;
            if (acl != null) {
                pod.setScopeAcls(acl);
            } else if (destinationFolder != null && (acls = destinationFolder.getScopeAcls()) != null) {
                pod.setScopeAcls(acls);
            }
        }
    }

    private void setAttribute(GlobalObjectClientBeanDefinition pod, String attributeName, Object attributeValue) throws Exception {
        this.setAttributeInternal(pod, attributeName, attributeValue, true);
    }

    public void addArrayElement(String attributeName, Object value) throws Exception {
        this.getGlobalObjectClientBeanDefinition().addArrayElement(attributeName, AttributeValue.newAttributeValueObject(value));
    }

    public void insertArrayElementAt(String attributeName, Object value, long pos) throws Exception {
        this.getGlobalObjectClientBeanDefinition().insertArrayElementAt(attributeName, AttributeValue.newAttributeValueObject(value), pos);
    }

    public void removeArrayElementAt(String attributeName, long pos) throws Exception {
        this.getGlobalObjectClientBeanDefinition().removeArrayElementAt(attributeName, pos);
    }

    public void removeArrayElement(String attributeName, Object value) throws Exception {
        this.getGlobalObjectClientBeanDefinition().removeArrayElement(attributeName, AttributeValue.newAttributeValueObject(value));
    }

    protected void setAttributeInternal(GlobalObjectClientBeanDefinition pod, String attributeName, Object attributeValue, boolean isExternal) throws Exception {
        try {
            if (attributeName.equalsIgnoreCase(GlobalObjectClientBean.ACL_ATTRIBUTE) && isExternal) {
                this.setAccessControlList((AccessControlListObjectClientBean)attributeValue);
            } else if (attributeValue != null) {
                AttributeValue av = AttributeValue.newAttributeValueObject(attributeValue);
                pod.setAttribute(attributeName, av);
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
    }

    public void setAttribute(String attributeName, Object attributeValue) throws Exception {
        this.setAttributeInternal(this.getGlobalObjectClientBeanDefinition(), attributeName, attributeValue, true);
    }

    protected void setAttributeInternal(String attributeName, Object attributeValue) throws Exception {
        this.setAttributeInternal(this.getGlobalObjectClientBeanDefinition(), attributeName, attributeValue, false);
    }

    public void setClassname(String classname) {
        this.gosfc.setClassname(classname);
    }

    public String getName() {
        return this.name;
    }

    public void setAttachments(String[] attachments, String[] attachmentsNoAccess) {
        this.attachments = attachments;
        this.attachmentsNoAccess = attachmentsNoAccess;
    }

    public void createOrUpdateAttachments(GlobalObjectClientBean gocb, String[] attachments, String[] attachmentsNoAccess, RelationObjectClientBeanDefinition relDef, String className) throws Exception {
        if (attachments != null) {
            Long id;
            String sId;
            int i;
            int len = attachments.length;
            GlobalObjectClientBean[] values = null;
            Vector<GlobalObjectClientBean> v = new Vector<GlobalObjectClientBean>();
            for (i = 0; i < len; ++i) {
                sId = this.su.getStringFromPos(attachments[i], "||", 1);
                id = null;
                try {
                    id = new Long(sId);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (id == null) continue;
                try {
                    GlobalObjectClientBean go = this.sessionController.getGlobalObjectById(id);
                    v.addElement(go);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (attachmentsNoAccess != null) {
                len = attachmentsNoAccess.length;
                for (i = 0; i < len; ++i) {
                    if (attachmentsNoAccess[i] == null) continue;
                    sId = this.su.getStringFromPos(attachmentsNoAccess[i], "||", 1);
                    id = null;
                    try {
                        id = new Long(sId);
                        v.addElement(this.sessionController.getGlobalObjectById(id));
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            len = v.size();
            values = new GlobalObjectClientBean[len];
            for (i = 0; i < len; ++i) {
                values[i] = (GlobalObjectClientBean)v.elementAt(i);
            }
            this.storeObjects(gocb, values, relDef, className, true);
        }
    }

    public void storeObjects(GlobalObjectClientBean gocb, GlobalObjectClientBean[] newValue, RelationObjectClientBeanDefinition relDef, String className) throws Exception {
        this.storeObjects(gocb, newValue, relDef, className, false);
    }

    public void storeObjects(GlobalObjectClientBean gocb, GlobalObjectClientBean[] newValue, RelationObjectClientBeanDefinition relDef, String className, boolean deleteOnlyRelation) throws Exception {
        GlobalObjectClientBean[] aIst = gocb.getRightwardRelationObjects(className);
        if (aIst == null && newValue != null) {
            gocb.addRelationship(newValue, relDef);
        } else if (aIst != null && newValue == null) {
            int len = aIst.length;
            for (int i = 0; i < len; ++i) {
                if (aIst[i] == null) continue;
                if (deleteOnlyRelation) {
                    gocb.removeRelationship(gocb.getRelations(className, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, aIst[i]));
                    continue;
                }
                SuperObjectClientBeanDefinition def = aIst[i].getNewDefinition(this.sessionController);
                def.setSystemOption("parentFolderOfDeleteObject", gocb);
                aIst[i].delete(def);
            }
        } else if (aIst != null && newValue != null) {
            int lenIst = aIst.length;
            int lenNew = newValue.length;
            for (int i = 0; i < lenIst; ++i) {
                boolean found = false;
                for (int j = 0; j < lenNew; ++j) {
                    if (aIst[i] == null || newValue[j] == null || aIst[i].getId().longValue() != newValue[j].getId().longValue()) continue;
                    found = true;
                    newValue[j] = null;
                }
                if (found) continue;
                if (deleteOnlyRelation) {
                    gocb.removeRelationship(gocb.getRelations(className, RelationObjectClientBean.LEFTOBJECT_ATTRIBUTE, RelationObjectClientBean.RIGHTOBJECT_ATTRIBUTE, aIst[i]));
                    continue;
                }
                SuperObjectClientBeanDefinition def = aIst[i].getNewDefinition(this.sessionController);
                def.setSystemOption("parentFolderOfDeleteObject", gocb);
                aIst[i].delete(def);
            }
            gocb.addRelationship(newValue, relDef);
        }
    }

    public void setExtendedAttributesXML(String extendedAttributesXML) throws Exception {
        this.gosfc.getGlobalObjectDefinition().setExtendedAttributesXML(extendedAttributesXML);
    }

    public void setExtendedAttributesXML(String extendedAttributesXML, boolean inheritable) throws Exception {
        this.gosfc.getGlobalObjectDefinition().setExtendedAttributesXML(extendedAttributesXML, inheritable);
    }

    public void setExtendedAttributesXML(String attrName, Object object) throws Exception {
        this.setExtendedAttribute(attrName, object, false);
    }

    public void setExtendedAttribute(String attrName, Object object, boolean update) throws Exception {
        AttributeValue attributeValue = AttributeValue.newAttributeValueObject(object);
        this.gosfc.getGlobalObjectDefinition().setExtendedAttribute(attrName, attributeValue, update);
    }

    public void removeExtendedAttribute(String attrName) throws Exception {
        this.gosfc.getGlobalObjectDefinition().removeExtendedAttribute(attrName);
    }
}

