/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemCheckSuite;
import agorum.commons.statistic.SystemTaskException;
import agorum.commons.utils.RandomIdGenerator;
import agorum.roi.ejb.client.beans.DirectoryUserObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.sessionfacade.beans.DirectoryUserObjectSessionFacade;
import java.util.Map;

public abstract class RoiCheckSuite
extends SystemCheckSuite {
    private static final String TEST_USER_NAME = "agorum-support-test-user";
    private DirectoryUserObjectClientBean testUser;
    private String testUserPassword;

    protected RoiCheckSuite(Statistic parent) {
        super(parent);
    }

    protected DirectoryUserObjectClientBean getTestUser() throws SystemTaskException {
        if (this.testUser == null) {
            try {
                SessionController sc = SessionControllerAdmin.getSessionControllerAdmin(RoiCheckSuite.class.getName());
                this.testUser = sc.getUserByName(TEST_USER_NAME);
                if (this.testUser == null) {
                    FolderObjectClientBean target = (FolderObjectClientBean)sc.findGlobalObjectByPath("/agorum/roi/Administration/User");
                    target = target.createPath("SystemUser");
                    DirectoryUserObjectSessionFacade usf = new DirectoryUserObjectSessionFacade(sc);
                    usf.setWithTransaction(true);
                    usf.setDestinationFolder(target);
                    usf.setUserName(TEST_USER_NAME);
                    this.testUserPassword = RandomIdGenerator.createId();
                    usf.setPassWord(this.testUserPassword);
                    usf.setEmailAddresses(new String[]{"agorum-support-test-user@agorum.com"});
                    this.testUser = (DirectoryUserObjectClientBean)usf.create();
                } else {
                    DirectoryUserObjectSessionFacade usf = new DirectoryUserObjectSessionFacade(sc);
                    this.testUserPassword = RandomIdGenerator.createId();
                    usf.setPassWord(this.testUserPassword);
                    usf.setGlobalObject(this.testUser);
                    usf.update();
                    this.testUser.unlock();
                }
            }
            catch (Exception e) {
                throw new SystemTaskException("Could not initialize test user", (Throwable)e);
            }
        }
        return this.testUser;
    }

    protected String getTestUserPassword() throws SystemTaskException {
        this.getTestUser();
        return this.testUserPassword;
    }

    protected void performCheck(Map<String, Object> args) throws SystemTaskException {
        this.testUser = null;
        super.performCheck(args);
        if (this.testUser != null) {
            try {
                this.testUser.lock();
            }
            catch (Exception e) {
                this.error("Could not lock test user", e);
            }
        }
    }
}

