/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic;

import agorum.commons.cron.SystemTimer;
import agorum.commons.logging.LogAction;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.ObjectLogger;
import agorum.commons.statistic.StatisticBase;
import agorum.commons.statistic.measurement.Measurement;
import agorum.commons.statistic.settings.VersionInfo;
import agorum.commons.string.SerializableMap;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.tuple.Pair;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.MetaDbSuperCache;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.scripting.ScriptError;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import agorum.roi.statistic.AgorumProcessList;
import agorum.roi.statistic.ContentHashServiceStatistic;
import agorum.roi.statistic.ContentTaskStatistic;
import agorum.roi.statistic.DatabaseAccessStatistic;
import agorum.roi.statistic.DownloadQuotaStatistic;
import agorum.roi.statistic.EngineFactoryStatistic;
import agorum.roi.statistic.MailServiceStatistic;
import agorum.roi.statistic.SessionControllerStatistic;
import agorum.roi.statistic.SmartFolderStatistic;
import agorum.roi.statistic.TransactionStatistic;
import agorum.roi.statistic.action.JavaScriptAction;
import agorum.roi.statistic.action.LogDownloadAction;
import agorum.roi.statistic.action.PackageInstallAction;
import agorum.roi.statistic.action.SSOAction;
import agorum.roi.statistic.certificate.CertificateGenerationAction;
import agorum.roi.statistic.certificate.CertificateUploadAction;
import agorum.roi.statistic.certificate.KeystoreManagementAction;
import agorum.roi.statistic.check.AgorumCoreBenchCheck;
import agorum.roi.statistic.check.AuthenticationCheck;
import agorum.roi.statistic.check.CPUBenchCheck;
import agorum.roi.statistic.check.DBDriverCheck;
import agorum.roi.statistic.check.DBSpaceCheck;
import agorum.roi.statistic.check.FileSpaceCheck;
import agorum.roi.statistic.check.IOSizeCheck;
import agorum.roi.statistic.check.JMSCheck;
import agorum.roi.statistic.check.MemoryCheck;
import agorum.roi.statistic.check.SuperObjectCacheCheck;
import agorum.roi.statistic.check.ToolAvailabilityCheck;
import agorum.roi.statistic.config.ActiveServicesConfig;
import agorum.roi.statistic.config.LogFileCleanerConfig;
import agorum.roi.statistic.config.ModuleActivationConfig;
import agorum.roi.statistic.config.SmartFolderConfig;
import agorum.roi.statistic.config.SuperObjectCacheConfig;
import agorum.roi.statistic.config.TemporaryObjectConfig;
import agorum.roi.statistic.logaction.AddUserTag;
import agorum.roi.statistic.logaction.ChangeLogLevel;
import agorum.roi.statistic.logaction.CreateCounter;
import agorum.roi.statistic.logaction.CreateSticky;
import agorum.roi.statistic.logaction.Dismiss;
import agorum.roi.statistic.logaction.SendMail;
import agorum.roi.statistic.measurement.JmsMessageCache;
import agorum.roi.statistic.measurement.JvmMemoryLoad;
import agorum.roi.statistic.measurement.JvmThreads;
import agorum.roi.statistic.measurement.ServerDiskSpaceAgorum;
import agorum.roi.statistic.measurement.ServerDiskSpaceRoot;
import agorum.roi.statistic.measurement.ServerDiskSpaceSolr;
import agorum.roi.statistic.measurement.ServerUpTime;
import agorum.roi.statistic.searchengine.SearchEngineStatisticInitiator;
import agorum.roi.statistic.thread.ThreadPoolCheck;
import agorum.roi.statistic.thread.ThreadPoolConfig;
import agorum.roi.statistic.workers.WorkersStatistics;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Map;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.type.JavaType;
import org.mozilla.javascript.Scriptable;

public class RoiStatistics {
    public static final String SERVER_HOME_ENV = "jboss.server.home.dir";

    public static void getInstance() throws Exception {
        String indexPath;
        ObjectLogger.register(object -> {
            ScriptError se = null;
            String message = object.toString();
            String details = null;
            if (object instanceof Throwable) {
                se = new ScriptError((Throwable)object);
            } else if (object instanceof Scriptable) {
                se = new ScriptError((Scriptable)object);
            } else {
                String string = details = object instanceof Throwable ? StringConverterUtils.toString((Throwable)((Throwable)object)) : message;
            }
            if (se != null) {
                String innerMessage = se.getMessage();
                if (innerMessage != null && !innerMessage.isEmpty() && message.indexOf(innerMessage) < 0) {
                    message = message + " (" + innerMessage + ")";
                }
                details = se.getDetails();
            }
            return new Pair((Object)message, (Object)details);
        });
        AddUserTag.registerSelf();
        ChangeLogLevel.registerSelf();
        CreateCounter.registerSelf();
        CreateSticky.registerSelf();
        Dismiss.registerSelf();
        SendMail.registerSelf();
        LogAction.start();
        RoiStatistics.initCoreStatistic();
        AgorumProcessList.getInstance();
        ContentHashServiceStatistic.getInstance();
        ContentTaskStatistic.getInstance();
        DatabaseAccessStatistic.getInstance();
        DownloadQuotaStatistic.getInstance();
        EngineFactoryStatistic.getInstance();
        SessionControllerStatistic.getInstance();
        TransactionStatistic.getInstance();
        WorkersStatistics.getInstance();
        SmartFolderStatistic.getInstance();
        SearchEngineStatisticInitiator.init();
        MailServiceStatistic.getInstance();
        SSOAction.getInstance();
        CertificateGenerationAction.getInstance();
        CertificateUploadAction.getInstance();
        JavaScriptAction.getInstance();
        KeystoreManagementAction.getInstance();
        LogDownloadAction.getInstance();
        PackageInstallAction.getInstance();
        AgorumCoreBenchCheck.getInstance();
        CPUBenchCheck.getInstance();
        DBDriverCheck.getInstance();
        IOSizeCheck.getInstance("core", System.getProperty("jboss.home.dir"));
        JMSCheck.getInstance();
        MemoryCheck.getInstance();
        SuperObjectCacheCheck.getInstance();
        ToolAvailabilityCheck.getInstance();
        AuthenticationCheck.getInstance();
        TemporaryObjectConfig.getInstance();
        SuperObjectCacheConfig.getInstance();
        LogFileCleanerConfig.getInstance();
        ThreadPoolCheck.getInstance();
        ThreadPoolConfig.getInstance();
        ModuleActivationConfig.getInstance();
        ActiveServicesConfig.getInstance();
        FileSpaceCheck.getInstance();
        DBSpaceCheck.getInstance();
        SmartFolderConfig.getInstance();
        IOSizeCheck.getInstance("core", System.getProperty("jboss.home.dir"));
        SessionController sc = SessionControllerAdmin.getSessionControllerAdmin("RoiStatistics");
        boolean indexExported = Boolean.parseBoolean(MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/DoExportIndexToFS", "false"));
        if (indexExported && (indexPath = MetaDbSuperCache.getSimplePropertyValue(sc, "MAIN_MODULE_MANAGEMENT/textindexservice/control/syncdata/indexer/ExportIndexDirectory", null)) != null) {
            IOSizeCheck.getInstance("index", indexPath);
        }
        String baseKey = "MAIN_MODULE_MANAGEMENT/roi/control/statistic/io";
        int counter = 1;
        while (true) {
            String io = baseKey + "/ioBench_" + counter;
            String ident = MetaDbSuperCache.getSimplePropertyValue(sc, io + "/Ident", null);
            String path = MetaDbSuperCache.getSimplePropertyValue(sc, io + "/Path", null);
            if (path == null || ident == null) break;
            IOSizeCheck.getInstance(ident, path);
            ++counter;
        }
        SystemTimer.ofPeriod((long)3600000L).name("BackupSettingsTimer").call(RoiStatistics::backupStatisticSettings);
    }

    public static int percent(double value, double refValue) {
        return (int)Math.abs(100.0 / refValue * value);
    }

    private static final void initCoreStatistic() {
        File[] solrNodeDirs;
        CoreStatistic coreStatistic = CoreStatistic.getInstance();
        coreStatistic.addMeasurement(StatisticBase.asPinned((Measurement)new ServerUpTime()));
        coreStatistic.addMeasurement((Measurement)new JvmMemoryLoad());
        coreStatistic.addMeasurement((Measurement)new JmsMessageCache());
        coreStatistic.addMeasurement((Measurement)new JvmThreads());
        coreStatistic.addMeasurement((Measurement)new ServerDiskSpaceRoot());
        coreStatistic.addMeasurement((Measurement)new ServerDiskSpaceAgorum());
        String serverHome = System.getProperty(SERVER_HOME_ENV);
        File solrNodes = new File(serverHome + "/../../../solr/nodes/node/solr");
        if (solrNodes.exists() && (solrNodeDirs = solrNodes.listFiles()) != null) {
            for (File solrNodeDir : solrNodeDirs) {
                if (!solrNodeDir.isDirectory() || solrNodeDir.getName().indexOf("_replica") == -1) continue;
                String name = solrNodeDir.getName();
                if (!(solrNodeDir = new File(solrNodeDir, "data")).exists()) continue;
                coreStatistic.addMeasurement((Measurement)new ServerDiskSpaceSolr(solrNodeDir.getAbsolutePath(), name));
            }
        }
    }

    private static final void backupStatisticSettings() {
        try {
            File settingsFile = new File(VersionInfo.SETTINGS_FILE_PATH);
            if (!settingsFile.exists()) {
                return;
            }
            String content = new String(Files.readAllBytes(Paths.get(settingsFile.toURI())), "UTF-8");
            ObjectMapper mapper = new ObjectMapper();
            MapType type = mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class);
            SerializableMap sm = new SerializableMap((Map)mapper.readValue(content, (JavaType)type));
            SerializableMap vi = sm.getSerializableMap("versioninfo", null);
            String name = Long.toString(vi.getLong("timeCreated")) + "-settings.json";
            SessionController sc = SessionControllerAdmin.getService(RoiStatistics.class);
            FolderObjectClientBean folder = (FolderObjectClientBean)sc.findGlobalObjectByPathOrId("/agorum/roi");
            FileObjectClientBean file = (FileObjectClientBean)(folder = folder.createPath("statistic")).getItem(name);
            if (file == null) {
                FileObjectSessionFacade def = new FileObjectSessionFacade(sc);
                def.setAttribute(GlobalObjectClientBean.NAME_ATTRIBUTE, name);
                def.setDestinationFolder(folder);
                def.setContentStream(StringConverterUtils.toStream((String)content, (Charset)StandardCharsets.UTF_8));
                file = (FileObjectClientBean)def.create();
            } else {
                file.setContent(StringConverterUtils.toStream((String)content, (Charset)StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            CoreStatistic.getInstance().error((Throwable)e);
        }
    }
}

