/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.certificate;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemAction;
import agorum.commons.statistic.SystemTaskException;
import agorum.commons.string.StringBase64Utils;
import agorum.roi.statistic.certificate.KeystoreUtil;
import java.io.File;
import java.io.FileInputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;

public class CertificateUploadAction
extends SystemAction {
    private static final String ALIAS_NAME_TOMCAT = "tomcat";
    private static final CertificateUploadAction instance = new CertificateUploadAction(CoreStatistic.getInstance().getGroup("Actions"));

    protected CertificateUploadAction(Statistic parent) {
        super(parent);
    }

    public static CertificateUploadAction getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Import a SSL certificate that has been signed by a CA (certificate authority)";
    }

    public String getShortDescription() {
        return "Import certificates";
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        FormItem.Collection fields = new FormItem.Collection();
        fields.attachment("certificate").title("Certificate").description("Signed certificate file").longDescription("Supported file formats are cer, crt, cert, p7b, der, pem, pfx, pkcs12 and p12.").add();
        fields.passwordField("password").title("Password").description("Certificate password (needed for pfx, pkcs12, p12 files)").allowBlank(true).add();
        fields.stringField("alias").title("Alias").description("The alias name of the source certificate").longDescription("If the certificate was generated by the Support Tool, you can leave this blank.").allowBlank(true).add();
        fields.staticField("Information").value((Object)"If you want to install a certificate generated by the Support Tool and signed by a CA (any format), you must leave the alias field blank. If you install a pfx, pkcs12 or p12 certificate, you can list all aliases stored in those files by entering any value (but not blank) in the alias field, and looking at the log output. For all other formats (most prominently p7b and crt), you MUST know the alias name specified when creating the certificate. The alias name can NOT be retrieved from these certificate files.").add();
        fields.button("upload").description("Upload").add();
        return fields.getCollection();
    }

    public boolean runActionSync(Map<String, Object> args) throws SystemTaskException {
        try {
            String button = (String)args.get("buttonId");
            Map attachments = (Map)args.get("attachments");
            if ("upload".equals(button)) {
                File srcCertFile = CertificateUploadAction.attachmentToFile((Statistic.Attachment)((Statistic.Attachment)attachments.get("certificate")));
                char[] srcCertPass = ((String)args.get("password")).toCharArray();
                String srcCertAlias = (String)args.get("alias");
                File destStoreFile = new File(System.getProperty("javax.net.ssl.keyStore"));
                char[] destStorePass = System.getProperty("javax.net.ssl.keyStorePassword") == null ? "changeit".toCharArray() : System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
                if (srcCertAlias == null || srcCertAlias.isEmpty()) {
                    srcCertAlias = ALIAS_NAME_TOMCAT;
                }
                CertificateUploadAction.installCertificate(srcCertFile, srcCertPass, srcCertAlias, destStoreFile, destStorePass);
            }
            this.info().send("Certificates successfully imported. The server must be restarted for the changes to take effect.");
            this.setPromptAfterAction("Certificates successfully imported. The server must be restarted for the changes to take effect.");
        }
        catch (Exception e) {
            CertificateUploadAction.getInstance().error(e, "Unable to import certificate: " + e.getLocalizedMessage());
        }
        return false;
    }

    private static String getExtension(String filename) {
        return filename.substring(filename.lastIndexOf(".") + 1, filename.length());
    }

    public static void installCertificate(File srcCertFile, char[] srcCertPass, String srcCertAlias, File destStoreFile, char[] destStorePass) throws Exception {
        String certType = CertificateUploadAction.getExtension(srcCertFile.getName()).toLowerCase();
        KeystoreUtil destStoreUtils = new KeystoreUtil(destStoreFile, destStorePass);
        KeyStore destStore = destStoreUtils.getKeyStore();
        if ("cer".equals(certType) || "crt".equals(certType) || "cert".equals(certType) || "p7b".equals(certType) || "der".equals(certType) || "pem".equals(certType)) {
            ArrayList<String> certs = destStoreUtils.getPEMBlocks(srcCertFile).get(0);
            ArrayList<String> keys = destStoreUtils.getPEMBlocks(srcCertFile).get(1);
            HashSet certificates = new HashSet();
            for (String certificate : certs) {
                if (StringBase64Utils.isBase64((String)certificate)) continue;
                throw new Exception("Uploaded certificate does not contain valid Base64 data");
            }
            if (srcCertAlias == null || srcCertAlias.isEmpty() || srcCertAlias.equals(ALIAS_NAME_TOMCAT)) {
                Certificate userCert = destStore.getCertificate(srcCertAlias);
                if (userCert == null) {
                    throw new Exception("Alias has no public key certificate.");
                }
                if (!destStoreUtils.installReply(srcCertAlias, certificates, destStore, destStorePass, null)) {
                    throw new Exception("The certificate reply could not be installed");
                }
            } else {
                CertificateUploadAction.getInstance().warning().detail((Object)"The specified certificate is not supported, because it contains no private key and has not been generated by the Support Tool. You may use the Support Tool to generate a new unsigned certificate and send it to a CA (certificate authority) for signing. Once you receive a signed certificate from the CA, you may import it using this tool.").send("The specified certificate is not supported. See log details for more information.");
                throw new Exception("Certificate not supported");
            }
            if (keys.size() > 0) {
                for (String key : keys) {
                    CertificateUploadAction.getInstance().warning(null, "Your certificate has been succesfully imported, but your upload also contained a key whichcouldn't be processed. It's content can be found in the details.", key);
                }
            }
        } else if ("pfx".equals(certType) || "p12".equals(certType) || "pkcs12".equals(certType)) {
            KeyStore pkcsKeystore = KeyStore.getInstance("PKCS12");
            pkcsKeystore.load(new FileInputStream(srcCertFile), srcCertPass);
            if (srcCertAlias == null || srcCertAlias.isEmpty() || srcCertAlias.equals(ALIAS_NAME_TOMCAT)) {
                Enumeration<String> externalAlias = pkcsKeystore.aliases();
                while (externalAlias.hasMoreElements()) {
                    String eAlias = externalAlias.nextElement();
                    if (!pkcsKeystore.isKeyEntry(eAlias)) continue;
                    Certificate[] chain = pkcsKeystore.getCertificateChain(eAlias);
                    HashSet<X509Certificate> certificates = new HashSet<X509Certificate>();
                    for (Certificate cer : chain) {
                        certificates.add((X509Certificate)cer);
                    }
                    if (destStoreUtils.installReply(eAlias, certificates, destStore, destStorePass, srcCertPass)) continue;
                    throw new Exception("The certificate reply could not be installed");
                }
            } else if (pkcsKeystore.isKeyEntry(srcCertAlias)) {
                Key privateKey = pkcsKeystore.getKey(srcCertAlias, srcCertPass);
                Certificate[] certs = pkcsKeystore.getCertificateChain(srcCertAlias);
                destStore.setKeyEntry(ALIAS_NAME_TOMCAT, privateKey, destStorePass, certs);
            } else {
                Certificate cert = pkcsKeystore.getCertificate(srcCertAlias);
                if (cert == null) {
                    Enumeration<String> aliases = pkcsKeystore.aliases();
                    CertificateUploadAction.getInstance().error().detail((Object)"Listing existing aliases in the specified certificate:").detail((Object)String.join((CharSequence)"\n", Collections.list(aliases))).send("Alias name '" + srcCertAlias + "' not found in certificate. Listing aliases in details.");
                    throw new Exception("Alias not found in certificate");
                }
                destStore.setCertificateEntry(ALIAS_NAME_TOMCAT, cert);
            }
            destStoreUtils.save(destStorePass);
            KeystoreUtil.removeAutoSelfSignedGeneration();
        } else {
            throw new Exception("The uploaded file doesn't have a supported file extension. Supported formats are: cer, crt, cert, der, p7b, pfx, pkcs12, p12 and pem  - yours was '" + certType + "'");
        }
    }
}

