/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.certificate;

import agorum.commons.string.StringBase64Utils;
import agorum.commons.string.StringConverterUtils;
import agorum.commons.tuple.Pair;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.x500.X500Principal;

public class KeystoreUtil {
    KeyStore keyStore = KeyStore.getInstance("JKS");
    File file;

    public KeystoreUtil(File pFile, char[] password) throws NoSuchAlgorithmException, CertificateException, IOException, KeyStoreException {
        this.file = pFile;
        FileInputStream fis = new FileInputStream(this.file);
        this.keyStore.load(fis, password);
        fis.close();
    }

    public void save(char[] password) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.file.createNewFile();
        try (FileOutputStream fos = new FileOutputStream(this.file);){
            this.keyStore.store(fos, password);
        }
    }

    public void importCertificate(Certificate cert) throws Exception {
        X509Certificate certificate = (X509Certificate)cert;
        String alias = this.getDN(certificate);
        if (alias == null) {
            throw new Exception(String.format("No suitable alias for cert %s", this.getDN(certificate)));
        }
        if (this.containsAlias(alias)) {
            throw new Exception(String.format("%s alias already exists (%s)", alias, this.getDN(certificate)));
        }
        this.keyStore.setCertificateEntry(alias, cert);
    }

    public Certificate generateCertificate(String pem) throws Exception {
        if (!StringBase64Utils.isBase64((String)pem)) {
            throw new Exception("PEM File does not contain valid Base64 data");
        }
        byte[] der = StringBase64Utils.decode((String)pem);
        ByteArrayInputStream bais = new ByteArrayInputStream(der);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(bais);
    }

    public Certificate generateCertificate(InputStream pemStream) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificate(pemStream);
    }

    public Collection<? extends Certificate> generateCertificates(String pem) throws Exception {
        if (!StringBase64Utils.isBase64((String)pem)) {
            throw new Exception("PEM File does not contain valid Base64 data");
        }
        byte[] der = StringBase64Utils.decode((String)pem);
        ByteArrayInputStream bais = new ByteArrayInputStream(der);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificates(bais);
    }

    public Collection<? extends Certificate> generateCertificates(InputStream pemStream) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        return cf.generateCertificates(pemStream);
    }

    public PrivateKey generateKey(String pem) throws Exception {
        byte[] der = StringConverterUtils.toByte((String)pem);
        PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(der);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(spec);
    }

    public boolean containsAlias(String alias) throws KeyStoreException {
        return this.keyStore.containsAlias(alias);
    }

    public String getDN(X509Certificate certificate) {
        X500Principal x509principal = certificate.getSubjectX500Principal();
        String dn = x509principal.getName("RFC2253");
        return dn;
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    public HashMap<String, String> list() throws KeyStoreException {
        HashMap<String, String> result = new HashMap<String, String>();
        Enumeration<String> aliasesE = this.keyStore.aliases();
        while (aliasesE.hasMoreElements()) {
            String alias = aliasesE.nextElement();
            X509Certificate cert = (X509Certificate)this.keyStore.getCertificate(alias);
            String dn = this.getDN(cert);
            result.put(alias, dn);
        }
        return result;
    }

    public static void prepareServerXML(String pass) throws Exception {
        String startupUpdatePath = System.getProperty("jboss.server.home.dir") + "/../../../startup_updates/jboss/server/default/deploy/jbossweb-tomcat50.sar";
        File orgServerXML = new File(System.getProperty("jboss.server.home.dir") + "/deploy/jbossweb-tomcat50.sar/server.xml");
        File dir = new File(startupUpdatePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File newServerXML = new File(dir, "server.xml");
        List<String> original = Files.readAllLines(orgServerXML.toPath());
        FileWriter writer = new FileWriter(newServerXML.getAbsoluteFile());
        for (String line : original) {
            if (line.contains("keystorePass") && !line.contains("<!--")) {
                int start = line.indexOf("\"") + 1;
                int end = line.indexOf("\"", start);
                String oldPass = line.substring(start, end);
                line = line.replace(oldPass, pass);
                writer.write(line);
                writer.write(System.getProperty("line.separator"));
                continue;
            }
            writer.write(line);
            writer.write(System.getProperty("line.separator"));
        }
        writer.close();
    }

    public static void removeAutoSelfSignedGeneration() throws IOException {
        if (System.getProperty("os.name").toLowerCase().indexOf("win") >= 0) {
            String jbossHomePath = System.getProperty("jboss.home.dir");
            String startScriptPath = jbossHomePath.substring(0, jbossHomePath.lastIndexOf("\\")) + "\\scripts\\roi_jboss.bat";
            File startScript = new File(startScriptPath = Paths.get(startScriptPath, new String[0]).toString());
            if (startScript.exists() && startScript.canWrite()) {
                List<String> lines = Files.readAllLines(startScript.toPath());
                ArrayList<String> newLines = new ArrayList<String>();
                for (String line : lines) {
                    if (line.contains("keytool") && !line.startsWith("rem")) {
                        line = "rem " + line;
                    }
                    newLines.add(line);
                }
                Files.write(startScript.toPath(), newLines, new OpenOption[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ArrayList<String>> getPEMBlocks(File pemFile) throws IOException {
        Pattern certBeginPattern = Pattern.compile("-+BEGIN.*?CERTIFICATE-+");
        Pattern certEndPattern = Pattern.compile("-+END.*?CERTIFICATE-+");
        Pattern keyBeginPattern = Pattern.compile("-+BEGIN.*?KEY-+");
        Pattern keyEndPattern = Pattern.compile("-+END.*?KEY-+");
        FileReader fr = new FileReader(pemFile);
        BufferedReader pemFileBR = new BufferedReader(fr);
        ArrayList<ArrayList<String>> result = new ArrayList<ArrayList<String>>(2);
        ArrayList<String> certificates = new ArrayList<String>();
        ArrayList<String> keys = new ArrayList<String>();
        try {
            Boolean inBlock = false;
            String certBlock = null;
            String keyBlock = null;
            while (pemFileBR.ready()) {
                String line = pemFileBR.readLine();
                if (!inBlock.booleanValue()) {
                    Matcher keyBeginPatternMatcher;
                    Matcher certBeginPatternMatcher = certBeginPattern.matcher(line);
                    if (certBeginPatternMatcher.find()) {
                        inBlock = true;
                        certBlock = "";
                    }
                    if (!(keyBeginPatternMatcher = keyBeginPattern.matcher(line)).find()) continue;
                    inBlock = true;
                    keyBlock = "";
                    continue;
                }
                Matcher certEndPatternMatcher = certEndPattern.matcher(line);
                if (certEndPatternMatcher.find()) {
                    certificates.add(certBlock);
                    inBlock = false;
                } else {
                    certBlock = certBlock + line;
                }
                Matcher keyEndPatternMatcher = keyEndPattern.matcher(line);
                if (keyEndPatternMatcher.find()) {
                    keys.add(keyBlock);
                    inBlock = false;
                    continue;
                }
                keyBlock = keyBlock + line;
            }
        }
        finally {
            pemFileBR.close();
        }
        result.add(certificates);
        result.add(keys);
        return result;
    }

    private Pair<Key, char[]> recoverKey(String alias, char[] storePass, char[] keyPass) throws Exception {
        Key key = null;
        if (!this.keyStore.containsAlias(alias)) {
            throw new Exception("Alias '" + alias + "' does not exist");
        }
        if (!this.keyStore.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class) && !this.keyStore.entryInstanceOf(alias, KeyStore.SecretKeyEntry.class)) {
            throw new Exception("Alias '" + alias + "' has no key");
        }
        if (keyPass == null) {
            key = this.keyStore.getKey(alias, storePass);
            keyPass = storePass;
        } else {
            key = this.keyStore.getKey(alias, keyPass);
        }
        return new Pair((Object)key, (Object)keyPass);
    }

    public boolean installReply(String alias, Collection<? extends Certificate> c, KeyStore keyStore, char[] storePass, char[] keyPass) throws Exception {
        Pair<Key, char[]> objs = this.recoverKey(alias, storePass, keyPass);
        PrivateKey privKey = (PrivateKey)objs.getFirst();
        if (keyPass == null) {
            keyPass = (char[])objs.getSecond();
        }
        if (c.isEmpty()) {
            throw new Exception("Reply has no certificates");
        }
        Certificate userCert = keyStore.getCertificate(alias);
        Certificate[] replyCerts = c.toArray(new Certificate[c.size()]);
        Certificate[] newChain = replyCerts.length == 1 ? this.establishCertChain(this.getKeyStore(), this.getCacertsKeyStore(), userCert, replyCerts[0]) : this.validateReply(this.getKeyStore(), this.getCacertsKeyStore(), alias, userCert, replyCerts);
        if (newChain != null) {
            keyStore.setKeyEntry(alias, privKey, keyPass != null ? keyPass : storePass, newChain);
            return true;
        }
        return false;
    }

    public boolean addTrustedCert(KeyStore keyStore, KeyStore caks, String alias, InputStream in) throws Exception {
        Certificate[] chain;
        if (keyStore.containsAlias(alias)) {
            throw new Exception("Certificate not imported - alias '" + alias + "' already exists");
        }
        X509Certificate cert = null;
        try {
            cert = (X509Certificate)((Object)this.generateCertificates(in));
        }
        catch (ClassCastException cce) {
            throw new Exception("Input is not an X.509 valid certificate");
        }
        catch (CertificateException ce) {
            throw new Exception("Input is not an X.509 valid certificate");
        }
        if (this.isSelfSigned(cert)) {
            cert.verify(cert.getPublicKey());
        }
        if ((chain = this.establishCertChain(keyStore, caks, null, cert)) != null) {
            keyStore.setCertificateEntry(alias, cert);
            return true;
        }
        return false;
    }

    public boolean isSelfSigned(X509Certificate cert) {
        return this.signedBy(cert, cert);
    }

    public boolean signedBy(X509Certificate end, X509Certificate ca) {
        if (!ca.getSubjectDN().equals(end.getIssuerDN())) {
            return false;
        }
        try {
            end.verify(ca.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Certificate getTrustedSigner(Certificate cert, KeyStore ks) throws Exception {
        if (ks.getCertificateAlias(cert) != null) {
            return cert;
        }
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String name = aliases.nextElement();
            Certificate trustedCert = ks.getCertificate(name);
            if (trustedCert == null) continue;
            try {
                cert.verify(trustedCert.getPublicKey());
                return trustedCert;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    public Certificate[] validateReply(KeyStore keyStore, KeyStore caks, String alias, Certificate userCert, Certificate[] replyCerts) throws Exception {
        int i;
        PublicKey userPubKey = userCert.getPublicKey();
        for (i = 0; i < replyCerts.length && !userPubKey.equals(replyCerts[i].getPublicKey()); ++i) {
        }
        if (i == replyCerts.length) {
            throw new Exception("Certificate reply does not contain public key for alias '" + alias + "'");
        }
        Certificate tmpCert = replyCerts[0];
        replyCerts[0] = replyCerts[i];
        replyCerts[i] = tmpCert;
        X509Certificate thisCert = (X509Certificate)replyCerts[0];
        for (i = 1; i < replyCerts.length - 1; ++i) {
            int j;
            for (j = i; j < replyCerts.length; ++j) {
                if (!this.signedBy(thisCert, (X509Certificate)replyCerts[j])) continue;
                tmpCert = replyCerts[i];
                replyCerts[i] = replyCerts[j];
                replyCerts[j] = tmpCert;
                thisCert = (X509Certificate)replyCerts[i];
                break;
            }
            if (j != replyCerts.length) continue;
            throw new Exception("Incomplete certificate chain in reply");
        }
        Certificate topCert = replyCerts[replyCerts.length - 1];
        Certificate root = this.getTrustedSigner(topCert, keyStore);
        if (root == null && caks != null) {
            root = this.getTrustedSigner(topCert, caks);
        }
        if (root == null) {
            throw new Exception("Top level certificate in reply is not trusted");
        }
        if (root != topCert) {
            Certificate[] tmpCerts = new Certificate[replyCerts.length + 1];
            System.arraycopy(replyCerts, 0, tmpCerts, 0, replyCerts.length);
            tmpCerts[tmpCerts.length - 1] = root;
            replyCerts = tmpCerts;
        }
        return replyCerts;
    }

    public Certificate[] establishCertChain(KeyStore keyStore, KeyStore caks, Certificate userCert, Certificate certToVerify) throws Exception {
        Vector<Certificate> chain;
        if (userCert != null) {
            PublicKey replyPubKey;
            PublicKey origPubKey = userCert.getPublicKey();
            if (!origPubKey.equals(replyPubKey = certToVerify.getPublicKey())) {
                throw new Exception("Public keys in reply and keystore don't match");
            }
            if (certToVerify.equals(userCert)) {
                throw new Exception("Certificate reply and certificate in keystore are identical");
            }
        }
        Hashtable<Principal, Vector<Certificate>> certs = null;
        if (keyStore.size() > 0) {
            certs = new Hashtable<Principal, Vector<Certificate>>(11);
            this.keystorecerts2Hashtable(keyStore, certs);
        }
        if (this.buildChain((X509Certificate)certToVerify, chain = new Vector<Certificate>(2), certs)) {
            Certificate[] newChain = new Certificate[chain.size()];
            int j = 0;
            for (int i = chain.size() - 1; i >= 0; --i) {
                newChain[j] = chain.elementAt(i);
                ++j;
            }
            return newChain;
        }
        throw new Exception("Failed to establish chain from reply");
    }

    public boolean buildChain(X509Certificate certToVerify, Vector<Certificate> chain, Hashtable<Principal, Vector<Certificate>> certs) {
        Principal issuer = certToVerify.getIssuerDN();
        if (this.isSelfSigned(certToVerify)) {
            chain.addElement(certToVerify);
            return true;
        }
        Vector<Certificate> vec = certs.get(issuer);
        if (vec == null) {
            return false;
        }
        Enumeration<Certificate> issuerCerts = vec.elements();
        while (issuerCerts.hasMoreElements()) {
            X509Certificate issuerCert = (X509Certificate)issuerCerts.nextElement();
            PublicKey issuerPubKey = issuerCert.getPublicKey();
            try {
                certToVerify.verify(issuerPubKey);
            }
            catch (Exception e) {
                continue;
            }
            if (!this.buildChain(issuerCert, chain, certs)) continue;
            chain.addElement(certToVerify);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyStore getCacertsKeyStore() throws Exception {
        String sep = File.separator;
        File file = new File(System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + "cacerts");
        if (!file.exists()) {
            return null;
        }
        KeyStore caks = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(file);
            caks = KeyStore.getInstance("JKS");
            caks.load(fis, null);
        }
        return caks;
    }

    public void keystorecerts2Hashtable(KeyStore ks, Hashtable<Principal, Vector<Certificate>> hash) throws Exception {
        Enumeration<String> aliases = ks.aliases();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            Certificate cert = ks.getCertificate(alias);
            if (cert == null) continue;
            Principal subjectDN = ((X509Certificate)cert).getSubjectDN();
            Vector<Certificate> vec = hash.get(subjectDN);
            if (vec == null) {
                vec = new Vector();
                vec.addElement(cert);
            } else if (!vec.contains(cert)) {
                vec.addElement(cert);
            }
            hash.put(subjectDN, vec);
        }
    }
}

