/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemLink;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.ejb.common.SessionControllerAdmin;
import java.util.Map;

public class DBDriverCheck
extends SystemCheck {
    private static final DBDriverCheck instance = new DBDriverCheck(CoreStatistic.getInstance().getGroup("Checks"));

    protected DBDriverCheck(Statistic parent) {
        super(parent);
    }

    public static DBDriverCheck getInstance() {
        return instance;
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        try {
            StatisticDetail detail = new StatisticDetail();
            String dbDriverName = SessionControllerAdmin.getSessionControllerAdmin("SystemStatistic").getDatabaseDriverName();
            SystemLink link = new SystemLink();
            link.setDescription("More information");
            link.setLink(SystemStatistic.getSupportLink((String)"drizzle"));
            detail.link = link;
            detail.title = "Result";
            if (dbDriverName != null && dbDriverName.equalsIgnoreCase("Drizzle-JDBC")) {
                detail.detail = "The used jdbc driver is not optimal, please switch to the offical mysql jdbc driver";
                this.performanceStatus = Statistic.PerformanceStatus.WARN;
            } else {
                detail.detail = "The used jdbc driver is ok";
                this.performanceStatus = Statistic.PerformanceStatus.OK;
            }
            detail.performanceStatus = this.performanceStatus;
            this.details.add(detail);
        }
        catch (Exception e) {
            throw new SystemTaskException("Error getting jdbc driver information", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Checking database driver, if drizzle jdbc driver is used.";
    }

    public String getShortDescription() {
        return "Checking database driver";
    }
}

