/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemTaskException;
import agorum.commons.system.Solr;
import agorum.roi.ejb.common.ConnectionUtils;
import agorum.roi.statistic.RoiCheckSuite;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class FileSpaceCheck
extends RoiCheckSuite {
    private static final FileSpaceCheck instance = new FileSpaceCheck(CoreStatistic.getInstance().getGroup("Checks"));
    private static final double ONE_MB = 1048576.0;

    protected FileSpaceCheck(Statistic parent) {
        super(parent);
    }

    public static FileSpaceCheck getInstance() {
        return instance;
    }

    protected void initialize(Map<String, Object> args) throws SystemTaskException {
        this.addCheck("Counting documents", () -> {
            try {
                String query = "SELECT count(*), sum(b.contentsize) FROM globalobject a, fileobject b WHERE a.id=b.id and a.expirationdate = 0 and a.systemflags & 128 = 0;";
                long sum = 0L;
                Number size = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = rs.getLong(1);
                        size = (Number)rs.getObject(2);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (size == null) {
                    sum = 0L;
                    size = 0;
                }
                String formatted = String.format("%.02f", ((Number)size).doubleValue() / 1048576.0);
                this.ok("Sum: " + sum + " documents, used space: " + formatted + " MB");
            }
            catch (Exception e) {
                this.fail("Unable to count documents", e);
            }
        });
        this.addCheck("Counting documents in recycle bin", () -> {
            try {
                String query = "SELECT count(*), sum(b.contentsize) FROM globalobject a, fileobject b WHERE a.id=b.id and a.expirationdate != 0;";
                long sum = 0L;
                Number size = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = rs.getLong(1);
                        size = (Number)rs.getObject(2);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (size == null) {
                    sum = 0L;
                    size = 0;
                }
                String formatted = String.format("%.02f", ((Number)size).doubleValue() / 1048576.0);
                this.ok("Sum: " + sum + " documents, used space: " + formatted + " MB");
            }
            catch (Exception e) {
                this.fail("Unable to count documents in recycle bin", e);
            }
        });
        this.addCheck("Counting previews", () -> {
            try {
                String query = "SELECT count(*), sum(a.contentsize) FROM fileobject a, previewimage b WHERE a.id=b.id;";
                long sum = 0L;
                Number size = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = rs.getLong(1);
                        size = (Number)rs.getObject(2);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (size == null) {
                    sum = 0L;
                    size = 0;
                }
                String formatted = String.format("%.02f", ((Number)size).doubleValue() / 1048576.0);
                this.ok("Sum: " + sum + " previews, used space: " + formatted + " MB");
            }
            catch (Exception e) {
                this.fail("Unable to count previews", e);
            }
        });
        this.addCheck("Counting mails", () -> {
            try {
                String query = "SELECT count(*), sum(b.contentsize) FROM globalobject a, folderdocumentobject b WHERE a.id=b.id;";
                long sum = 0L;
                Number size = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = rs.getLong(1);
                        size = (Number)rs.getObject(2);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (size == null) {
                    sum = 0L;
                    size = 0;
                }
                String formatted = String.format("%.02f", ((Number)size).doubleValue() / 1048576.0);
                this.ok("Sum: " + sum + " mails, used space: " + formatted + " MB");
            }
            catch (Exception e) {
                this.fail("Unable to count mails", e);
            }
        });
        this.addCheck("Counting folders", () -> {
            try {
                String query = "SELECT count(*) FROM globalobject a, folderobject b WHERE a.id=b.id;";
                Number sum = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = (Number)rs.getObject(1);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (sum == null) {
                    sum = 0;
                }
                this.ok("Sum: " + sum + " folders");
            }
            catch (Exception e) {
                this.fail("Unable to count folders", e);
            }
        });
        if (!Solr.isInstalled()) {
            this.addCheck("Analyzing index", () -> {
                try {
                    String query = "select sum(length) from index_document_t;";
                    Number sum = 0;
                    try (Connection connection = new ConnectionUtils().getConnection();
                         PreparedStatement pstmt = connection.prepareStatement(query);
                         ResultSet rs = pstmt.executeQuery();){
                        if (rs.next()) {
                            sum = (Number)rs.getObject(1);
                        }
                    }
                    catch (SQLException e) {
                        this.fail("Error executing database query", e);
                    }
                    if (sum == null) {
                        sum = 0;
                    }
                    this.ok(String.format("Index size: %.02f MB", ((Number)sum).doubleValue() / 1048576.0));
                }
                catch (Exception e) {
                    this.fail("Unable to analyze index", e);
                }
            });
        }
        this.addCheck("Analyzing index contents", () -> {
            try {
                String query = "select sum(length(content)) from indexedcontentstore;";
                Number sum = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = (Number)rs.getObject(1);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (sum == null) {
                    sum = 0;
                }
                this.ok(String.format("Index content size: %.02f MB", ((Number)sum).doubleValue() / 1048576.0));
            }
            catch (Exception e) {
                this.fail("Unable to analyze content", e);
            }
        });
        this.addCheck("Analyzing non-indexed contents", () -> {
            try {
                String query = "select sum(length(content)) from nonindexedcontentstore;";
                Number sum = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = (Number)rs.getObject(1);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (sum == null) {
                    sum = 0;
                }
                this.ok(String.format("Non-indexed content size: %.02f MB", ((Number)sum).doubleValue() / 1048576.0));
            }
            catch (Exception e) {
                this.fail("Unable to analyze content", e);
            }
        });
        this.addCheck("Analyzing unknown format contents", () -> {
            try {
                String query = "select sum(length(content)) from unknownformatcontentstore;";
                Number sum = 0;
                try (Connection connection = new ConnectionUtils().getConnection();
                     PreparedStatement pstmt = connection.prepareStatement(query);
                     ResultSet rs = pstmt.executeQuery();){
                    if (rs.next()) {
                        sum = (Number)rs.getObject(1);
                    }
                }
                catch (SQLException e) {
                    this.fail("Error executing database query", e);
                }
                if (sum == null) {
                    sum = 0;
                }
                this.ok(String.format("Unknown format content size: %.02f MB", ((Number)sum).doubleValue() / 1048576.0));
            }
            catch (Exception e) {
                this.fail("Unable to analyze content", e);
            }
        });
    }

    public String getDescription() {
        return "Analyzing file space";
    }

    public String getShortDescription() {
        return "File space";
    }
}

