/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemTaskException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class IOSizeCheck
extends SystemCheck {
    private String path;
    private static Map<String, IOSizeCheck> instances = new HashMap<String, IOSizeCheck>();
    private String ident;

    protected IOSizeCheck(Statistic parent, String ident, String path) {
        super(ident, parent);
        this.ident = ident;
        this.path = path;
    }

    public static IOSizeCheck getInstance(String ident, String path) {
        IOSizeCheck instance = instances.get(ident);
        if (instance == null) {
            instance = new IOSizeCheck(CoreStatistic.getInstance().getGroup("Checks"), ident, path);
            instances.put(ident, instance);
        }
        return instance;
    }

    public void removeInstance() {
        instances.remove(this.ident);
        this.removeFromParent();
    }

    private Statistic.PerformanceStatus checkFreeSpace() {
        StatisticDetail detail = new StatisticDetail();
        this.details.add(detail);
        File f = new File(this.path);
        if (!f.exists()) {
            f.mkdirs();
        }
        detail.unit = "MB";
        detail.actualValue = (double)f.getFreeSpace() / 1024.0 / 1024.0;
        detail.referenceValue = 20480.0;
        detail.title = "Info";
        detail.detail = "Free disk space in " + this.path;
        if (f.getFreeSpace() < 0x200000000L) {
            detail.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
            this.error().detail((Object)"Disk space is too low").send("Not enough space on device");
            return Statistic.PerformanceStatus.CRITICAL;
        }
        if (f.getFreeSpace() < 0x500000000L) {
            detail.performanceStatus = Statistic.PerformanceStatus.WARN;
            this.error().detail((Object)"Disk space is getting to low").send("Not enough space on device");
            return Statistic.PerformanceStatus.WARN;
        }
        detail.performanceStatus = Statistic.PerformanceStatus.OK;
        return Statistic.PerformanceStatus.OK;
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        try {
            Statistic.PerformanceStatus tmpStatus = this.checkFreeSpace();
            if (tmpStatus == Statistic.PerformanceStatus.CRITICAL) {
                this.performanceStatus = tmpStatus;
                return;
            }
            this.performanceStatus = tmpStatus;
        }
        catch (Exception e) {
            throw new SystemTaskException("Error performing IO benchmark", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Checking free dsisk space of the agorum core server (" + this.ident + ")";
    }

    public String getShortDescription() {
        return "Disk space (" + this.ident + ")";
    }
}

