/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.check;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.StatisticDetail;
import agorum.commons.statistic.SystemCheck;
import agorum.commons.statistic.SystemLink;
import agorum.commons.statistic.SystemStatistic;
import agorum.commons.statistic.SystemTaskException;
import agorum.roi.statistic.JBossUtils;
import agorum.roi.statistic.JavaUtils;
import java.util.Map;

public class JMSCheck
extends SystemCheck {
    private static final JMSCheck instance = new JMSCheck(CoreStatistic.getInstance().getGroup("Checks"));

    protected JMSCheck(Statistic parent) {
        super(parent);
    }

    public static JMSCheck getInstance() {
        return instance;
    }

    public void performCheck(Map<String, Object> args) throws SystemTaskException {
        StatisticDetail detail = new StatisticDetail();
        this.details.add(detail);
        try {
            long maxMemory = JavaUtils.getMemory("-xmx");
            long highMemoryMark = JBossUtils.getJmsHighMemoryMark();
            long maxMemoryMark = JBossUtils.getJmsMaxMemoryMark();
            detail.title = "Result MaxMemoryMark";
            long diff = maxMemoryMark - maxMemory;
            if (Math.abs(diff) > 524288000L && diff > 0L) {
                this.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
                detail.detail = "The JMS MaxMemoryMark setting is too high, it should not exceed the -Xmx value of the JVM";
            }
            if (Math.abs(diff) > 524288000L && diff < 0L) {
                this.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
                detail.detail = "The JMS MaxMemoryMark setting is too low, it should be the same as the -Xmx value of the JVM";
            }
            if (Math.abs(diff) > 0xC800000L && diff > 0L) {
                this.performanceStatus = Statistic.PerformanceStatus.WARN;
                detail.detail = "The JMS MaxMemoryMark setting is slightly too high, it should not exceed the -Xmx value of the JVM";
            }
            if (Math.abs(diff) < 0xC800000L && diff < 0L) {
                this.performanceStatus = Statistic.PerformanceStatus.WARN;
                detail.detail = "The JMS MaxMemoryMark setting is slightly too low, it should be the same as the -Xmx value of the JVM";
            } else {
                this.performanceStatus = Statistic.PerformanceStatus.OK;
                detail.detail = "The JMS MaxMemoryMark setting is ok";
            }
            detail.actualValue = new Double((double)maxMemoryMark / 1024.0 / 1024.0);
            detail.unit = "MB";
            detail.referenceValue = new Double((double)maxMemory / 1024.0 / 1024.0);
            detail.performanceStatus = this.performanceStatus;
            SystemLink link = new SystemLink();
            link.setDescription("More info");
            link.setLink(SystemStatistic.getSupportLink((String)"jms"));
            detail.link = link;
            detail = new StatisticDetail();
            this.details.add(detail);
            detail.title = "Result HighMemoryMark";
            diff = highMemoryMark - maxMemory;
            if (diff > 0L) {
                this.performanceStatus = Statistic.PerformanceStatus.CRITICAL;
                detail.detail = "The JMS HighMemoryMark setting is too high, it must not exceed the -Xmx value of the JVM";
            } else if (diff < 0L) {
                this.performanceStatus = Statistic.PerformanceStatus.WARN;
                detail.detail = "The JMS HighMemoryMark setting is too low, it should match the -Xmx value of the JVM";
            } else {
                this.performanceStatus = Statistic.PerformanceStatus.OK;
                detail.detail = "The JMS HighMemoryMark setting is ok";
            }
            detail.actualValue = new Double((double)highMemoryMark / 1024.0 / 1024.0);
            detail.unit = "MB";
            detail.referenceValue = new Double((double)maxMemory / 1024.0 / 1024.0);
            detail.performanceStatus = this.performanceStatus;
            link = new SystemLink();
            link.setDescription("More info");
            link.setLink(SystemStatistic.getSupportLink((String)"jms"));
            detail.link = link;
        }
        catch (Exception e) {
            throw new SystemTaskException("Error getting SuperObjectCache info", (Throwable)e);
        }
    }

    public String getDescription() {
        return "Checking JMS settings";
    }

    public String getShortDescription() {
        return "JMS";
    }
}

