/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.measurement;

import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.measurement.Histogram;
import agorum.commons.statistic.measurement.WatchableMeasurement;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.jmx.adaptor.control.Server;
import org.jboss.mq.server.JMSDestinationManager;
import org.jboss.mq.server.MessageCache;
import org.jboss.util.threadpool.BasicThreadPool;
import org.jboss.util.threadpool.BlockingMode;

public class JmsMessageCache
extends Histogram {
    private static final long JMS_MESSAGECACHE_CRITICAL = 1000000L;

    public JmsMessageCache() {
        super(false, "JMS Message Cache");
        try {
            MBeanServer server = Server.getMBeanServer();
            JMSDestinationManager jmsServer = (JMSDestinationManager)server.getAttribute(new ObjectName("jboss.mq:service=DestinationManager"), "Interceptor");
            BasicThreadPool threadPool = (BasicThreadPool)jmsServer.getThreadPool();
            threadPool.setBlockingMode(BlockingMode.WAIT);
        }
        catch (Exception e) {
            CoreStatistic.getInstance().error().sticky("JMS_THREADPOOL_INIT").exception((Throwable)e).send("Could not setup JMS Threadpool");
        }
    }

    public long getValue() {
        try {
            MBeanServer server = Server.getMBeanServer();
            JMSDestinationManager jmsServer = (JMSDestinationManager)server.getAttribute(new ObjectName("jboss.mq:service=DestinationManager"), "Interceptor");
            MessageCache messageCache = jmsServer.getMessageCache();
            return messageCache.getTotalCacheSize();
        }
        catch (Exception e) {
            CoreStatistic.getInstance().error().exception((Throwable)e).send("Could not get JMS MessageCache");
            return 0L;
        }
    }

    public long getMaximum() {
        return this.getValue();
    }

    public void onTick(Statistic parent) {
        super.onTick(parent);
        this.set(this.getValue());
    }

    public void loadDefaults() {
        this.addCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.GREATER, 1000000L));
    }
}

