/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.measurement;

import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.measurement.Histogram;
import agorum.commons.statistic.measurement.WatchableMeasurement;
import java.io.File;

public class ServerDiskSpaceAgorum
extends Histogram {
    private static final long MEGABYTE = 0x100000L;
    private static final long FREE_MEMORY_CRITICAL = 1024L;
    public static final String SERVER_HOME_ENV = "jboss.server.home.dir";
    private String home;

    public ServerDiskSpaceAgorum() {
        super(false, "Server Free Disk Space (agorum base)", "MB");
        String serverHome = System.getProperty(SERVER_HOME_ENV);
        this.home = serverHome + "/../../..";
    }

    public long getValue() {
        return new File(this.home).getUsableSpace() / 0x100000L;
    }

    public long getMaximum() {
        return new File(this.home).getTotalSpace() / 0x100000L;
    }

    public void onTick(Statistic parent) {
        super.onTick(parent);
        this.set(this.getValue());
    }

    public void loadDefaults() {
        this.addCondition(new WatchableMeasurement.Condition("value", WatchableMeasurement.Operator.LESS, 1024L));
    }
}

