/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.measurement;

import agorum.commons.cron.Trace;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.measurement.Measurement;
import agorum.commons.string.SerializableMap;
import agorum.roi.statistic.AgorumProcessList;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ServerUpTime
extends Measurement {
    private static final Instant START_TIME = Instant.now();

    public ServerUpTime() {
        super(false, "Server Uptime");
    }

    public long getValue() {
        if (Trace.isEnabled()) {
            AgorumProcessList.getInstance().warning().sticky("TRACE_ENABLED").send("Attention tracing is active, this leads to massive performance problems!");
        } else {
            AgorumProcessList.getInstance().clearStickyLogEntry("TRACE_ENABLED");
        }
        return Duration.between(START_TIME, Instant.now()).toMillis();
    }

    public Map<String, Object> getPropertyMap(boolean fullDetails) {
        Duration dur = Duration.ofMillis(this.getValue());
        long totalSecs = dur.getSeconds();
        long secs = totalSecs % 60L;
        long mins = totalSecs / 60L % 60L;
        long hours = totalSecs / 3600L % 24L;
        long days = totalSecs / 86400L;
        StringBuilder sb = new StringBuilder();
        sb.append(days);
        sb.append(" d, ");
        sb.append(hours);
        sb.append(" h, ");
        sb.append(mins);
        sb.append(" m, ");
        sb.append(secs);
        sb.append(" s");
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("name", this.getName());
        pmap.put("value", sb.toString());
        pmap.put("subSystem", this.getSubSystem());
        return pmap;
    }

    public void add(long value) {
    }

    public void set(long value) {
    }

    public void reset() {
    }

    public long getMinimum() {
        return this.getValue();
    }

    public long getMaximum() {
        return this.getValue();
    }

    public long getLastChangeTime() {
        return System.currentTimeMillis();
    }

    public boolean isCounter() {
        return true;
    }

    public void onTick(Statistic parent) {
    }

    public SerializableMap serialize() {
        return null;
    }

    public void deserialize(SerializableMap data) {
    }

    public void loadDefaults() {
    }

    public List<String> listFields() {
        return null;
    }

    public long getField(String fieldName, long _default) {
        return 0L;
    }
}

