/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.searchengine;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.commons.statistic.SystemLink;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.metadb.common.MetaDbAccessor;
import agorum.roi.metadb.util.MetaDbUtil;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.statistic.check.IOSizeCheck;
import agorum.roi.statistic.searchengine.DocumentServiceSearchEngineIndexSystemStatistic;
import agorum.roi.statistic.searchengine.SearchEngineStatistic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public class SearchEngineSystemConfig
extends SystemConfig {
    private static final SearchEngineSystemConfig instance = new SearchEngineSystemConfig(SearchEngineStatistic.getInstance().getGroup("Configurations"));
    private static final String BASE_KEY_SEARCH = "MAIN_MODULE_MANAGEMENT/textindexservice/control";

    protected SearchEngineSystemConfig(Statistic parent) {
        super(parent);
    }

    public static SearchEngineSystemConfig getInstance() {
        return instance;
    }

    public String getDescription() {
        return "Index configuration";
    }

    public String getShortDescription() {
        return "Index configuration";
    }

    public void formButton(Map<String, Object> args) {
        block33: {
            try {
                if (!SearchEngineSystemConfig.isButton((String)"save", args)) break block33;
                Boolean exportIndex = (Boolean)args.get("exportIndex");
                if (exportIndex != null && exportIndex.booleanValue()) {
                    String path = args.get("exportIndexPath") + "";
                    long indexSize = 0L;
                    SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin("SystemStatistic");
                    try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(new DocumentServiceSearchEngineIndexSystemStatistic());){
                        indexSize = indexHandler.getIndexSize(sessionController, null);
                    }
                    File f = new File(path);
                    f.mkdirs();
                    long minSize = indexSize * 2L + 0x140000000L;
                    if (f.getFreeSpace() < minSize) {
                        throw new Exception("Insufficient disk space at " + f.getAbsolutePath() + ", you need at least " + minSize / 1024L / 1024L / 1024L + " GB");
                    }
                }
                MetaDbAccessor mdba = new MetaDbAccessor(this.getName());
                try (MetaDbUtil mdbu = mdba.getWriteUtil(BASE_KEY_SEARCH);){
                    String configPath;
                    String searchEngine;
                    mdbu.setString("textindexenabled", args.get("indexEnabled").toString());
                    if (args.get("rtIndexEnabled") != null) {
                        mdbu.setString("realtimeindexenabled", args.get("rtIndexEnabled").toString());
                    }
                    if ((searchEngine = mdbu.getString("SearchEngine", "lucene_1_9")).toLowerCase().startsWith("lucene_")) {
                        configPath = "syncdata/indexer/";
                        mdbu.setString("realtimeindexenabled", args.get("rtIndexEnabled").toString());
                        mdbu.setString("syncdata/indexer/DoExportIndexToFS", args.get("exportIndex").toString());
                        if (((Boolean)args.get("exportIndex")).booleanValue()) {
                            String exportIndexPath = args.get("exportIndexPath").toString();
                            mdbu.setString("syncdata/indexer/ExportIndexDirectory", exportIndexPath);
                            IOSizeCheck size = IOSizeCheck.getInstance("index", null);
                            if (size != null) {
                                size.removeInstance();
                            }
                            IOSizeCheck.getInstance("index", exportIndexPath);
                        }
                    } else {
                        configPath = "solr/";
                    }
                    mdbu.setString(configPath + "MaxDocumentsByTransaction", args.get("documentsPerTransaction").toString());
                    mdbu.setString(configPath + "WaitTime", args.get("minWaitTime").toString());
                    mdbu.setString(configPath + "MaxWaitTime", args.get("maxWaitTime").toString());
                    mdbu.setString(configPath + "GetDocumentTextTimeoutInMS", args.get("docTextTimeout").toString());
                    mdbu.setString("MaxDocumentSizeForContentExtraction", args.get("maxDocSize").toString());
                    mdbu.setString("ValidationLevel", args.get("validationLevel").toString());
                    mdbu.commit();
                }
            }
            catch (Exception e) {
                this.error(e);
            }
        }
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        MetaDbAccessor mdba = new MetaDbAccessor(this.getName());
        ArrayList<FormItem> configTypes = new ArrayList<FormItem>();
        try (MetaDbUtil mdbu = mdba.getReadUtil(BASE_KEY_SEARCH);){
            String configPath;
            FormItem indexEnabled = new FormItem("indexEnabled", (Object)mdbu.getBoolean("textindexenabled", true), FormItem.ConfigDataType.BOOL);
            indexEnabled.setDescription("Enable/Disable index function system wide");
            configTypes.add(indexEnabled);
            String searchEngine = mdbu.getString("SearchEngine", "lucene_1_9");
            String text = "The current search engine is: " + searchEngine;
            SystemLink link = new SystemLink();
            link.setDescription("Switch search engine/recreate index");
            link.setLink("/roiwebui/roiwebui_module/tools/RecreateIndex.jsp");
            FormItem engineInfo = new FormItem("engineInfo", (Object)text, FormItem.ConfigDataType.STATIC);
            engineInfo.setDescription("Search engine information");
            engineInfo.setLink(link);
            configTypes.add(engineInfo);
            if (searchEngine.toLowerCase().startsWith("lucene_")) {
                configPath = "syncdata/indexer/";
                FormItem rtIndexEnabled = new FormItem("rtIndexEnabled", (Object)mdbu.getBoolean("realtimeindexenabled", true), FormItem.ConfigDataType.BOOL);
                rtIndexEnabled.setDescription("Enable/Disable realtime index function (only for lucene)");
                configTypes.add(rtIndexEnabled);
                SessionController sessionController = SessionControllerAdmin.getSessionControllerAdmin("SystemStatistic");
                long indexSize = 0L;
                try (IndexHandlerInterface indexHandler = IndexHelper.getIndexHandler(new DocumentServiceSearchEngineIndexSystemStatistic());){
                    indexSize = indexHandler.getIndexSize(sessionController, null);
                }
                long minSize = indexSize * 2L + 0x140000000L;
                FormItem exportIndex = new FormItem("exportIndex", (Object)mdbu.getBoolean("syncdata/indexer/DoExportIndexToFS", false), FormItem.ConfigDataType.BOOL);
                exportIndex.setDescription("Export index to file system (improves performance, you need at least " + minSize / 1024L / 1024L / 1024L + " GB)");
                configTypes.add(exportIndex);
                FormItem exportIndexPath = new FormItem("exportIndexPath", (Object)mdbu.getString("syncdata/indexer/ExportIndexDirectory", "/opt/agorum/index/exported_index"), FormItem.ConfigDataType.STRING);
                exportIndexPath.setDescription("Directory to export the index to (the index export will be done in background)");
                configTypes.add(exportIndexPath);
            } else {
                configPath = "solr/";
            }
            FormItem documentsPerTransaction = new FormItem("documentsPerTransaction", (Object)mdbu.getLong(configPath + "MaxDocumentsByTransaction", 500L), FormItem.ConfigDataType.LONG);
            documentsPerTransaction.setDescription("Amount of documents that should be indexed in one transaction");
            configTypes.add(documentsPerTransaction);
            FormItem minWaitTime = new FormItem("minWaitTime", (Object)mdbu.getLong(configPath + "WaitTime", 100L), FormItem.ConfigDataType.LONG);
            minWaitTime.setDescription("Minimum time to wait in ms, before starting an indexing run");
            configTypes.add(minWaitTime);
            FormItem maxWaitTime = new FormItem("maxWaitTime", (Object)mdbu.getLong(configPath + "MaxWaitTime", 60000L), FormItem.ConfigDataType.LONG);
            maxWaitTime.setDescription("Maximum time to wait in ms, before starting an indexing run");
            configTypes.add(maxWaitTime);
            FormItem docTextTimeout = new FormItem("docTextTimeout", (Object)mdbu.getLong(configPath + "GetDocumentTextTimeoutInMS", 900000L), FormItem.ConfigDataType.LONG);
            docTextTimeout.setDescription("Timeout in ms for converting documents to text");
            docTextTimeout.setValidationJs("v > 60000");
            configTypes.add(docTextTimeout);
            FormItem maxDocSize = new FormItem("maxDocSize", (Object)mdbu.getLong("MaxDocumentSizeForContentExtraction", 0x1400000L), FormItem.ConfigDataType.LONG);
            maxDocSize.setDescription("Size limit (in bytes) for documents whose content should be extracted. If a file is larger, no content will be extracted, to prevent out-of-memory errors. (-1 means unlimited)");
            configTypes.add(maxDocSize);
            FormItem validationLevel = new FormItem("validationLevel", (Object)mdbu.getString("ValidationLevel", "lenient"), FormItem.ConfigDataType.STRING);
            validationLevel.setDescription("Validation level for metadata. Possible values are 'strict' (default when installed with agorum core version >= 9.5.1): Allow no mixed types; 'lenient' (default when installed with agorum core version < 9.5.1): Allow mixed types if automatic conversion is possible, but log a warning; 'none': Allow mixed types if automatic conversion is possible.");
            configTypes.add(validationLevel);
        }
        catch (Exception e) {
            SearchEngineStatistic.getInstance().error(e, "Error loading configuration");
        }
        return configTypes;
    }
}

