/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.statistic.thread;

import agorum.commons.forms.FormItem;
import agorum.commons.statistic.CoreStatistic;
import agorum.commons.statistic.Statistic;
import agorum.commons.statistic.SystemConfig;
import agorum.roi.statistic.thread.ThreadPool;
import java.io.File;
import java.io.FileInputStream;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ThreadPoolConfig
extends SystemConfig {
    private static final ThreadPoolConfig instance = new ThreadPoolConfig(CoreStatistic.getInstance().getGroup("Configurations"));

    protected ThreadPoolConfig(Statistic parent) {
        super(parent);
    }

    public static ThreadPoolConfig getInstance() {
        return instance;
    }

    public Collection<FormItem> formCreate(Map<String, Object> formData) {
        Map<String, Integer> defaults;
        try {
            defaults = ThreadPool.getDefaults(ThreadPool.getXMLDocument(new FileInputStream(ThreadPool.getServerXML())));
        }
        catch (Exception e) {
            this.error("Unable to parse default values", e);
            return null;
        }
        FormItem.Collection fields = new FormItem.Collection();
        fields.intField("maxHttpThreads").value((Object)defaults.get("httpMaxThreads")).description("Amount of threads, that handle incoming HTTP-requests").allowBlank(false).add();
        fields.intField("maxHttpSpareThreads").value((Object)defaults.get("httpMaxSpareThreads")).description("The maximum number of unused request processing threads that will be allowed to exist until the thread pool starts stopping the unnecessary threads").allowBlank(false).add();
        fields.intField("minHttpSpareThreads").value((Object)defaults.get("httpMinSpareThreads")).description("The number of request processing threads that will be created when this Connector is first started. The connector will also make sure it has the specified number of idle processing threads available.").allowBlank(false).add();
        fields.intField("maxHttpsThreads").value((Object)defaults.get("httpsMaxThreads")).description("Amount of threads, that handle incoming HTTPS-requests").allowBlank(false).add();
        fields.intField("maxHttpsSpareThreads").value((Object)defaults.get("httpsMaxSpareThreads")).description("The maximum number of unused request processing threads that will be allowed to exist until the thread pool starts stopping the unnecessary threads").allowBlank(false).add();
        fields.intField("minHttpsSpareThreads").value((Object)defaults.get("httpsMinSpareThreads")).description("The number of request processing threads that will be created when this Connector is first started. The connector will also make sure it has the specified number of idle processing threads available.").allowBlank(false).add();
        return fields.getCollection();
    }

    public void formButton(Map<String, Object> args) {
        try {
            if (ThreadPoolConfig.isButton((String)"save", args)) {
                String startupUpdatePath = System.getProperty("jboss.server.home.dir") + "/../../../startup_updates/jboss/server/default/deploy/jbossweb-tomcat50.sar";
                File dir = new File(startupUpdatePath).getAbsoluteFile();
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File newServerXML = new File(dir, "server.xml");
                Document doc = ThreadPool.getXMLDocument(new FileInputStream(ThreadPool.getServerXML()));
                Node httpConnector = ThreadPool.getNode(doc, "//Connector[not(@scheme) or @scheme!=\"https\"][not(@protocol) or @protocol=\"HTTP/1.1\"]");
                Node httpsConnector = ThreadPool.getNode(doc, "//Connector[@scheme=\"https\"]");
                if (httpConnector.hasAttributes()) {
                    httpConnector.getAttributes().getNamedItem("maxThreads").setNodeValue(String.valueOf(args.get("maxHttpThreads")));
                    httpConnector.getAttributes().getNamedItem("minSpareThreads").setNodeValue(String.valueOf(args.get("minHttpSpareThreads")));
                    httpConnector.getAttributes().getNamedItem("maxSpareThreads").setNodeValue(String.valueOf(args.get("maxHttpSpareThreads")));
                }
                if (httpsConnector.hasAttributes()) {
                    httpsConnector.getAttributes().getNamedItem("maxThreads").setNodeValue(String.valueOf(args.get("maxHttpsThreads")));
                    httpsConnector.getAttributes().getNamedItem("minSpareThreads").setNodeValue(String.valueOf(args.get("minHttpsSpareThreads")));
                    httpsConnector.getAttributes().getNamedItem("maxSpareThreads").setNodeValue(String.valueOf(args.get("maxHttpsSpareThreads")));
                }
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                StreamResult result = new StreamResult(newServerXML);
                DOMSource source = new DOMSource(doc);
                transformer.transform(source, result);
                this.setPromptAfterAction("Server configuration saved successfully. The server needs to be restarted for the changes to take effect.");
            }
        }
        catch (Exception e) {
            this.error(e);
        }
    }

    public String getDescription() {
        return "Configure the amount of threads, that can handle incoming requests";
    }

    public String getShortDescription() {
        return "Thread pool configuration";
    }
}

