/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.test;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.documentservice.client.common.DocumentServiceWSUtils;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.SessionController;
import java.io.File;
import java.util.Date;

public class TestConverters {
    private String[] toFormats = new String[]{"HTML", "PDF", "TXT"};

    private void testConverters(SessionController sessionController, String testDocsFolderPath) throws Throwable {
        File testDocsFolder = new File(testDocsFolderPath);
        File[] testDocs = testDocsFolder.listFiles();
        if (testDocs != null) {
            DocumentServiceWSUtils documentService = new DocumentServiceWSUtils();
            MetaDb metaDb = sessionController.getMetaDbInstance();
            int toFormatsLen = this.toFormats.length;
            for (int j = 0; j < toFormatsLen; ++j) {
                File toFolder = new File(testDocsFolder, this.toFormats[j]);
                toFolder.mkdirs();
            }
            long tStart = new Date().getTime();
            int testDocsLen = testDocs.length;
            for (int i = 0; i < testDocsLen; ++i) {
                String testDocName = testDocs[i].getName();
                String testDocExtension = testDocName.substring(testDocName.lastIndexOf(".") + 1);
                for (int j = 0; j < toFormatsLen; ++j) {
                    String converterName = "convert" + testDocExtension.toUpperCase() + "2" + this.toFormats[j];
                    try {
                        boolean isAvail = documentService.checkServiceAvailable(metaDb, documentService.getDefaultServer(), converterName);
                        if (isAvail) {
                            File outputFile = new File(testDocsFolderPath + "/" + this.toFormats[j], testDocName + "." + this.toFormats[j]);
                            System.out.println("Convert '" + testDocName + "' with converter '" + converterName + "' to new file '" + outputFile.getAbsolutePath() + "'");
                            documentService.convertFile(metaDb, documentService.getDefaultServer(), converterName, testDocs[i], outputFile);
                            continue;
                        }
                        System.out.println("No converter '" + converterName + "' found for '" + testDocName + "'");
                        continue;
                    }
                    catch (Throwable t) {
                        t.printStackTrace(System.err);
                    }
                }
            }
            System.out.println("\nTime: " + (new Date().getTime() - tStart));
        }
    }

    public static void main(String[] args) {
        SessionController sessionController = null;
        try {
            CredentialObject credential = new CredentialObject();
            credential.setUserName("roi");
            credential.setPassWord("roi");
            credential.setModulInfo("CreateNoteObject");
            sessionController = SessionController.connect(credential);
            if (sessionController != null) {
                TestConverters tc = new TestConverters();
                tc.testConverters(sessionController, "c:\\Austausch\\temp\\testdoc1");
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }
}

