/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.timephasedaction.actions;

import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AccessLevel;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.timephasedaction.actions.BaseAction;

public class MoveTo
extends BaseAction {
    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        String accessLevelSource = this.getMethodParameter(sessionController, "AccessLevelSource", action);
        return clientBean.checkEffectiveAccess(AccessLevel.getAccessLevel(accessLevelSource));
    }

    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, String classname, String action) throws Exception {
        boolean bRet = true;
        return bRet;
    }

    @Override
    public void invoke(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        if (clientBean != null && action != null) {
            String destinationFolder = this.getMethodParameter(sessionController, "DestinationFolder", action);
            String sourceFolderDiff = this.getMethodParameter(sessionController, "SourceFolderDiff", action);
            FolderObjectClientBean destinationFolderObject = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(destinationFolder);
            if (destinationFolderObject != null) {
                FolderObjectClientBean sourceFolderDiffObject = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(sourceFolderDiff);
                String myMovePath = destinationFolder;
                RoiFileSystem rfs = new RoiFileSystem(sessionController);
                FolderObjectClientBean parent = null;
                try {
                    parent = clientBean.getParents()[0];
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (parent != null) {
                    stat.error().object((SystemObjectReference)clientBean).send("Moving from " + parent.getID() + " to " + destinationFolderObject.getID());
                    if (sourceFolderDiffObject != null) {
                        String p1;
                        String[] allPath = clientBean.getAllFolderPath(sourceFolderDiffObject.getId());
                        if (allPath != null && allPath.length > 0) {
                            p1 = sourceFolderDiff + allPath[0];
                            String p = p1.substring(0, p1.lastIndexOf("/"));
                            parent = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(p);
                        }
                        if (allPath != null && allPath.length > 0) {
                            p1 = allPath[0];
                            if (!myMovePath.endsWith("/") && !p1.startsWith("/")) {
                                myMovePath = myMovePath + "/";
                            }
                            myMovePath = myMovePath + p1;
                            myMovePath = myMovePath.substring(0, myMovePath.lastIndexOf("/"));
                            destinationFolderObject = rfs.createFullpath(myMovePath, true);
                        }
                    } else {
                        stat.info().object((SystemObjectReference)clientBean).send("sourceFolderDiffObject not found: " + sourceFolderDiff);
                    }
                    if (!destinationFolderObject.hasItem(clientBean.getName())) {
                        if (stat.logInfo()) {
                            stat.info().object((SystemObjectReference)clientBean).send("moving from: " + parent.getID() + " to " + destinationFolderObject.getID());
                        }
                        rfs.move(parent, destinationFolderObject, clientBean);
                    } else {
                        stat.warning().object((SystemObjectReference)clientBean).send("object with same name already exists in destination: " + clientBean.getName() + ", skipping");
                    }
                } else {
                    stat.warning().object((SystemObjectReference)clientBean).send("object has no parent, skipping");
                }
            } else {
                stat.error().object((SystemObjectReference)clientBean).send("Destination folder not found: " + destinationFolder);
            }
        }
    }
}

