/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.timephasedaction.actions;

import agorum.commons.statistic.SystemObjectReference;
import agorum.commons.statistic.SystemStatistic;
import agorum.roi.ejb.audit.AuditUtil;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AccessLevel;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.OpenFileHelper;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.ejb.common.Transaction;
import agorum.roi.timephasedaction.actions.BaseAction;
import agorum.roi.timephasedaction.common.TimePhasedActionUtils;
import java.util.Date;
import java.util.GregorianCalendar;

public class SetTimePhasedAction
extends BaseAction {
    protected String timeOffset;
    protected String timeOffsetUnit;
    protected String timePhasedAction;
    protected String timeReferenceAttribute;
    protected String[] setToClassNames;
    protected String[] filter;
    protected String filterExclude;
    protected int toStart;
    protected int started;
    public static Object syncObj = new Object();
    public static boolean isRunning;

    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        boolean bRet = false;
        if (clientBean instanceof FolderObjectClientBean) {
            String accessLevelSource = this.getMethodParameter(sessionController, "AccessLevelSource", action);
            bRet = clientBean.checkEffectiveAccess(AccessLevel.getAccessLevel(accessLevelSource));
        }
        return bRet;
    }

    @Override
    public boolean hasAccess(SystemStatistic stat, SessionController sessionController, String className, String action) throws Exception {
        boolean bRet = false;
        if (className.equalsIgnoreCase(FolderObjectClientBean.CLASS_NAME)) {
            bRet = true;
        }
        return bRet;
    }

    @Override
    public void invokeFast(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        String setNextTimePhasedActionDate;
        if (clientBean != null && action != null && (setNextTimePhasedActionDate = this.getMethodParameter(sessionController, "SetNextTimePhasedActionDate", action)) != null && setNextTimePhasedActionDate.equalsIgnoreCase("TRUE")) {
            TimePhasedActionUtils.setPeriodic(clientBean, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isRunning(SystemStatistic stat) {
        Object object = syncObj;
        synchronized (object) {
            if (!isRunning) {
                isRunning = true;
                return false;
            }
            return true;
        }
    }

    protected boolean shouldRun(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean, String action) throws Exception {
        block8: {
            SessionController sessionController2 = SessionControllerAdmin.getSessionControllerAdmin("TimePhasedAction_AuditStatus");
            sessionController2.setAuditState(AuditUtil.ACTION_EXT_NOT_ENTRY);
            GlobalObjectClientBean clientBean2 = sessionController2.getGlobalObjectById(clientBean.getId());
            try {
                if (clientBean2 == null || action == null) break block8;
                this.timePhasedAction = this.getMethodParameter(sessionController2, "TimePhasedAction", action);
                if (!this.shouldRun(stat, sessionController2, clientBean2, action)) {
                    return;
                }
                this.timeOffset = this.getMethodParameter(sessionController2, "TimeOffset", action);
                this.timeOffsetUnit = this.getMethodParameter(sessionController2, "TimeOffsetUnit", action);
                this.timeReferenceAttribute = this.getMethodParameter(sessionController2, "TimeReferenceAttribute", action);
                this.setToClassNames = this.getMethodParameterArray(sessionController2, "SetToClassNames", action);
                boolean bequeathToSubFolders = true;
                try {
                    bequeathToSubFolders = Boolean.parseBoolean(this.getMethodParameter(sessionController2, "BequeathToSubFolders", action));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.filter = this.getMethodParameterArray(sessionController2, "Filter", action);
                this.filterExclude = this.getMethodParameter(sessionController2, "FilterExclude", action);
                if (this.timeOffset != null && this.timeOffset.length() > 0 && this.timeOffsetUnit != null && this.timeOffsetUnit.length() > 0 && this.timePhasedAction != null && this.timePhasedAction.length() > 0 && this.timeReferenceAttribute != null && this.timeReferenceAttribute.length() > 0 && this.setToClassNames != null && this.setToClassNames.length > 0) {
                    FolderObjectClientBean folder = (FolderObjectClientBean)clientBean2;
                    this.setTimeBasedActionInternal(stat, sessionController2, this.getItems(folder), bequeathToSubFolders);
                }
            }
            finally {
                isRunning = false;
            }
        }
    }

    private void setTimeBasedActionInternal(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean[] items, boolean bequeathToSubFolders) throws Exception {
        int len = items != null ? items.length : 0;
        for (int i = 0; i < len; ++i) {
            if (items[i] == null) continue;
            if (this.toStart > 0 && this.started >= this.toStart) {
                return;
            }
            try (Transaction trans = new Transaction();){
                this.setAction(stat, sessionController, items[i]);
                trans.restart();
            }
            if (!bequeathToSubFolders || !(items[i] instanceof FolderObjectClientBean)) continue;
            this.setTimeBasedActionInternal(stat, sessionController, this.getItems((FolderObjectClientBean)items[i]), bequeathToSubFolders);
        }
    }

    protected boolean setAction(SystemStatistic stat, SessionController sessionController, GlobalObjectClientBean clientBean) throws Exception {
        Date d;
        if (OpenFileHelper.randomFileHash.containsKey("" + clientBean.getId())) {
            return false;
        }
        if (!clientBean.isTemporary() && this.isSetClassName(clientBean) && this.matchFilter(clientBean) && (d = this.getTimePhasedActionDate(clientBean)) != null) {
            if (!clientBean.isLocked() && !clientBean.isLockedForSession()) {
                if (stat.logDebug()) {
                    stat.debug().object((SystemObjectReference)clientBean).send("Setting next action to: " + this.timePhasedAction + ", " + d);
                }
                SuperObjectClientBeanDefinition def = clientBean.getNewDefinition(sessionController);
                def.setSystemOption("doNotEA", "true");
                def.setSystemOption("forceTimePhasedAction", "true");
                def.setAttribute(GlobalObjectClientBean.TIMEPHASEDACTIONDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(d));
                def.setAttribute(GlobalObjectClientBean.LASTMODIFIER_ATTRIBUTE, AttributeValue.newAttributeValueObject(clientBean.getLastModifier()));
                def.setAttribute(GlobalObjectClientBean.TIMEPHASEDACTION_ATTRIBUTE, AttributeValue.newAttributeValueObject(this.timePhasedAction));
                clientBean.update(def);
                ++this.started;
            } else {
                stat.warning().object((SystemObjectReference)clientBean).send("Object is still in use, do not set TimePhasedAction");
            }
        }
        return true;
    }

    private Date getTimePhasedActionDate(GlobalObjectClientBean clientBean) throws Exception {
        int iTimeOffset = Integer.parseInt(this.timeOffset);
        Date dRet = null;
        if (clientBean.getTimePhasedAction() == null || clientBean.getTimePhasedAction().length() == 0 || clientBean.getTimePhasedActionDate() == null) {
            Date d = clientBean.getAttribute(this.timeReferenceAttribute.toUpperCase()).getDate();
            Date dAct = new Date();
            int year = d.getYear();
            int month = d.getMonth();
            int date = d.getDate();
            int hours = d.getHours();
            int minutes = d.getMinutes();
            int seconds = d.getSeconds();
            if (this.timeOffsetUnit.equals("y")) {
                year += iTimeOffset;
            } else if (this.timeOffsetUnit.equals("m")) {
                month += iTimeOffset;
            } else if (this.timeOffsetUnit.equals("d")) {
                date += iTimeOffset;
            } else if (this.timeOffsetUnit.equals("h")) {
                hours += iTimeOffset;
            } else if (this.timeOffsetUnit.equals("M")) {
                minutes += iTimeOffset;
            } else if (this.timeOffsetUnit.equals("s")) {
                seconds += iTimeOffset;
            } else {
                ExceptionUtils.handleException("TimeOffsetUnit '" + this.timeOffsetUnit + "' not supported (only: y,m,d,h,M,s)", "agorum.roi.remote.exception.TimeOffsetUnitNotSupported", 40);
            }
            dRet = new GregorianCalendar(year + 1900, month, date, hours, minutes, seconds).getTime();
            dRet = dRet.getTime() < dAct.getTime() ? dAct : null;
        }
        return dRet;
    }

    private boolean isSetClassName(GlobalObjectClientBean clientBean) throws Exception {
        int len = this.setToClassNames.length;
        boolean bRet = false;
        for (int i = 0; i < len; ++i) {
            if (!this.setToClassNames[i].equalsIgnoreCase(clientBean.getClassName())) continue;
            bRet = true;
            break;
        }
        return bRet;
    }

    private boolean matchFilter(GlobalObjectClientBean clientBean) throws Exception {
        boolean bRet = false;
        if (this.filterExclude != null && this.filterExclude.equalsIgnoreCase("TRUE")) {
            bRet = true;
        }
        if (this.filter != null) {
            String name = clientBean.getName();
            int filterLen = this.filter.length;
            for (int i = 0; i < filterLen; ++i) {
                if (!name.matches(this.filter[i])) continue;
                bRet = this.filterExclude == null || !this.filterExclude.equalsIgnoreCase("TRUE");
                break;
            }
        } else {
            bRet = true;
        }
        return bRet;
    }

    private GlobalObjectClientBean[] getItems(FolderObjectClientBean folder) throws Exception {
        GlobalObjectClientBean[] items = folder.getItems(false, new String[]{GlobalObjectClientBean.CLASS_NAME}, new String[]{GlobalObjectClientBean.TIMEPHASEDACTIONDATE_ATTRIBUTE}, new Object[]{new Date(0L)}, new int[]{0}, new boolean[]{false}, new int[]{1}, null, null, null);
        return items;
    }
}

