/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.tools;

import agorum.commons.string.StringUtils;
import agorum.commons.utils.CSVParser;
import agorum.roi.ejb.client.beans.FileObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.RoiFileSystem;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.sessionfacade.beans.FileObjectSessionFacade;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class CSVFileImporter {
    public static ArrayList detailLogList = new ArrayList();
    public static ArrayList logList = new ArrayList();
    public long amountFiles;
    public long amountCreated;
    public long amountUpdated;
    public long amountDeleted;

    public List importFiles(SessionController sessionController, InputStream csvInputStream, String delim) throws Exception {
        long beginTime = System.currentTimeMillis();
        this.amountFiles = 0L;
        this.amountCreated = 0L;
        this.amountUpdated = 0L;
        this.amountDeleted = 0L;
        logList = new ArrayList();
        detailLogList = new ArrayList();
        ArrayList<String> importedFileList = new ArrayList<String>();
        CSVParser csvParser = new CSVParser();
        if (delim != null && delim.trim().length() > 0) {
            csvParser.setDelimChar(delim.charAt(0));
        }
        ArrayList parsedLines = new ArrayList();
        try {
            parsedLines = csvParser.parseCSV(csvInputStream, true);
        }
        catch (Exception ex) {
            parsedLines.add("Error while trying to parse CSV file.");
        }
        int parsedLinesLen = parsedLines.size();
        for (int i = 0; i < parsedLinesLen; ++i) {
            Hashtable lineHash = (Hashtable)parsedLines.get(i);
            String sourcePath = (String)lineHash.get("SourcePath");
            String agorumTargetPath = (String)lineHash.get("AgorumTargetPath");
            File sourceFolder = new File(sourcePath);
            HashMap sourceMap = new HashMap();
            HashMap agorumTargetMap = new HashMap();
            if (sourceFolder.exists() && sourceFolder.isDirectory()) {
                this.fillSourceFileMap(sourceFolder, sourceMap);
                FolderObjectClientBean agorumTargetFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(agorumTargetPath);
                RoiFileSystem roiFileSystem = new RoiFileSystem(sessionController);
                if (agorumTargetFolder == null) {
                    agorumTargetFolder = roiFileSystem.createFullpath(agorumTargetPath);
                }
                this.fillAgorumMap(agorumTargetFolder, agorumTargetMap);
                this.handleFolder(sessionController, importedFileList, new RoiFileSystem(sessionController), sourceMap, agorumTargetMap, agorumTargetPath);
                continue;
            }
            importedFileList.add("Source folder doesn't exist or is not reachable.");
        }
        String s = "Import finished in " + (System.currentTimeMillis() - beginTime) / 1000L + " seconds";
        this.addToLogList(s);
        this.addToDetailLogList(s);
        return importedFileList;
    }

    private void handleFolder(SessionController sessionController, List importedFileList, RoiFileSystem roiFileSystem, Map sourceFileMap, Map agorumTargetMap, String currentAgorumPath) throws Exception {
        FolderObjectClientBean parentFolder = (FolderObjectClientBean)sessionController.findGlobalObjectByPath(currentAgorumPath);
        FolderObjectClientBean createdFolder = null;
        for (String key : sourceFileMap.keySet()) {
            File file = (File)sourceFileMap.get(key);
            FileObjectSessionFacade fosf = new FileObjectSessionFacade(sessionController);
            try {
                if (!agorumTargetMap.containsKey(key)) {
                    if (file.isDirectory()) {
                        createdFolder = roiFileSystem.createFullpath(currentAgorumPath + "/" + key);
                        agorumTargetMap.put(key, createdFolder);
                        String currentPath = currentAgorumPath + "/" + key;
                        if (createdFolder != null) {
                            HashMap sMap = new HashMap();
                            HashMap tMap = new HashMap();
                            this.fillSourceFileMap(file, sMap);
                            this.fillAgorumMap(createdFolder, tMap);
                            this.handleFolder(sessionController, importedFileList, roiFileSystem, sMap, tMap, currentPath);
                        }
                    } else {
                        Date fileDate = new Date(file.lastModified());
                        fosf.setWithTransaction(true);
                        fosf.setAttribute(FileObjectClientBean.NAME_ATTRIBUTE, key);
                        fosf.setDestinationFolder(parentFolder);
                        FileInputStream is = new FileInputStream(file);
                        fosf.setContentStream(is);
                        FileObjectClientBean fo = (FileObjectClientBean)fosf.create();
                        GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)fo.getNewDefinition(sessionController);
                        def.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(fileDate));
                        fo.update(def);
                        String s = "Imported file " + file.getAbsolutePath();
                        System.out.println("CSVFileImporter: " + s);
                        importedFileList.add(s);
                        this.addToLogList(s);
                        this.addToDetailLogList(s);
                        ++this.amountFiles;
                        ++this.amountCreated;
                    }
                } else {
                    GlobalObjectClientBean gocb = (GlobalObjectClientBean)agorumTargetMap.get(key);
                    Date lastModifiedDate = new Date(file.lastModified());
                    Date gobcLastModifyDate = gocb.getLastModifyDate();
                    if (!gocb.getIsFolder()) {
                        if (lastModifiedDate.after(gobcLastModifyDate)) {
                            FileObjectClientBean fileObject = (FileObjectClientBean)gocb;
                            fosf.setWithTransaction(true);
                            fosf.setDestinationFolder(parentFolder);
                            fosf.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, lastModifiedDate);
                            FileInputStream is = new FileInputStream(file);
                            fosf.setGlobalObject(fileObject);
                            fosf.setContentStream(is);
                            FileObjectClientBean fo = (FileObjectClientBean)fosf.update();
                            GlobalObjectClientBeanDefinition def = (GlobalObjectClientBeanDefinition)fo.getNewDefinition(sessionController);
                            def.setAttribute(GlobalObjectClientBean.LASTMODIFYDATE_ATTRIBUTE, AttributeValue.newAttributeValueObject(lastModifiedDate));
                            fo.update(def);
                            String s = "Updated file " + file.getAbsolutePath();
                            importedFileList.add(s);
                            System.out.println("CSVFileImporter: " + s);
                            this.addToLogList(s);
                            this.addToDetailLogList(s);
                            ++this.amountFiles;
                            ++this.amountUpdated;
                        } else {
                            String s = "File not changed " + file.getAbsolutePath();
                            this.addToDetailLogList(s);
                        }
                    } else {
                        String currentPath = currentAgorumPath + "/" + key;
                        HashMap sMap = new HashMap();
                        HashMap tMap = new HashMap();
                        this.fillSourceFileMap(file, sMap);
                        this.fillAgorumMap((FolderObjectClientBean)gocb, tMap);
                        this.handleFolder(sessionController, importedFileList, roiFileSystem, sMap, tMap, currentPath);
                    }
                }
                agorumTargetMap.remove(key);
            }
            catch (Exception ex) {
                String s = "Error while importing file " + file.getPath();
                importedFileList.add(s);
                System.out.println("CSVFileImporter: " + s);
                ex.printStackTrace(System.err);
                StringUtils su = new StringUtils();
                String exS = su.exceptionToString(ex);
                this.addToLogList("Error: " + exS);
            }
        }
        for (String agorumKey : agorumTargetMap.keySet()) {
            GlobalObjectClientBean gobc = (GlobalObjectClientBean)agorumTargetMap.get(agorumKey);
            try {
                String s = "Deleting file or folder" + currentAgorumPath + "/" + gobc.getName();
                this.addToDetailLogList(s);
                gobc.delete();
                s = "Deleted file or folder" + currentAgorumPath + "/" + gobc.getName();
                importedFileList.add(s);
                System.out.println("CSVFileImporter: " + s);
                this.addToLogList(s);
                this.addToDetailLogList(s);
                ++this.amountDeleted;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToLogList(String s) {
        ArrayList arrayList = logList;
        synchronized (arrayList) {
            String statistic = "files: " + this.amountFiles + ", created: " + this.amountCreated + ", updated: " + this.amountUpdated + ", deleted: " + this.amountDeleted;
            if (logList.size() == 0) {
                logList.add("");
            }
            logList.add(s);
            if (logList.size() > 15) {
                logList.remove(0);
            }
            logList.set(0, statistic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToDetailLogList(String s) {
        ArrayList arrayList = detailLogList;
        synchronized (arrayList) {
            String statistic = "files: " + this.amountFiles + ", created: " + this.amountCreated + ", updated: " + this.amountUpdated + ", deleted: " + this.amountDeleted;
            if (detailLogList.size() == 0) {
                detailLogList.add("");
            }
            detailLogList.add(s);
            if (detailLogList.size() > 15) {
                detailLogList.remove(0);
            }
            detailLogList.set(0, statistic);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getLogList() {
        ArrayList arrayList = logList;
        synchronized (arrayList) {
            ArrayList retList = (ArrayList)logList.clone();
            return retList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getDetailLogList() {
        ArrayList arrayList = detailLogList;
        synchronized (arrayList) {
            ArrayList retList = (ArrayList)detailLogList.clone();
            return retList;
        }
    }

    private void fillSourceFileMap(File source, Map sourceMap) {
        if (source.isDirectory()) {
            File[] childFiles = source.listFiles();
            int len = childFiles != null ? childFiles.length : -1;
            for (int i = 0; i < len; ++i) {
                File file = childFiles[i];
                sourceMap.put(file.getName(), file);
            }
        }
    }

    private void fillAgorumMap(FolderObjectClientBean folder, Map agorumMap) throws Exception {
        GlobalObjectClientBean[] items = folder.getItems();
        int len = items != null ? items.length : -1;
        for (int i = 0; i < len; ++i) {
            GlobalObjectClientBean gocb = items[i];
            agorumMap.put(gocb.getName(), gocb);
        }
    }
}

