/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.tools;

import agorum.roi.ejb.client.beans.AccessControlListObjectClientBean;
import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBeanDefinition;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.ejb.common.CredentialObject;
import agorum.roi.ejb.common.RoiProperties;
import agorum.roi.ejb.common.SessionController;

public class SetAclFromFolderToFolder {
    private SessionController sessionController = null;

    public SetAclFromFolderToFolder(SessionController sessionController) {
        this.sessionController = sessionController;
    }

    public void setAcl(String sourcePath, String destinationPath) throws Exception {
        FolderObjectClientBean sourceFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(sourcePath);
        FolderObjectClientBean destinationFolder = (FolderObjectClientBean)this.sessionController.findGlobalObjectByPath(destinationPath);
        if (sourceFolder != null && destinationFolder != null && sourceFolder.getId().longValue() != destinationFolder.getId().longValue()) {
            this.setAclRecursiv(sourceFolder, destinationFolder);
        } else {
            System.err.println("Source oder DestinationFolder nicht korrekt");
        }
    }

    private void setAclRecursiv(FolderObjectClientBean sourceFolder, FolderObjectClientBean destinationFolder) throws Exception {
        GlobalObjectClientBean[] items = sourceFolder.getItems();
        if (items != null) {
            int len = items.length;
            for (int i = 0; i < len; ++i) {
                FolderObjectClientBean sFolder;
                FolderObjectClientBean dFolder;
                System.err.println("Object: " + items[i].getAnyFolderPath());
                if (!(items[i] instanceof FolderObjectClientBean) || (dFolder = (FolderObjectClientBean)destinationFolder.getItem((sFolder = (FolderObjectClientBean)items[i]).getName())) == null) continue;
                System.err.println("Destination: " + dFolder.getAnyFolderPath());
                AccessControlListObjectClientBean aclSource = sFolder.getAcl();
                AccessControlListObjectClientBean aclDestination = dFolder.getAcl();
                if (aclSource.getId().longValue() != aclDestination.getId().longValue()) {
                    AccessControlListObjectClientBean acl = aclSource;
                    System.err.println("set ACL :" + acl.getName());
                    SuperObjectClientBeanDefinition def = null;
                    if (sFolder.getItemsCountOnlyFolder() <= 0) {
                        def = dFolder.getNewDefinition(this.sessionController);
                        def.setSystemOption("leaveAclToObjectsWithThisAcl ", "");
                        dFolder.leaveAcl(acl, def);
                        System.err.println("ACL wird durchvererbt");
                    } else {
                        dFolder.setAcl(acl);
                    }
                    dFolder.setAttribute(GlobalObjectClientBean.OBJECTTEXTKEY_ATTRIBUTE, AttributeValue.newAttributeValueObject(sFolder.getObjectTextKey()));
                }
                this.setAclRecursiv(sFolder, dFolder);
            }
        }
    }

    public static void main(String[] args) {
        try {
            if (args == null || args != null && args.length < 4) {
                System.err.println("Aufruf:\nSetAclFromFolderToFolder UserName UserPassword sourcePath destinationPath\n");
            } else {
                String userName = args[0];
                String password = args[1];
                String sourcePath = args[2];
                String destinationPath = args[3];
                System.setProperty("org.jboss.mq.il.oil.localAddr", "1.1.1.1");
                System.setProperty("org.jboss.mq.il.oil.localPort", "9876");
                RoiProperties rp = new RoiProperties();
                CredentialObject credential = new CredentialObject();
                credential.setUserName(userName);
                credential.setPassWord(password);
                credential.setModulInfo("SetAclFromFolderToFolder");
                SessionController sessionController = SessionController.connect(credential);
                SetAclFromFolderToFolder setAclFromFolderToFolder = new SetAclFromFolderToFolder(sessionController);
                setAclFromFolderToFolder.setAcl(sourcePath, destinationPath);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        System.err.println("Programm ende");
    }
}

