/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.roi.ejb.common.AttributeInfo;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.searchengine.AdvancedSearchResult;
import agorum.roi.searchengine.IndexHandlerInterface;
import agorum.roi.searchengine.IndexHelper;
import agorum.roi.searchengine.SortInfo;
import agorum.roi.workers.Job;
import agorum.roi.workers.Worker;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;

public abstract class PartitionQueryWorker<T>
extends Worker {
    private boolean advancedSearch;

    protected PartitionQueryWorker(String name, int concurrency) {
        super(name, concurrency);
    }

    @Override
    public void start() {
        this.advancedSearch = IndexHelper.getIndexHandler(this.stat).supportsAdvancedSearch();
        super.start();
    }

    @Override
    protected Collection<Job> collect(int limit, boolean idle) {
        ArrayList<Job> work = new ArrayList<Job>(limit);
        try {
            SessionController sca = SessionControllerAdmin.getService(PartitionQueryWorker.class);
            if (!idle) {
                this.stat.debug("Wasn't idle, committing index changes");
                try (IndexHandlerInterface i = IndexHelper.getIndexHandler(this.stat);){
                    i.commit();
                }
            }
            boolean hidden = this.includeHidden();
            List<Partition> partitions = this.getPartitions();
            Collections.reverse(partitions);
            LinkedHashMap<Object, ArrayDeque<String>> queues = new LinkedHashMap<Object, ArrayDeque<String>>();
            StringBuilder exclusion = new StringBuilder();
            for (Partition p : partitions) {
                List<String> hits;
                String query = p.partition + " " + p.query + exclusion.toString();
                if (this.advancedSearch) {
                    AdvancedSearchResult asr = sca.prepareAdvancedSearch(query).rows(limit).includeHidden(hidden).sort(new SortInfo("updatedate", true)).search("id");
                    hits = new ArrayList<String>(asr.rows.size());
                    for (Map<String, AttributeInfo> row : asr.rows) {
                        AttributeInfo ai = row.get("id");
                        Object value = ai == null ? null : ai.value;
                        hits.add(value == null ? null : value.toString());
                    }
                    this.stat.debug(hits.size() + " hits (" + asr.total + " total) for query: " + query);
                } else {
                    hits = sca.search(query, limit, hidden);
                    this.stat.debug(hits.size() + " hits for query: " + query);
                }
                Queue existing = (Queue)queues.get(p.data);
                if (existing == null) {
                    queues.put(p.data, new ArrayDeque<String>(hits));
                } else {
                    existing.addAll(hits);
                }
                exclusion.append(" NOT (");
                exclusion.append(p.partition);
                exclusion.append(")");
            }
            block13: while (limit > 0 && queues.size() > 0) {
                Iterator iter = queues.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String id = (String)((Queue)entry.getValue()).poll();
                    if (id == null) {
                        iter.remove();
                        continue;
                    }
                    work.add(new Job(id, () -> {
                        long time = System.currentTimeMillis();
                        this.work(entry.getKey(), id);
                        this.stat.measure("Job duration", "ms", System.currentTimeMillis() - time);
                    }));
                    if (--limit > 0) continue;
                    continue block13;
                }
            }
        }
        catch (Exception e) {
            this.stat.error((Throwable)e, "Error while collecting work");
        }
        return work;
    }

    protected abstract boolean includeHidden();

    protected abstract List<Partition> getPartitions() throws Exception;

    protected abstract void work(T var1, String var2);

    protected class Partition {
        private final T data;
        private final String partition;
        private final String query;

        public Partition(T data, String partition, String query) {
            this.data = data;
            this.partition = partition;
            this.query = query;
        }
    }
}

