/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.workers;

import agorum.commons.statistic.Statistic;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.GenericMultiQueueBean;
import agorum.roi.ejb.common.GenericMultiQueueHelper;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.exception.RoiException;
import agorum.roi.workers.Job;
import java.util.ArrayList;
import java.util.Collection;

public class Queue {
    private static final String ME = Queue.class.getName();
    private final Statistic stat;
    private final String ident;
    private final Worker worker;
    private long cursor;

    public Queue(Statistic stat, String ident, Worker worker) {
        this.stat = stat;
        this.ident = ident;
        this.worker = worker;
    }

    public Collection<Job> collect(int limit) {
        ArrayList<Job> work = new ArrayList<Job>(limit);
        try {
            boolean empty = true;
            for (GenericMultiQueueBean item : new GenericMultiQueueHelper().getQueueEntries(null, this.ident, limit, this.cursor)) {
                work.add(new Job(item.id + ";" + item.data, () -> {
                    long time = System.currentTimeMillis();
                    try {
                        GlobalObjectClientBean object;
                        try {
                            object = SessionControllerAdmin.getService(ME).getGlobalObjectById(item.id);
                        }
                        catch (Exception e) {
                            if (this.log(e, item)) {
                                this.done(item);
                            }
                            this.stat.measure("Job duration", "ms", System.currentTimeMillis() - time);
                            return;
                        }
                        try {
                            this.worker.work(new Item(item, object));
                        }
                        catch (Exception e) {
                            this.log(e, item);
                        }
                    }
                    finally {
                        this.stat.measure("Job duration", "ms", System.currentTimeMillis() - time);
                    }
                }));
                empty = false;
                this.cursor = item.sortId;
            }
            if (empty && this.cursor != 0L) {
                this.cursor = 0L;
                return this.collect(limit);
            }
        }
        catch (Exception e) {
            this.stat.error((Throwable)e, "Error while collecting work");
        }
        return work;
    }

    public void queue(long id, String data, Runnable callback) throws Exception {
        new GenericMultiQueueHelper().createQueueEntry(id, this.ident, data, callback);
    }

    public long count() throws Exception {
        return new GenericMultiQueueHelper().getQueueEntryCount(this.ident);
    }

    private void done(GenericMultiQueueBean item) {
        try {
            new GenericMultiQueueHelper().deleteQueueEntry(item);
        }
        catch (Exception e) {
            this.stat.error().exception((Throwable)e).objectId(item.id).send("Error while removing queue entry: sortId: " + item.sortId + ", data: " + item.data);
        }
    }

    private boolean log(Exception e, GenericMultiQueueBean item) {
        if (Queue.isNotFound(e)) {
            this.stat.info().exception((Throwable)e).objectId(item.id).send("Object not found while handling item");
            return true;
        }
        this.stat.error().exception((Throwable)e).objectId(item.id).send("Error while handling item");
        return false;
    }

    private static boolean isNotFound(Exception e) {
        return e instanceof RoiException && ((RoiException)e).getErrorCode() == 101;
    }

    static interface Worker {
        public void work(Item var1) throws Exception;
    }

    public class Item {
        private final GenericMultiQueueBean item;
        private final GlobalObjectClientBean object;

        private Item(GenericMultiQueueBean item, GlobalObjectClientBean object) {
            this.item = item;
            this.object = object;
        }

        public GlobalObjectClientBean getObject() {
            return this.object;
        }

        public Long getId() {
            return this.item.id;
        }

        public String getData() {
            return this.item.data;
        }

        public void done() {
            Queue.this.done(this.item);
        }
    }
}

