/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.string.StringModifierUtils;
import agorum.roi.common.utils.Beans;
import agorum.roi.ejb.client.beans.ClassObjectClientBean;
import agorum.roi.ejb.client.beans.SuperObjectClientBean;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.extendedsearch.SearchHandlerInterface;
import agorum.roi.searchengine.Functions;
import agorum.roi.util.MetaDbSearchClassFilterBean;
import agorum.roi.util.MetaDbSearchClassFilterUtility;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;

public class ReplaceQueryPlaceholder {
    private static final SessionController sca = SessionControllerAdmin.getService(ReplaceQueryPlaceholder.class);

    private static SuperObjectClientBean lookup(SessionController sc, String id) {
        SuperObjectClientBean result = (SuperObjectClientBean)Beans.tryLookup(sc, id);
        if (result == null) {
            result = (SuperObjectClientBean)Beans.lookup(sca, id);
        }
        return result;
    }

    public static String replaceAllPlaceHolders(String queryString, SessionController sessionController) throws Exception {
        queryString = ReplaceQueryPlaceholder.replaceFunctions(queryString, sessionController);
        queryString = ReplaceQueryPlaceholder.replacePath(queryString, sessionController);
        queryString = ReplaceQueryPlaceholder.replaceClassFilter(queryString, sessionController);
        queryString = ReplaceQueryPlaceholder.replaceClassId(queryString, sessionController);
        queryString = ReplaceQueryPlaceholder.replaceDate(queryString, sessionController);
        queryString = ReplaceQueryPlaceholder.replaceDateTime(queryString, sessionController);
        queryString = ReplaceQueryPlaceholder.replaceSearchHandlers(queryString, sessionController);
        return queryString;
    }

    private static String replaceFunctions(String queryString, SessionController sessionController) throws Exception {
        int j;
        int i;
        int start = 0;
        while ((i = queryString.indexOf("${", start)) >= 0 && (j = queryString.indexOf("}", i)) >= i) {
            Functions.Function function;
            String name = queryString.substring(i + 2, j);
            String args = null;
            int k = name.indexOf(":");
            if (k >= 0) {
                args = name.substring(k + 1);
                name = name.substring(0, k);
            }
            if ((function = Functions.get(name)) != null) {
                queryString = queryString.substring(0, i) + function.apply(sessionController, args) + queryString.substring(j + 1);
                start = i;
                continue;
            }
            start = i + 1;
        }
        return queryString;
    }

    public static String replacePath(String queryString, SessionController sessionController) throws Exception {
        int p1 = -1;
        while ((p1 = queryString.indexOf("${FOLDERPATH:")) != -1) {
            String pre = queryString.substring(0, p1);
            String post = queryString.substring(p1);
            int p2 = post.indexOf(":");
            int p3 = post.indexOf("}");
            String path = post.substring(p2 + 1, p3);
            post = post.substring(p3 + 1);
            long objId = 0L;
            if (path.length() > 0) {
                try {
                    objId = sca.findGlobalObjectByPath(path).getId();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            queryString = pre + objId + post;
        }
        return queryString;
    }

    public static String replaceSearchHandlers(String queryString, SessionController sessionController) throws Exception {
        int p1 = -1;
        while ((p1 = queryString.indexOf("${SEARCHHANDLER:")) != -1) {
            String pre = queryString.substring(0, p1);
            String post = queryString.substring(p1);
            int p2 = post.indexOf(":");
            int p3 = post.indexOf(";");
            int p4 = post.indexOf("[");
            int p5 = post.indexOf("]");
            int p6 = post.indexOf("}");
            String handler = post.substring(p2 + 1, p3);
            String[] paramsArray = post.substring(p4 + 1, p5).split(";");
            HashMap<String, Object> params = new HashMap<String, Object>();
            for (String param : paramsArray) {
                int pOfEqual = param.indexOf("=");
                String paramName = param.substring(0, pOfEqual);
                String paramValue = param.substring(pOfEqual + 1);
                params.put(paramName, paramValue);
            }
            post = post.substring(p6 + 1);
            String metaDbKey = "MAIN_MODULE_MANAGEMENT/textindexservice/control/searchhandler/" + handler;
            MetaDb metaDb = sessionController.getMetaDbInstance();
            String className = null;
            Hashtable extraParams = null;
            try {
                className = metaDb.getSimplePropertyValue(metaDbKey + "/Class")[0];
                extraParams = metaDb.getParameterHash(metaDbKey);
            }
            catch (Exception pOfEqual) {
                // empty catch block
            }
            if (className == null || extraParams == null) continue;
            SearchHandlerInterface searchHandler = (SearchHandlerInterface)Class.forName(className).newInstance();
            String replacedString = searchHandler.getReplaceQuery(params, extraParams, sessionController, metaDbKey);
            queryString = pre + replacedString + post;
        }
        return queryString;
    }

    public static String replaceClassId(String queryString, SessionController sessionController) throws Exception {
        int p1 = -1;
        while ((p1 = queryString.indexOf("${CLASSID:")) != -1) {
            String pre = queryString.substring(0, p1);
            String post = queryString.substring(p1);
            int p2 = post.indexOf(":");
            int p3 = post.indexOf("}");
            String classId = post.substring(p2 + 1, p3);
            post = post.substring(p3 + 1);
            long lClassId = 1L;
            if (classId.length() > 0) {
                try {
                    ClassObjectClientBean co = sessionController.getClassObject(classId.toUpperCase());
                    lClassId = co != null ? co.getId() : 1L;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            queryString = pre + lClassId + post;
        }
        return queryString;
    }

    public static String replaceClassFilter(String query, SessionController sessionController) throws Exception {
        String metaDbPath = "";
        int pos1 = 0;
        MetaDbSearchClassFilterUtility metaDbSearchClassFilterUtility = null;
        metaDbSearchClassFilterUtility = new MetaDbSearchClassFilterUtility(sessionController);
        while ((metaDbPath = StringModifierUtils.getInner((String)query, (String)"${classfilter:", (String)"}", (int)pos1)) != null) {
            String replaceString = "${classfilter:" + metaDbPath + "}";
            ArrayList searchClasses = metaDbSearchClassFilterUtility.getMetaDbSearchClassFilters(metaDbPath);
            int size = searchClasses.size();
            String classID = "";
            if (size > 0) {
                classID = "classid:(";
                for (int i = 0; i < size - 1; ++i) {
                    MetaDbSearchClassFilterBean mdbSearchClassFilterBean = (MetaDbSearchClassFilterBean)searchClasses.get(i);
                    classID = classID + mdbSearchClassFilterBean.getClassId() + " OR ";
                }
                MetaDbSearchClassFilterBean mdbSearchClassFilterBean = (MetaDbSearchClassFilterBean)searchClasses.get(size - 1);
                classID = classID + mdbSearchClassFilterBean.getClassId() + ")";
            }
            query = query.replace(replaceString, classID);
            ++pos1;
        }
        return query;
    }

    public static String replaceDate(String queryString, SessionController sessionController) throws Exception {
        int p1 = -1;
        while ((p1 = queryString.indexOf("${ACTDATE:")) != -1) {
            String pre = queryString.substring(0, p1);
            String post = queryString.substring(p1);
            int p2 = post.indexOf(":");
            int p3 = post.indexOf("}");
            String days = post.substring(p2 + 1, p3);
            post = post.substring(p3 + 1);
            long idays = 0L;
            if (days.length() > 0) {
                idays = Long.parseLong(days);
            }
            Date d = new Date();
            Date nd = new Date(d.getTime() + idays * 24L * 60L * 60L * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            queryString = pre + sdf.format(nd) + post;
        }
        return queryString;
    }

    public static String replaceDateTime(String queryString, SessionController sessionController) throws Exception {
        int p1 = -1;
        while ((p1 = queryString.indexOf("${ACTDATETIME:")) != -1) {
            String pre = queryString.substring(0, p1);
            String post = queryString.substring(p1);
            int p2 = post.indexOf(":");
            int p3 = post.indexOf("}");
            String seconds = post.substring(p2 + 1, p3);
            post = post.substring(p3 + 1);
            long iseconds = 0L;
            if (seconds.length() > 0) {
                iseconds = Long.parseLong(seconds);
            }
            Date d = new Date();
            Date nd = new Date(d.getTime() + iseconds * 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            queryString = pre + sdf.format(nd) + post;
        }
        return queryString;
    }

    static {
        Functions.register("UUID", (sc, args) -> ReplaceQueryPlaceholder.lookup(sc, args).getUUID());
        Functions.register("ID", (sc, args) -> ReplaceQueryPlaceholder.lookup(sc, args).getID());
        Functions.register("USERUUID", (sc, args) -> args == null || args.isEmpty() ? sc.getLoginUserUuid() : ReplaceQueryPlaceholder.lookup(sc, "user:" + args).getUUID());
        Functions.register("USERID", (sc, args) -> args == null || args.isEmpty() ? sc.getLoginUserId().toString() : ReplaceQueryPlaceholder.lookup(sc, "user:" + args).getID());
        Functions.register("USERACLIDS", (sc, args) -> {
            StringBuilder sb = null;
            for (long aclId : sc.getUserAclIds(args)) {
                if (sb == null) {
                    sb = new StringBuilder("(");
                } else {
                    sb.append(" OR ");
                }
                sb.append(aclId);
            }
            if (sb == null) {
                return "0";
            }
            sb.append(")");
            return sb.toString();
        });
    }
}

