/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common;

import agorum.agceptit.metadb.client.common.MetaDb;
import agorum.commons.statistic.CoreStatistic;
import agorum.roi.common.utils.Beans;
import agorum.roi.ejb.common.ContentInterface;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.common.SessionControllerAdmin;
import agorum.roi.scripting.EngineContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Startup {
    private static final CoreStatistic stat = CoreStatistic.getInstance();
    private static final List<Runnable> readyHandlers = new ArrayList<Runnable>();
    private static final List<Runnable> readyApiHandlers = new ArrayList<Runnable>();
    private static final List<Runnable> updateFinishedHandlers = new ArrayList<Runnable>();
    private static volatile boolean ready;
    private static volatile boolean apiReady;
    private static volatile boolean updatesFinished;

    private static void run(String type) {
        SessionController sc = SessionControllerAdmin.getService(Startup.class);
        MetaDb metaDb = sc.getMetaDbInstance();
        String base = "MAIN_MODULE_MANAGEMENT/roi/control/startup/" + type;
        Object[] names = metaDb.listEntries(base);
        Arrays.sort(names);
        for (Object name : names) {
            try {
                String classOrScript = metaDb.getString(base + "/" + (String)name);
                if (classOrScript.indexOf("/") < 0) {
                    stat.debug().send("Loading class: " + classOrScript);
                    Class.forName(classOrScript);
                    continue;
                }
                stat.debug().send("Running script: " + classOrScript);
                ContentInterface ci = (ContentInterface)Beans.lookup(sc, classOrScript);
                EngineContext context = new EngineContext(false, sc);
                context.put("sessionController", sc);
                context.put("sc", sc);
                context.put("sessionControllerAdmin", sc);
                context.put("sca", sc);
                stat.debug().send("Script result: " + context.exec(ci));
            }
            catch (Exception | NoClassDefFoundError e) {
                stat.warning().exception(e).send("Could not run autostart handler: " + (String)name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whenUpdatesFinished(Runnable handler) {
        List<Runnable> list = updateFinishedHandlers;
        synchronized (list) {
            if (!updatesFinished) {
                updateFinishedHandlers.add(handler);
                return;
            }
        }
        new Thread(handler).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whenReady(Runnable handler) {
        List<Runnable> list = readyHandlers;
        synchronized (list) {
            if (!ready) {
                readyHandlers.add(handler);
                return;
            }
        }
        new Thread(handler).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void whenApiReady(Runnable handler) {
        List<Runnable> list = readyApiHandlers;
        synchronized (list) {
            if (!apiReady) {
                readyApiHandlers.add(handler);
                return;
            }
        }
        new Thread(handler).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ready() {
        List<Runnable> list = readyHandlers;
        synchronized (list) {
            ready = true;
        }
        Startup.callHandlers(readyHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatesFinished() {
        List<Runnable> list = updateFinishedHandlers;
        synchronized (list) {
            updatesFinished = true;
        }
        Startup.callHandlers(updateFinishedHandlers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void apiReady() {
        List<Runnable> list = readyApiHandlers;
        synchronized (list) {
            apiReady = true;
        }
        Startup.callHandlers(readyApiHandlers);
    }

    private static void callHandlers(List<Runnable> handlers) {
        for (Runnable handler : handlers) {
            try {
                handler.run();
            }
            catch (Exception e) {
                CoreStatistic.getInstance().error((Throwable)e);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw t;
            }
        }
    }

    public static boolean isReady() {
        return ready;
    }

    public static boolean isApiReady() {
        return apiReady;
    }

    public static boolean isUpdatesFinished() {
        return updatesFinished;
    }

    static {
        Startup.whenReady(() -> Startup.run("whenReady"));
        Startup.whenApiReady(() -> Startup.run("whenApiReady"));
        Startup.whenUpdatesFinished(() -> Startup.run("whenUpdatesFinished"));
    }
}

