/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.roi.ejb.client.beans.FolderObjectClientBean;
import agorum.roi.ejb.client.beans.FolderPathRelationObjectClientBean;
import agorum.roi.ejb.client.beans.RelationObjectClientBean;
import agorum.roi.ejb.common.ExceptionUtils;
import agorum.roi.ejb.common.SessionController;
import agorum.roi.ejb.database.common.DatabaseInterface;
import agorum.roi.ejb.database.common.DatabaseUtils;
import agorum.roi.exception.RoiException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CycleUtils {
    private final SessionController sessionController;
    private DatabaseInterface dbi;

    public CycleUtils(SessionController sessionController) {
        this.sessionController = sessionController;
        try {
            this.dbi = new DatabaseUtils().getDatabaseInterfaceImpl();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void rebuildCycleChecker(Connection conn) throws Exception {
        try {
            this.deleteCyckleChecker(conn);
            FolderObjectClientBean rootFolder = this.initRootFolder(conn);
            this.insertRecursiveAllFolder(conn, rootFolder);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void insertRecursiveAllFolder(Connection conn, FolderObjectClientBean startFolder) throws Exception {
        try {
            RelationObjectClientBean[] roArr = startFolder.getRightwardRelations(FolderPathRelationObjectClientBean.CLASS_NAME);
            if (roArr != null) {
                int len = roArr.length;
                for (int i = 0; i < len; ++i) {
                    if (!this.sessionController.isFolder(roArr[i].getRightObject())) continue;
                    this.insertCycleChecker(conn, roArr[i].getLeftObject().getId(), roArr[i].getRightObject().getId());
                    this.insertRecursiveAllFolder(conn, (FolderObjectClientBean)roArr[i].getRightObject());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteCyckleChecker(Connection conn) throws Exception {
        Statement pstmt = null;
        try {
            pstmt = conn.prepareStatement(this.dbi.getCyckleCheckerStatement01());
            pstmt.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    private FolderObjectClientBean initRootFolder(Connection conn) throws Exception {
        FolderObjectClientBean focb = null;
        try {
            focb = this.sessionController.getRootFolder();
            this.insertCycleChecker(conn, 0L, focb.getId());
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        return focb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertCycleChecker(Connection conn, Long leftObject, Long rightObject) throws Exception {
        Statement pstmt = null;
        try {
            if (this.hasCycle(conn, rightObject, leftObject)) {
                ExceptionUtils.handleException("We have a CYCLE", "agorum.roi.remote.exception.WeHasACycle", 105);
            }
            pstmt = conn.prepareStatement(this.dbi.getCyckleCheckerStatement02());
            pstmt.setLong(1, leftObject);
            pstmt.setLong(2, rightObject);
            pstmt.execute();
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                pstmt.close();
                pstmt = null;
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCycleCheck(Connection conn, long leftObject, long rightObject) throws Exception {
        PreparedStatement pstmt = null;
        Statement pstmtDel = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(this.dbi.getCyckleCheckerStatement05Check());
            pstmt.setLong(1, rightObject);
            pstmt.setLong(2, leftObject);
            rs = pstmt.executeQuery();
            if (rs != null) {
                rs.next();
                int anz = rs.getInt(1);
                if (anz > 0) {
                    pstmtDel = conn.prepareStatement(this.dbi.getCyckleCheckerStatement05());
                    pstmtDel.setLong(1, rightObject);
                    pstmtDel.setLong(2, leftObject);
                    pstmtDel.execute();
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmtDel != null) {
                    pstmtDel.close();
                    pstmtDel = null;
                }
            }
            catch (Exception exception) {}
        }
    }

    public boolean hasCycle(Connection conn, Long leftObject, Long rightObject) throws RemoteException, RoiException {
        return this.hasCycle(conn, leftObject, rightObject, new HashSet<Long>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasCycle(Connection conn, Long leftObject, Long rightObject, Set<Long> checked) throws RemoteException, RoiException {
        if (leftObject.equals(rightObject)) {
            return true;
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(this.dbi.getCyckleCheckerStatement03());
            pstmt.setLong(1, rightObject);
            rs = pstmt.executeQuery();
            if (rs != null) {
                ArrayList<Long> toCheck = new ArrayList<Long>();
                while (rs.next()) {
                    Long id = rs.getLong(1);
                    if (checked.contains(id)) continue;
                    toCheck.add(id);
                }
                rs.close();
                rs = null;
                pstmt.close();
                pstmt = null;
                Iterator iterator = toCheck.iterator();
                while (true) {
                    if (iterator.hasNext()) {
                        Long id = (Long)iterator.next();
                        checked.add(id);
                        if (!this.hasCycle(conn, leftObject, id, checked)) continue;
                        boolean bl = true;
                        return bl;
                        continue;
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            ExceptionUtils.handleException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                    rs = null;
                }
            }
            catch (Exception exception) {}
            try {
                if (pstmt != null) {
                    pstmt.close();
                    pstmt = null;
                }
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean isFolderInFolder(Connection conn, long startFolderId, long subFolderId) throws Exception {
        return this.hasCycle(conn, startFolderId, subFolderId);
    }
}

