/*
 * Decompiled with CFR 0.152.
 */
package agorum.roi.common.utils;

import agorum.commons.logging.Log;
import agorum.commons.string.StringModifierUtils;
import agorum.roi.common.utils.Beans;
import agorum.roi.ejb.client.beans.GlobalObjectClientBean;
import agorum.roi.ejb.common.AttributeValue;
import agorum.roi.scripting.DefaultEngineContext;
import agorum.roi.scripting.EngineContext;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;

public class TemplateUtil {
    private static final Pattern STRING_PARAMETER = Pattern.compile("f?[0-9,\\-]*");

    private TemplateUtil() {
    }

    public static boolean hasPlaceholders(String template) {
        return template.contains("${");
    }

    public static String fillTemplate(GlobalObjectClientBean object, String template) throws Exception {
        return TemplateUtil.fillTemplate(object, null, template);
    }

    public static String fillTemplate(GlobalObjectClientBean object, String template, boolean clearEmpty) throws Exception {
        return TemplateUtil.fillTemplate(object, null, template, clearEmpty);
    }

    public static String fillTemplate(Map<String, ?> parameters, String template) throws Exception {
        return TemplateUtil.fillTemplate(null, parameters, template);
    }

    public static String fillTemplate(Map<String, ?> parameters, String template, boolean clearEmpty) throws Exception {
        return TemplateUtil.fillTemplate(null, parameters, template, clearEmpty);
    }

    public static String fillTemplate(GlobalObjectClientBean object, Map<String, ?> parameters, String template) throws Exception {
        return TemplateUtil.fillTemplate(object, parameters, template, false);
    }

    public static String fillTemplate(GlobalObjectClientBean object, Map<String, ?> parameters, String template, boolean clearEmpty) throws Exception {
        Object result = TemplateUtil.fill(object, parameters, template, clearEmpty);
        return result == null ? "" : result.toString();
    }

    public static Object fill(GlobalObjectClientBean object, Map<String, ?> parameters, String template, boolean clearEmpty) throws Exception {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (object != null) {
            Map<String, AttributeValue[]> metadata = object.getStructuredExtendedAttributesAll();
            for (Map.Entry<String, AttributeValue[]> entry : metadata.entrySet()) {
                AttributeValue[] values = entry.getValue();
                if (values == null || values.length <= 0) continue;
                attributes.put(entry.getKey(), values[0]);
            }
        }
        if (parameters != null) {
            attributes.putAll(parameters);
        }
        if (object != null) {
            attributes.put("id", object.getId());
            attributes.put("name", object.getName());
            attributes.put("description", object.getDescription());
            attributes.put("createdate", object.getCreateDate());
            attributes.put("lastmodifydate", object.getLastModifyDate());
            attributes.put("updatedate", object.getUpdateDate());
        }
        attributes.put("date", new Date());
        if (template.startsWith("#{") && template.endsWith("}")) {
            DefaultEngineContext ec = new DefaultEngineContext();
            Object object2 = null;
            try {
                ec.putAll((Map<? extends String, ? extends Object>)attributes);
                Object object3 = ec.eval(template.substring(2, template.length() - 1));
                return object3;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (ec != null) {
                    if (object2 != null) {
                        try {
                            ec.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ec.close();
                    }
                }
            }
        }
        Context context = new Context(template, attributes, object, clearEmpty);
        TemplateUtil.fillPlaceholders(context, Pattern.compile("\\$\\{\\{(.+?)(?=\\}\\})\\}\\}", 32));
        TemplateUtil.fillPlaceholders(context, Pattern.compile("\\$\\{(.+?)(?=\\})\\}"));
        return context.template;
    }

    private static void fillPlaceholders(Context context, Pattern p) throws Exception {
        int start;
        String template = context.template;
        Matcher m = p.matcher(template);
        if (!m.find()) {
            return;
        }
        do {
            start = m.start();
            String contents = m.group(1);
            String replacement = contents.startsWith("js:") ? TemplateUtil.fillScriptPlaceholder(context, contents) : TemplateUtil.fillVariablePlaceholder(context, contents);
            if (replacement != null) {
                template = template.replace(m.group(0), replacement);
                m = p.matcher(template);
                start += replacement.length();
                continue;
            }
            if (context.clearEmpty) {
                template = template.replace(m.group(0), "");
                m = p.matcher(template);
                continue;
            }
            start = m.end();
        } while (m.find(start));
        context.template = template;
    }

    private static String fillScriptPlaceholder(Context context, String contents) throws Exception {
        int i;
        String script;
        Object result;
        if (context.engineContext == null) {
            context.engineContext = new DefaultEngineContext();
            context.engineContext.putAll(context.attributes);
        }
        if ((result = context.engineContext.eval(script = contents.substring((i = contents.indexOf(58)) + 1))) != null) {
            return result.toString();
        }
        return "";
    }

    private static String fillVariablePlaceholder(Context context, String contents) throws Exception {
        Object value;
        String variable = contents;
        String parameters = "";
        int i = contents.indexOf(58);
        if (i >= 0) {
            variable = contents.substring(0, i);
            parameters = contents.substring(i + 1);
        }
        if ((value = context.flatVariables.get(variable.toLowerCase())) == null) {
            value = Beans.get(context.object == null ? null : context.object.getSessionController(), context.attributes, variable);
        }
        if (value == null && context.object != null) {
            value = Beans.get(context.object.getSessionController(), context.object, variable);
        }
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof String && !parameters.isEmpty() && !STRING_PARAMETER.matcher(parameters).matches()) {
                try {
                    value = DatatypeConverter.parseDateTime((String)((String)value)).getTime();
                }
                catch (Exception e) {
                    Log.debug((Throwable)e);
                }
            }
            if (value instanceof Date) {
                return TemplateUtil.fillDateVariablePlaceholder(parameters, (Date)value);
            }
            if (value instanceof Double || value instanceof Float || value instanceof Long || value instanceof Integer) {
                return TemplateUtil.fillNumberVariablePlaceholder(parameters, value);
            }
            return TemplateUtil.fillStringVariablePlaceholder(parameters, value.toString());
        }
        catch (Exception e) {
            throw new Exception("Could not fill placeholder " + contents + " using value " + value, e);
        }
    }

    private static Locale getLocale(String tag) {
        Locale locale = Locale.forLanguageTag(tag);
        try {
            if (!(locale == null || locale.getISO3Language() == null || locale.getISO3Country() == null || locale.getISO3Language().isEmpty() && locale.getISO3Country().isEmpty())) {
                return locale;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    private static Date offset(String offset, Date value) {
        int amount;
        int field;
        if (offset.startsWith("y")) {
            field = 1;
        } else if (offset.startsWith("M")) {
            field = 2;
        } else if (offset.startsWith("d")) {
            field = 5;
        } else if (offset.startsWith("H")) {
            field = 11;
        } else if (offset.startsWith("h")) {
            field = 10;
        } else if (offset.startsWith("m")) {
            field = 12;
        } else if (offset.startsWith("s")) {
            field = 13;
        } else {
            return null;
        }
        try {
            amount = Integer.parseInt(offset.substring(1));
        }
        catch (NumberFormatException e) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(value);
        ((Calendar)cal).add(field, amount);
        return cal.getTime();
    }

    private static String fillDateVariablePlaceholder(String parameters, Date value) {
        Locale locale = null;
        String format = null;
        Date date = null;
        for (String parameter : parameters.split("[|]")) {
            if (locale == null && (locale = TemplateUtil.getLocale(parameter)) != null || date == null && (date = TemplateUtil.offset(parameter, value)) != null || parameter.isEmpty()) continue;
            format = parameter;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (date == null) {
            date = value;
        }
        if (format == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", locale);
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            return sdf.format(date);
        }
        return new SimpleDateFormat(format, locale).format(date);
    }

    private static String fillNumberVariablePlaceholder(String parameters, Object value) {
        DecimalFormat df;
        if ((value instanceof Long || value instanceof Integer) && parameters.length() <= 0) {
            return value.toString();
        }
        int i = parameters.indexOf("|");
        if (i > 0) {
            df = new DecimalFormat(parameters.substring(i + 1), new DecimalFormatSymbols(Locale.forLanguageTag(parameters.substring(0, i))));
        } else {
            df = new DecimalFormat();
            df.setDecimalFormatSymbols(new DecimalFormatSymbols(Locale.forLanguageTag(parameters)));
        }
        return df.format(value);
    }

    private static String fillStringVariablePlaceholder(String parameters, String value) {
        boolean filter = false;
        if (parameters.startsWith("f")) {
            filter = true;
            parameters = parameters.substring(1);
        }
        if (!parameters.isEmpty() && !value.isEmpty()) {
            int sliceStart = 1;
            int sliceEnd = value.length();
            int i = parameters.indexOf(",");
            if (i < 0) {
                int singleValue = Integer.parseInt(parameters);
                if (singleValue > 0) {
                    sliceEnd = singleValue;
                } else {
                    sliceStart = singleValue;
                }
            } else {
                sliceStart = Integer.parseInt(parameters.substring(0, i));
                sliceEnd = Integer.parseInt(parameters.substring(i + 1));
            }
            if (sliceStart < 0) {
                sliceStart = value.length() + sliceStart + 1;
            }
            if (sliceEnd < 0) {
                sliceEnd = value.length() + sliceEnd + 1;
            }
            if (sliceStart > sliceEnd) {
                int temp = sliceStart;
                sliceStart = sliceEnd;
                sliceEnd = temp;
            }
            if (sliceStart < 1) {
                sliceStart = 1;
            }
            if (sliceEnd < 1) {
                sliceEnd = 1;
            }
            if (sliceStart > value.length()) {
                sliceStart = value.length();
            }
            if (sliceEnd > value.length()) {
                sliceEnd = value.length();
            }
            value = value.substring(--sliceStart, sliceEnd);
        }
        if (filter) {
            value = StringModifierUtils.filterFileNameChars((String)value, (String)"_");
        }
        return value;
    }

    private static class Context {
        public String template;
        public final Map<String, Object> attributes;
        public final GlobalObjectClientBean object;
        public final boolean clearEmpty;
        public final Map<String, Object> flatVariables = new HashMap<String, Object>();
        public EngineContext engineContext;

        public Context(String template, Map<String, Object> attributes, GlobalObjectClientBean object, boolean clearEmpty) {
            this.template = template;
            this.attributes = attributes;
            this.object = object;
            this.clearEmpty = clearEmpty;
            this.initializeVariable("", attributes);
        }

        private void initializeVariable(String key, Object value) {
            if (value instanceof Map) {
                if (key.length() > 0) {
                    key = key + ".";
                }
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    this.initializeVariable(key + entry.getKey().toString().toLowerCase(), entry.getValue());
                }
            } else if (value instanceof Iterable) {
                int i = 0;
                key = key + "[";
                for (Object item : (Iterable)value) {
                    this.initializeVariable(key + i++ + "]", item);
                }
            } else if (value instanceof Object[]) {
                int i = 0;
                key = key + "[";
                for (Object item : (Object[])value) {
                    this.initializeVariable(key + i++ + "]", item);
                }
            } else if (value instanceof AttributeValue) {
                this.initializeVariable(key, ((AttributeValue)value).getObject());
            } else {
                this.flatVariables.put(key, value);
            }
        }
    }
}

